/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base;

import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Fixes", description="A few fixes")
@LoadFeature(module="insanelib:base")
public class FixFeature
extends Feature {
    @Config
    @Label(name="Fix Follow Range", description="If true, mobs will have their follow range fixed. https://bugs.mojang.com/browse/MC-145656")
    public static Boolean fixFollowRange = true;
    @Config
    @Label(name="Remove Zombies Bonus Health", description="Removes the random bonus health given to Leader Zombies. In vanilla it's useless since doesn't work. https://minecraft.fandom.com/wiki/Attribute#Vanilla_modifiers")
    public static Boolean removeZombiesBonusHealth = true;
    @Config
    @Label(name="Fix Flying Speed", description="When affected by slowness the player can still jump really far away. When true, jumps length will be calculated based off player's movement speed.")
    public static Boolean fixFlyingSpeed = true;
    @Config
    @Label(name="Fix Jump Movement Factor Slowdown Only", description="The fix for Jump Movement Factor is applied only when the player is slowed down. If false, the player will jump really farther when going faster.")
    public static Boolean slowdownOnly = true;

    public FixFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @Override
    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.fixFollowRange(event.getEntity());
        this.removeZombiesBonusHealth(event.getEntity());
    }

    private void removeZombiesBonusHealth(Entity entity) {
        Zombie zombie;
        if (!removeZombiesBonusHealth.booleanValue() || !(entity instanceof Zombie) || (zombie = (Zombie)entity).m_21051_(Attributes.f_22276_) == null) {
            return;
        }
        Set modifiers = zombie.m_21051_(Attributes.f_22276_).m_22122_();
        for (AttributeModifier attributeModifier : modifiers) {
            if (!attributeModifier.m_22214_().equals("Leader zombie bonus")) continue;
            Objects.requireNonNull(zombie.m_21051_(Attributes.f_22276_)).m_22120_(attributeModifier.m_22209_());
        }
    }

    private void fixFollowRange(Entity entity) {
        if (!fixFollowRange.booleanValue() || !(entity instanceof Mob)) {
            return;
        }
        Mob mobEntity = (Mob)entity;
        AttributeInstance followRangeAttribute = mobEntity.m_21051_(Attributes.f_22277_);
        if (followRangeAttribute != null) {
            for (WrappedGoal pGoal : mobEntity.f_21346_.f_25345_) {
                Goal goal = pGoal.m_26015_();
                if (goal instanceof NearestAttackableTargetGoal) {
                    NearestAttackableTargetGoal nearestAttackableTargetGoal = (NearestAttackableTargetGoal)goal;
                    nearestAttackableTargetGoal.f_26051_.m_26883_(mobEntity.m_21133_(Attributes.f_22277_));
                    continue;
                }
                goal = pGoal.m_26015_();
                if (!(goal instanceof ILNearestAttackableTargetGoal)) continue;
                ILNearestAttackableTargetGoal nearestAttackableTarget = (ILNearestAttackableTargetGoal)goal;
                nearestAttackableTarget.targetEntitySelector.m_26883_(mobEntity.m_21133_(Attributes.f_22277_));
            }
        }
    }

    public static Optional<Float> getFlyingSpeed(Player player) {
        double playerSpeedRatio;
        if (!Feature.isEnabled(FixFeature.class) || !fixFlyingSpeed.booleanValue()) {
            return Optional.empty();
        }
        float baseFlyingSpeed = 0.02f;
        if (player.m_20142_()) {
            baseFlyingSpeed += 0.006f;
        }
        if ((playerSpeedRatio = MCUtils.getMovementSpeedRatio((LivingEntity)player)) > 1.0 && slowdownOnly.booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf((float)(playerSpeedRatio * (double)baseFlyingSpeed)));
    }
}

