/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.compat;

import com.copycatsplus.copycats.config.FeatureToggle;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.compat.Mods;
import com.hlysine.create_connected.config.CCConfigs;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class CopycatsManager {
    public static Map<String, BlockEntry<?>> BLOCK_MAP = new HashMap();
    public static Map<String, ItemEntry<?>> ITEM_MAP = new HashMap();
    public static final Map<Level, Set<BlockPos>> migrationQueue = Collections.synchronizedMap(new WeakHashMap());

    public static Block convert(Block self) {
        BlockEntry<?> result = BLOCK_MAP.get(RegisteredObjects.getKeyOrThrow((Block)self).m_135815_());
        if (result != null) {
            return (Block)result.get();
        }
        return self;
    }

    public static Item convert(Item self) {
        ItemEntry<?> result = ITEM_MAP.get(RegisteredObjects.getKeyOrThrow((Item)self).m_135815_());
        if (result != null) {
            return (Item)result.get();
        }
        BlockEntry<?> blockResult = BLOCK_MAP.get(RegisteredObjects.getKeyOrThrow((Item)self).m_135815_());
        if (blockResult != null) {
            return blockResult.m_5456_();
        }
        return self;
    }

    public static ItemLike convert(ItemLike self) {
        return CopycatsManager.convert(self.m_5456_());
    }

    public static BlockState convert(BlockState state) {
        Block converted = CopycatsManager.convert(state.m_60734_());
        if (state.m_60734_() == converted) {
            return state;
        }
        BlockState newState = converted.m_49966_();
        for (Property property : state.m_61147_()) {
            newState = CopycatsManager.copyProperty(state, newState, property);
        }
        return newState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    public static Block convertIfEnabled(Block block) {
        if (CopycatsManager.isFeatureEnabled(RegisteredObjects.getKeyOrThrow((Block)block))) {
            return CopycatsManager.convert(block);
        }
        return block;
    }

    public static BlockState convertIfEnabled(BlockState state) {
        if (CopycatsManager.isFeatureEnabled(RegisteredObjects.getKeyOrThrow((Block)state.m_60734_()))) {
            return CopycatsManager.convert(state);
        }
        return state;
    }

    public static ItemLike convertIfEnabled(ItemLike item) {
        if (CopycatsManager.isFeatureEnabled(RegisteredObjects.getKeyOrThrow((Item)item.m_5456_()))) {
            return CopycatsManager.convert(item);
        }
        return item;
    }

    public static boolean existsInCopycats(ResourceLocation key) {
        if (BLOCK_MAP.containsKey(key.m_135815_())) {
            return true;
        }
        return ITEM_MAP.containsKey(key.m_135815_());
    }

    public static boolean isFeatureEnabled(ResourceLocation key) {
        if (!CopycatsManager.existsInCopycats(key)) {
            return false;
        }
        return FeatureToggle.isEnabled((ResourceLocation)Mods.COPYCATS.rl(key.m_135815_()));
    }

    public static void enqueueMigration(Level level, BlockPos pos) {
        migrationQueue.computeIfAbsent(level, $ -> Collections.synchronizedSet(new LinkedHashSet())).add(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.haveTime() && event.side == LogicalSide.SERVER) {
            if (!((Boolean)CCConfigs.common().migrateCopycatsOnInitialize.get()).booleanValue()) {
                migrationQueue.clear();
                return;
            }
            Level level = event.level;
            Map<Level, Set<BlockPos>> map = migrationQueue;
            synchronized (map) {
                if (migrationQueue.containsKey(level)) {
                    Set<BlockPos> list;
                    Set<BlockPos> set = list = migrationQueue.get(level);
                    synchronized (set) {
                        if (list.size() > 0) {
                            CreateConnected.LOGGER.debug("Copycats: Migrated " + list.size() + " copycats in " + level.m_46472_().m_135782_());
                        }
                        Iterator<BlockPos> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            BlockPos pos = iterator.next();
                            if (!level.m_46749_(pos)) {
                                iterator.remove();
                                continue;
                            }
                            BlockState state = level.m_8055_(pos);
                            BlockState converted = CopycatsManager.convert(state);
                            if (!converted.m_60713_(state.m_60734_())) {
                                level.m_7731_(pos, converted, 50);
                            }
                            iterator.remove();
                        }
                    }
                }
            }
        }
    }

    static {
        BLOCK_MAP.put(CCBlocks.COPYCAT_BLOCK.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BLOCK);
        BLOCK_MAP.put(CCBlocks.COPYCAT_SLAB.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_SLAB);
        BLOCK_MAP.put(CCBlocks.COPYCAT_BEAM.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BEAM);
        BLOCK_MAP.put(CCBlocks.COPYCAT_VERTICAL_STEP.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_VERTICAL_STEP);
        BLOCK_MAP.put(CCBlocks.COPYCAT_STAIRS.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_STAIRS);
        BLOCK_MAP.put(CCBlocks.COPYCAT_FENCE.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_FENCE);
        BLOCK_MAP.put(CCBlocks.COPYCAT_FENCE_GATE.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_FENCE_GATE);
        BLOCK_MAP.put(CCBlocks.COPYCAT_WALL.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_WALL);
        BLOCK_MAP.put(CCBlocks.COPYCAT_BOARD.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BOARD);
        ITEM_MAP.put(CCItems.COPYCAT_BOX.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCItems.COPYCAT_BOX);
        ITEM_MAP.put(CCItems.COPYCAT_CATWALK.getKey().m_135782_().m_135815_(), com.copycatsplus.copycats.CCItems.COPYCAT_CATWALK);
    }
}

