/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class WizardEntry {
    private static final HashMap<String, WizardEntry> ENTRY_LOOKUP = new LinkedHashMap<String, WizardEntry>();
    public static final WizardEntry Meta = WizardEntry.register("Meta", Type.CATEGORY, new WizardEntry[0]);
    public static final WizardEntry NAME = WizardEntry.register("NAME", Type.TEXT, new WizardEntry[0]);
    public static final WizardEntry DESCRIPTION = WizardEntry.register("DESCRIPTION", Type.TEXT, NAME);
    public static final WizardEntry AUTHORS = WizardEntry.register("AUTHORS", Type.TEXT, NAME);
    public static final WizardEntry Model = WizardEntry.register("Model", Type.CATEGORY, NAME);
    public static final WizardEntry DUMMY_MODEL = WizardEntry.register("DUMMY_MODEL", Model);
    public static final WizardEntry PLAYER_MODEL = WizardEntry.register("PLAYER_MODEL", DUMMY_MODEL);
    public static final WizardEntry SLIM = WizardEntry.register("SLIM", PLAYER_MODEL);
    public static final WizardEntry CAPE = WizardEntry.register("CAPE", DUMMY_MODEL);
    public static final WizardEntry ELYTRA = WizardEntry.register("ELYTRA", DUMMY_MODEL);
    public static final WizardEntry Pivots = WizardEntry.register("Pivots", Type.CATEGORY, DUMMY_MODEL);
    public static final WizardEntry ITEMS_PIVOT = WizardEntry.register("ITEMS_PIVOT", Pivots);
    public static final WizardEntry SPYGLASS_PIVOT = WizardEntry.register("SPYGLASS_PIVOT", Pivots);
    public static final WizardEntry HELMET_ITEM_PIVOT = WizardEntry.register("HELMET_ITEM_PIVOT", Pivots);
    public static final WizardEntry PARROTS_PIVOT = WizardEntry.register("PARROTS_PIVOT", Pivots);
    public static final WizardEntry ARMOR_PIVOTS = WizardEntry.register("ARMOR_PIVOTS", Pivots);
    public static final WizardEntry Scripting = WizardEntry.register("Scripting", Type.CATEGORY, NAME);
    public static final WizardEntry DUMMY_SCRIPT = WizardEntry.register("DUMMY_SCRIPT", Scripting);
    public static final WizardEntry HIDE_PLAYER = WizardEntry.register("HIDE_PLAYER", PLAYER_MODEL, DUMMY_SCRIPT);
    public static final WizardEntry HIDE_ARMOR = WizardEntry.register("HIDE_ARMOR", DUMMY_SCRIPT);
    public static final WizardEntry HIDE_CAPE = WizardEntry.register("HIDE_CAPE", DUMMY_SCRIPT);
    public static final WizardEntry HIDE_ELYTRA = WizardEntry.register("HIDE_ELYTRA", DUMMY_SCRIPT);
    public static final WizardEntry EMPTY_EVENTS = WizardEntry.register("EMPTY_EVENTS", DUMMY_SCRIPT);
    public final String name;
    public final Type type;
    public final WizardEntry[] dependencies;

    public static WizardEntry get(String name) {
        return ENTRY_LOOKUP.get(name);
    }

    public static boolean exists(String name) {
        return ENTRY_LOOKUP.containsKey(name);
    }

    public static Collection<WizardEntry> all() {
        return ENTRY_LOOKUP.values();
    }

    WizardEntry(String name, WizardEntry ... dependencies) {
        this(name, Type.TOGGLE, dependencies);
    }

    WizardEntry(String name, Type type, WizardEntry ... dependencies) {
        this.name = name;
        this.type = type;
        this.dependencies = dependencies;
    }

    public boolean validate(Object object) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.TOGGLE -> object instanceof Boolean;
            case Type.TEXT -> object instanceof String;
            case Type.CATEGORY -> true;
        };
    }

    public boolean asBool(HashMap<WizardEntry, Object> map) {
        Object object = map.get(this);
        return this.type == Type.TOGGLE && object != null && (Boolean)object != false;
    }

    public static WizardEntry register(String name, Type type, WizardEntry ... dependencies) {
        WizardEntry entry = new WizardEntry(name, type, dependencies);
        ENTRY_LOOKUP.put(name, entry);
        return entry;
    }

    public static WizardEntry register(String name, WizardEntry ... dependencies) {
        return WizardEntry.register(name, Type.TOGGLE, dependencies);
    }

    public static enum Type {
        TOGGLE,
        TEXT,
        CATEGORY;

    }
}

