/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.LivingEntityRendererAccessor;
import org.figuramc.figura.gui.PopupMenu;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.model.rendering.PartFilterScheme;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.ui.UIHelper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    @Shadow
    @Final
    protected List<RenderLayer<T, M>> f_115291_;
    @Unique
    private Avatar currentAvatar;
    @Unique
    private Matrix4f lastPose;

    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Shadow
    protected abstract boolean m_5933_(T var1);

    @Shadow
    public static int m_115338_(LivingEntity entity, float whiteOverlayProgress) {
        return 0;
    }

    @Shadow
    protected abstract float m_6931_(T var1, float var2);

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void onRender(T livingEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        this.currentAvatar = AvatarManager.getAvatar(livingEntity);
        if (this.currentAvatar == null) {
            return;
        }
        this.lastPose = poseStack.m_85850_().m_252922_();
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"), method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, index=3)
    private int customOverlay(int thing) {
        return LivingEntityRendererAccessor.overrideOverlay.orElse(thing);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void preRender(T entity, float yaw, float delta, PoseStack poseStack, MultiBufferSource bufferSource, int light, CallbackInfo ci) {
        boolean showBody;
        if (this.currentAvatar == null) {
            return;
        }
        if (Avatar.firstPerson) {
            this.currentAvatar.updateMatrices((LivingEntityRenderer)this, poseStack);
            this.currentAvatar = null;
            this.lastPose = null;
            poseStack.m_85849_();
            ci.cancel();
            return;
        }
        if (this.currentAvatar.luaRuntime != null) {
            VanillaGroupPart part = this.currentAvatar.luaRuntime.vanilla_model.PLAYER;
            EntityModel model = this.m_7200_();
            ((VanillaPart)part).save(model);
            if (this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform(model);
            }
        }
        boolean translucent = !(showBody = this.m_5933_(entity)) && Minecraft.m_91087_().f_91074_ != null && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        boolean glowing = !showBody && Minecraft.m_91087_().m_91314_(entity);
        boolean invisible = !translucent && !showBody && !glowing;
        PartFilterScheme filter = invisible ? PartFilterScheme.PIVOTS : PartFilterScheme.MODEL;
        int overlay = LivingEntityRendererMixin.m_115338_(entity, this.m_6931_(entity, delta));
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this.currentAvatar);
        FiguraMod.pushProfiler("calculateMatrix");
        Matrix4f diff = new Matrix4f((Matrix4fc)this.lastPose).invert().mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        FiguraMat4 poseMatrix = new FiguraMat4().set(diff);
        FiguraMod.popPushProfiler("renderEvent");
        this.currentAvatar.renderEvent(delta, poseMatrix);
        FiguraMod.popPushProfiler("render");
        this.currentAvatar.render((Entity)entity, yaw, delta, translucent ? 0.15f : 1.0f, poseStack, bufferSource, light, overlay, (LivingEntityRenderer<?, ?>)((LivingEntityRenderer)this), filter, translucent, glowing);
        FiguraMod.popPushProfiler("postRenderEvent");
        this.currentAvatar.postRenderEvent(delta, poseMatrix);
        FiguraMod.popProfiler(3);
        if (this.currentAvatar.luaRuntime != null && this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
            this.currentAvatar.luaRuntime.vanilla_model.PLAYER.posTransform(this.m_7200_());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void endRender(T entity, float yaw, float delta, PoseStack matrices, MultiBufferSource bufferSource, int light, CallbackInfo ci) {
        if (this.currentAvatar == null) {
            return;
        }
        if (this.currentAvatar.luaRuntime != null && this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
            this.currentAvatar.luaRuntime.vanilla_model.PLAYER.restore(this.m_7200_());
        }
        this.currentAvatar = null;
        this.lastPose = null;
    }

    @Inject(method={"shouldShowName(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldShowName(T livingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (UIHelper.paperdoll) {
            cir.setReturnValue((Object)((Boolean)Configs.PREVIEW_NAMEPLATE.value));
        } else if (!Minecraft.m_91404_() || livingEntity.m_20148_().equals(PopupMenu.getEntityId())) {
            cir.setReturnValue((Object)false);
        } else if (!AvatarManager.panic) {
            if (((Boolean)Configs.SELF_NAMEPLATE.value).booleanValue() && livingEntity == Minecraft.m_91087_().f_91074_) {
                cir.setReturnValue((Object)true);
            } else if ((Integer)Configs.NAMEPLATE_RENDER.value == 2 || (Integer)Configs.NAMEPLATE_RENDER.value == 1 && livingEntity != FiguraMod.extendedPickEntity) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"isEntityUpsideDown"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isEntityUpsideDown(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Boolean upsideDown;
        Avatar avatar = AvatarManager.getAvatar((Entity)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && (upsideDown = avatar.luaRuntime.renderer.upsideDown) != null) {
            cir.setReturnValue((Object)upsideDown);
        }
    }
}

