/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.mixin.render.PoseStackAccessor;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private EntityRenderDispatcher f_109463_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Final
    private Minecraft f_109461_;

    @ModifyArg(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private Entity renderLevelRenderEntity(Entity entity) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar != null) {
            avatar.renderMode = EntityRenderMode.RENDER;
        }
        return entity;
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")})
    private void renderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource bufferSource, CallbackInfo ci) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar == null) {
            return;
        }
        if (bufferSource instanceof OutlineBufferSource) {
            OutlineBufferSource outline = (OutlineBufferSource)bufferSource;
            if (RenderUtils.vanillaModelAndScript(avatar) && avatar.luaRuntime.renderer.outlineColor != null) {
                int i = ColorUtils.rgbToInt(avatar.luaRuntime.renderer.outlineColor);
                outline.m_109929_(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, 255);
            }
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(avatar);
        FiguraMod.pushProfiler("worldRender");
        avatar.worldRender(entity, cameraX, cameraY, cameraZ, matrices, bufferSource, this.f_109463_.m_114394_(entity, tickDelta), tickDelta, EntityRenderMode.WORLD);
        FiguraMod.popProfiler(3);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void renderLevelFirstPerson(PoseStack stack, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        LivingEntity livingEntity;
        MultiBufferSource.BufferSource bufferSource;
        block7: {
            block6: {
                if (camera.m_90594_()) {
                    return;
                }
                Entity e = camera.m_90592_();
                Avatar avatar = AvatarManager.getAvatar(e);
                if (avatar == null) {
                    return;
                }
                bufferSource = this.f_109464_.m_110104_();
                avatar.firstPersonWorldRender(e, (MultiBufferSource)bufferSource, stack, camera, tickDelta);
                if (!(e instanceof LivingEntity)) break block6;
                livingEntity = (LivingEntity)e;
                if (((Boolean)Configs.FIRST_PERSON_MATRICES.value).booleanValue()) break block7;
            }
            return;
        }
        Avatar.firstPerson = true;
        int size = ((PoseStackAccessor)stack).getPoseStack().size();
        stack.m_85836_();
        EntityRenderer entityRenderer = this.f_109463_.m_114382_((Entity)livingEntity);
        Vec3 offset = entityRenderer.m_7860_((Entity)livingEntity, tickDelta);
        Vec3 cam = camera.m_90583_();
        stack.m_85837_(Mth.m_14139_((double)tickDelta, (double)livingEntity.f_19790_, (double)livingEntity.m_20185_()) - cam.m_7096_() + offset.m_7096_(), Mth.m_14139_((double)tickDelta, (double)livingEntity.f_19791_, (double)livingEntity.m_20186_()) - cam.m_7098_() + offset.m_7098_(), Mth.m_14139_((double)tickDelta, (double)livingEntity.f_19792_, (double)livingEntity.m_20189_()) - cam.m_7094_() + offset.m_7094_());
        float yaw = Mth.m_14179_((float)tickDelta, (float)livingEntity.f_19859_, (float)livingEntity.m_146908_());
        entityRenderer.m_7392_((Entity)livingEntity, yaw, tickDelta, stack, (MultiBufferSource)bufferSource, 0xF000F0);
        do {
            stack.m_85849_();
        } while (((PoseStackAccessor)stack).getPoseStack().size() > size);
        Avatar.firstPerson = false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        AvatarManager.executeAll("worldRender", avatar -> avatar.render(tickDelta));
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void afterRenderLevel(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        AvatarManager.executeAll("postWorldRender", avatar -> avatar.postWorldRenderEvent(tickDelta));
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=6)
    private float renderHitOutlineX(float x) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.f_109461_.m_91288_());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return x;
        }
        return (float)color.x;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=7)
    private float renderHitOutlineY(float y) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.f_109461_.m_91288_());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return y;
        }
        return (float)color.y;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=8)
    private float renderHitOutlineZ(float z) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.f_109461_.m_91288_());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return z;
        }
        return (float)color.z;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=9)
    private float renderHitOutlineW(float w) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.f_109461_.m_91288_());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return w;
        }
        return (float)color.w;
    }
}

