/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.ActionWheel;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.PopupMenu;
import org.figuramc.figura.gui.screens.WardrobeScreen;
import org.figuramc.figura.lua.FiguraLuaPrinter;
import org.figuramc.figura.utils.FiguraText;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Final
    public MouseHandler f_91067_;
    @Shadow
    @Final
    public Options f_91066_;
    @Shadow
    public LocalPlayer f_91074_;
    @Shadow
    public Entity f_91075_;
    @Unique
    private boolean scriptMouseUnlock = false;

    @Shadow
    public abstract void m_91152_(@Nullable Screen var1);

    @Inject(at={@At(value="RETURN")}, method={"handleKeybinds"})
    private void handleKeybinds(CallbackInfo ci) {
        Avatar avatar;
        if (AvatarManager.panic) {
            return;
        }
        if (Configs.RELOAD_BUTTON.keyBind.m_90859_()) {
            AvatarManager.reloadAvatar(FiguraMod.getLocalPlayerUUID());
            FiguraToast.sendToast(FiguraText.of("toast.reload"));
        }
        if (Configs.WARDROBE_BUTTON.keyBind.m_90859_()) {
            this.m_91152_(new WardrobeScreen(null));
        }
        Boolean wheel = null;
        if ((Integer)Configs.ACTION_WHEEL_MODE.value % 2 == 1) {
            if (Configs.ACTION_WHEEL_BUTTON.keyBind.m_90859_()) {
                wheel = !ActionWheel.isEnabled();
            }
        } else if (Configs.ACTION_WHEEL_BUTTON.keyBind.m_90857_()) {
            wheel = true;
        } else if (ActionWheel.isEnabled()) {
            wheel = false;
        }
        if (wheel != null) {
            if (wheel.booleanValue()) {
                ActionWheel.setEnabled(true);
                this.f_91067_.m_91602_();
            } else {
                if ((Integer)Configs.ACTION_WHEEL_MODE.value >= 2) {
                    ActionWheel.execute(ActionWheel.getSelected(), true);
                }
                ActionWheel.setEnabled(false);
                this.f_91067_.m_91601_();
            }
        }
        if (Configs.POPUP_BUTTON.keyBind.m_90857_()) {
            PopupMenu.setEnabled(true);
            if (!PopupMenu.hasEntity()) {
                Entity target = FiguraMod.extendedPickEntity;
                if (this.f_91074_ != null && target instanceof Player && !target.m_20177_((Player)this.f_91074_)) {
                    PopupMenu.setEntity(target);
                } else if (!this.f_91066_.m_92176_().m_90612_()) {
                    PopupMenu.setEntity(this.f_91075_);
                }
            }
        } else if (PopupMenu.isEnabled()) {
            PopupMenu.run();
        }
        if ((avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) != null && avatar.luaRuntime != null && avatar.luaRuntime.host.unlockCursor) {
            this.f_91067_.m_91602_();
            this.scriptMouseUnlock = true;
        } else if (this.scriptMouseUnlock) {
            this.f_91067_.m_91601_();
            this.scriptMouseUnlock = false;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getInventory()Lnet/minecraft/world/entity/player/Inventory;")}, method={"handleKeybinds"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void handleHotbarSlots(CallbackInfo ci, int i) {
        if (PopupMenu.isEnabled()) {
            PopupMenu.hotbarKeyPressed(i);
        }
        if (ActionWheel.isEnabled()) {
            ActionWheel.hotbarKeyPressed(i);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setScreen"})
    private void setScreen(Screen screen, CallbackInfo ci) {
        if (ActionWheel.isEnabled()) {
            ActionWheel.setEnabled(false);
        }
        if (PopupMenu.isEnabled()) {
            PopupMenu.run();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"})
    private void clearLevel(Screen screen, CallbackInfo ci) {
        AvatarManager.clearAllAvatars();
        FiguraLuaPrinter.clearPrintQueue();
        NetworkStuff.unsubscribeAll();
    }

    @Inject(at={@At(value="RETURN")}, method={"setLevel"})
    private void setLevel(ClientLevel world, CallbackInfo ci) {
        NetworkStuff.auth();
    }

    @Inject(at={@At(value="HEAD")}, method={"runTick"})
    private void preTick(boolean tick, CallbackInfo ci) {
        AvatarManager.executeAll("applyBBAnimations", Avatar::applyAnimations);
    }

    @Inject(at={@At(value="RETURN")}, method={"runTick"})
    private void afterTick(boolean tick, CallbackInfo ci) {
        AvatarManager.executeAll("clearBBAnimations", Avatar::clearAnimations);
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void startTick(CallbackInfo ci) {
        FiguraMod.pushProfiler("figura");
        FiguraMod.tick();
        FiguraMod.popProfiler();
    }
}

