/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.sound;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.SoundBuffer;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.LuaUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="Sound", value="sound")
public class LuaSound {
    private final Avatar owner;
    private final String id;
    private final SoundBuffer buffer;
    private final Sound sound;
    private ChannelAccess.ChannelHandle handle;
    private boolean playing = false;
    private FiguraVec3 pos = FiguraVec3.of();
    private float pitch = 1.0f;
    private float volume = 1.0f;
    private float attenuation = 1.0f;
    private boolean loop = false;
    private Component subtitleText;
    private String subtitle;

    public LuaSound(SoundBuffer buffer, String id, Avatar owner) {
        this(null, buffer, id, (Component)Component.m_237113_((String)id), owner);
    }

    public LuaSound(Sound sound, String id, Component subtitle, Avatar owner) {
        this(sound, null, id, subtitle, owner);
    }

    private LuaSound(Sound sound, SoundBuffer buffer, String id, Component subtitle, Avatar owner) {
        this.owner = owner;
        this.id = id;
        this.buffer = buffer;
        this.sound = sound;
        this.subtitleText = subtitle;
        this.subtitle = subtitle == null ? null : subtitle.getString();
    }

    public ChannelAccess.ChannelHandle getHandle() {
        return this.handle;
    }

    public Component getSubtitleText() {
        return this.subtitleText;
    }

    public String getId() {
        return this.id;
    }

    private float calculateVolume() {
        return SoundAPI.getSoundEngine().figura$getVolume(SoundSource.PLAYERS) * ((float)this.owner.permissions.get(Permissions.VOLUME) / 100.0f);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.play")
    public LuaSound play() {
        if (this.playing) {
            return this;
        }
        if (!this.owner.soundsRemaining.use()) {
            this.owner.noPermissions.add(Permissions.SOUNDS);
            return this;
        }
        this.owner.noPermissions.remove(Permissions.SOUNDS);
        if (this.handle != null) {
            this.handle.m_120154_(Channel::m_83678_);
            this.playing = true;
            return this;
        }
        if (this.buffer == null && this.sound == null) {
            return this;
        }
        float vol = this.calculateVolume();
        if (vol <= 0.0f) {
            return this;
        }
        this.playing = true;
        AvatarManager.executeAll("playSoundEvent", avatar -> {
            boolean cancel = avatar.playSoundEvent(this.getId(), this.getPos(), this.getVolume(), this.getPitch(), this.isLooping(), SoundSource.PLAYERS.name(), null);
            if (avatar.permissions.get(Permissions.CANCEL_SOUNDS) >= 1) {
                avatar.noPermissions.remove(Permissions.CANCEL_SOUNDS);
                if (cancel) {
                    this.playing = false;
                }
            } else {
                avatar.noPermissions.add(Permissions.CANCEL_SOUNDS);
            }
        });
        if (!this.playing) {
            return this;
        }
        this.handle = this.buffer != null ? SoundAPI.getSoundEngine().figura$createHandle(this.owner.owner, this.id, Library.Pool.STATIC) : SoundAPI.getSoundEngine().figura$createHandle(this.owner.owner, this.id, this.sound.m_119796_() ? Library.Pool.STREAMING : Library.Pool.STATIC);
        if (this.handle == null) {
            this.playing = false;
            return this;
        }
        SoundAPI.getSoundEngine().figura$addSound(this);
        if (this.buffer != null) {
            this.handle.m_120154_(channel -> {
                channel.m_83650_(this.pitch);
                channel.m_83666_(this.volume * vol);
                channel.m_83673_(this.attenuation * 16.0f);
                channel.m_83663_(this.loop);
                channel.m_83654_(this.pos.asVec3());
                channel.m_83670_(false);
                channel.m_83656_(this.buffer);
                channel.m_83672_();
            });
        } else {
            this.handle.m_120154_(channel -> {
                channel.m_83650_(this.pitch);
                channel.m_83666_(this.volume * vol);
                channel.m_83673_(this.attenuation * 16.0f);
                channel.m_83663_(this.loop && !this.sound.m_119796_());
                channel.m_83654_(this.pos.asVec3());
                channel.m_83670_(false);
            });
            SoundBufferLibrary lib = SoundAPI.getSoundEngine().figura$getSoundBuffers();
            if (!this.sound.m_119796_()) {
                lib.m_120202_(this.sound.m_119790_()).thenAccept(buffer -> this.handle.m_120154_(channel -> {
                    channel.m_83656_(buffer);
                    channel.m_83672_();
                }));
            } else {
                lib.m_120204_(this.sound.m_119790_(), this.loop).thenAccept(stream -> this.handle.m_120154_(channel -> {
                    channel.m_83658_(stream);
                    channel.m_83672_();
                }));
            }
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.is_playing")
    public boolean isPlaying() {
        if (this.handle != null) {
            this.handle.m_120154_(channel -> {
                this.playing = channel.m_166126_();
            });
        }
        return this.playing;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.pause")
    public LuaSound pause() {
        this.playing = false;
        if (this.handle != null) {
            this.handle.m_120154_(Channel::m_83677_);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.stop")
    public LuaSound stop() {
        this.playing = false;
        if (this.handle != null) {
            this.handle.m_120154_(Channel::m_83679_);
        }
        this.handle = null;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_pos")
    public FiguraVec3 getPos() {
        return this.pos;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="sound.set_pos")
    public LuaSound setPos(Object x, Double y, Double z) {
        this.pos = LuaUtils.parseVec3("setPos", x, y, z);
        if (this.handle != null) {
            this.handle.m_120154_(channel -> channel.m_83654_(this.pos.asVec3()));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_volume")
    public float getVolume() {
        return this.volume;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"volume"})}, aliases={"volume"}, value="sound.set_volume")
    public LuaSound setVolume(float volume) {
        this.volume = Math.min(volume, 1.0f);
        if (this.handle != null) {
            this.handle.m_120154_(channel -> {
                float f = this.calculateVolume();
                if (f <= 0.0f) {
                    channel.m_83679_();
                } else {
                    channel.m_83666_(this.volume * f);
                }
            });
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound volume(float volume) {
        return this.setVolume(volume);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_attenuation")
    public float getAttenuation() {
        return this.attenuation;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"attenuation"})}, aliases={"attenuation"}, value="sound.set_attenuation")
    public LuaSound setAttenuation(float attenuation) {
        this.attenuation = Math.max(attenuation, 1.0f);
        if (this.handle != null) {
            this.handle.m_120154_(channel -> channel.m_83673_(this.attenuation * 16.0f));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound attenuation(float attenuation) {
        return this.setAttenuation(attenuation);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_pitch")
    public float getPitch() {
        return this.pitch;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"pitch"})}, aliases={"pitch"}, value="sound.set_pitch")
    public LuaSound setPitch(float pitch) {
        this.pitch = Math.max(pitch, 0.0f);
        if (this.handle != null) {
            this.handle.m_120154_(channel -> channel.m_83650_(this.pitch));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound pitch(float pitch) {
        return this.setPitch(pitch);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.is_looping")
    public boolean isLooping() {
        return this.loop;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"loop"})}, aliases={"loop"}, value="sound.set_loop")
    public LuaSound setLoop(boolean loop) {
        this.loop = loop;
        if (this.handle != null) {
            this.handle.m_120154_(channel -> channel.m_83663_(this.loop));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound loop(boolean loop) {
        return this.setLoop(loop);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"subtitle"})}, aliases={"subtitle"}, value="sound.set_subtitle")
    public LuaSound setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        if (subtitle == null) {
            this.subtitleText = null;
        } else {
            this.subtitleText = TextUtils.tryParseJson(subtitle);
            if (this.subtitleText.getString().length() > 48) {
                throw new LuaError("Text length exceeded limit of 48 characters");
            }
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound subtitle(String subtitle) {
        return this.setSubtitle(subtitle);
    }

    public String toString() {
        return this.id + " (Sound)";
    }
}

