/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.EntityUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;

@LuaWhitelist
@LuaTypeDoc(name="PlayerAPI", value="player")
public class PlayerAPI
extends LivingEntityAPI<Player> {
    private PlayerInfo playerInfo;

    public PlayerAPI(Player entity) {
        super(entity);
    }

    private boolean checkPlayerInfo() {
        if (this.playerInfo != null) {
            return true;
        }
        PlayerInfo info = EntityUtils.getPlayerInfo(((Player)this.entity).m_20148_());
        if (info == null) {
            return false;
        }
        this.playerInfo = info;
        return true;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_food")
    public int getFood() {
        this.checkEntity();
        return ((Player)this.entity).m_36324_().m_38702_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_saturation")
    public float getSaturation() {
        this.checkEntity();
        return ((Player)this.entity).m_36324_().m_38722_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_exhaustion")
    public float getExhaustion() {
        this.checkEntity();
        return ((Player)this.entity).m_36324_().m_150380_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_progress")
    public float getExperienceProgress() {
        this.checkEntity();
        return ((Player)this.entity).f_36080_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_level")
    public int getExperienceLevel() {
        this.checkEntity();
        return ((Player)this.entity).f_36078_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_model_type")
    public String getModelType() {
        this.checkEntity();
        return (this.checkPlayerInfo() ? this.playerInfo.m_105336_() : DefaultPlayerSkin.m_118629_((UUID)((Player)this.entity).m_20148_())).toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_gamemode")
    public String getGamemode() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        GameType gamemode = this.playerInfo.m_105325_();
        return gamemode == null ? null : gamemode.m_46405_().toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_cape")
    public boolean hasCape() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.m_171808_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_skin")
    public boolean hasSkin() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.m_105335_();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"part"})}, value="player.is_skin_layer_visible")
    public boolean isSkinLayerVisible(@LuaNotNil String part) {
        this.checkEntity();
        try {
            if (((String)part).equalsIgnoreCase("left_pants") || ((String)part).equalsIgnoreCase("right_pants")) {
                part = (String)part + "_leg";
            }
            return ((Player)this.entity).m_36170_(PlayerModelPart.valueOf((String)((String)part).toUpperCase(Locale.US)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid player model part: " + (String)part);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.is_fishing")
    public boolean isFishing() {
        this.checkEntity();
        return ((Player)this.entity).f_36083_ != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_charged_attack_delay")
    public float getChargedAttackDelay() {
        this.checkEntity();
        return ((Player)this.entity).m_36333_();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"right"})}, value="player.get_shoulder_entity")
    public LuaTable getShoulderEntity(boolean right) {
        this.checkEntity();
        return new ReadOnlyLuaTable(NbtToLua.convert((Tag)(right ? ((Player)this.entity).m_36332_() : ((Player)this.entity).m_36331_())));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_team_info")
    public Map<String, Object> getTeamInfo() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        PlayerTeam team = this.playerInfo.m_105340_();
        if (team == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", team.m_5758_());
        map.put("display_name", team.m_83364_().getString());
        map.put("color", team.m_7414_().m_126666_());
        map.put("prefix", team.m_83370_().getString());
        map.put("suffix", team.m_83371_().getString());
        map.put("friendly_fire", team.m_6260_());
        map.put("see_friendly_invisibles", team.m_6259_());
        map.put("nametag_visibility", team.m_7470_().f_83567_);
        map.put("death_message_visibility", team.m_7468_().f_83567_);
        map.put("collision_rule", team.m_7156_().f_83543_);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={ItemStackAPI.class, Float.class}, argumentNames={"stack", "delta"})}, value="player.get_cooldown_percent")
    public float getCooldownPercent(@LuaNotNil ItemStackAPI stack, Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(0.0f);
        }
        return ((Player)this.entity).m_36335_().m_41521_(stack.itemStack.m_41720_(), delta.floatValue());
    }

    @Override
    public String toString() {
        this.checkEntity();
        return ((Player)this.entity).m_7755_().getString() + " (Player)";
    }
}

