/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.mixin.LivingEntityAccessor;

@LuaWhitelist
@LuaTypeDoc(name="LivingEntityAPI", value="living_entity")
public class LivingEntityAPI<T extends LivingEntity>
extends EntityAPI<T> {
    public LivingEntityAPI(T entity) {
        super(entity);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="living_entity.get_body_yaw")
    public double getBodyYaw(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return Mth.m_14179_((float)delta.floatValue(), (float)((LivingEntity)this.entity).f_20884_, (float)((LivingEntity)this.entity).f_20883_);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"offhand"})}, value="living_entity.get_held_item")
    public ItemStackAPI getHeldItem(boolean offhand) {
        this.checkEntity();
        return ItemStackAPI.verify(offhand ? ((LivingEntity)this.entity).m_21206_() : ((LivingEntity)this.entity).m_21205_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item")
    public ItemStackAPI getActiveItem() {
        this.checkEntity();
        return ItemStackAPI.verify(((LivingEntity)this.entity).m_21211_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_item_time")
    public int getActiveItemTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21252_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_health")
    public float getHealth() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21223_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_max_health")
    public float getMaxHealth() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21233_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_armor")
    public float getArmor() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21230_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_death_time")
    public float getDeathTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).f_20919_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_arrow_count")
    public int getArrowCount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21234_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_stinger_count")
    public int getStingerCount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21235_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_left_handed")
    public boolean isLeftHanded() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_5737_() == HumanoidArm.LEFT;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_using_item")
    public boolean isUsingItem() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_6117_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_active_hand")
    public String getActiveHand() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_7655_().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_climbing")
    public boolean isClimbing() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_6147_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_time")
    public int getSwingTime() {
        this.checkEntity();
        return ((LivingEntity)this.entity).f_20913_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_swinging_arm")
    public boolean isSwingingArm() {
        this.checkEntity();
        return ((LivingEntity)this.entity).f_20911_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_arm")
    public String getSwingArm() {
        this.checkEntity();
        return ((LivingEntity)this.entity).f_20911_ ? ((LivingEntity)this.entity).f_20912_.name() : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_swing_duration")
    public int getSwingDuration() {
        this.checkEntity();
        return ((LivingEntityAccessor)this.entity).getSwingDuration();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_absorption_amount")
    public float getAbsorptionAmount() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_6103_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_sensitive_to_water")
    public boolean isSensitiveToWater() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_6126_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.get_entity_category")
    public String getEntityCategory() {
        this.checkEntity();
        MobType mobType = ((LivingEntity)this.entity).m_6336_();
        if (mobType == MobType.f_21642_) {
            return "ARTHROPOD";
        }
        if (mobType == MobType.f_21641_) {
            return "UNDEAD";
        }
        if (mobType == MobType.f_21644_) {
            return "WATER";
        }
        if (mobType == MobType.f_21643_) {
            return "ILLAGER";
        }
        return "UNDEFINED";
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_gliding")
    public boolean isGliding() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21255_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_blocking")
    public boolean isBlocking() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21254_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.is_visually_swimming")
    public boolean isVisuallySwimming() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_6067_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="living_entity.riptide_spinning")
    public boolean riptideSpinning() {
        this.checkEntity();
        return ((LivingEntity)this.entity).m_21209_();
    }

    @Override
    public String toString() {
        this.checkEntity();
        return (String)(((LivingEntity)this.entity).m_8077_() ? ((LivingEntity)this.entity).m_7770_().getString() + " (" + this.getType() + ")" : this.getType()) + " (LivingEntity)";
    }
}

