/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.entity.PlayerAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.EntityAccessor;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="EntityAPI", value="entity")
public class EntityAPI<T extends Entity> {
    @NotNull
    protected final UUID entityUUID;
    @NotNull
    protected T entity;
    private String cacheType;

    public EntityAPI(T entity) {
        this.entity = entity;
        this.entityUUID = entity.m_20148_();
    }

    public static EntityAPI<?> wrap(Entity e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Player) {
            Player p = (Player)e;
            return new PlayerAPI(p);
        }
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            return new LivingEntityAPI<LivingEntity>(le);
        }
        return new EntityAPI<Entity>(e);
    }

    protected final boolean checkEntity() {
        boolean thingy = true;
        if (this.entity.m_213877_() || this.getLevel() != Minecraft.m_91087_().f_91073_) {
            Entity newEntityInstance = EntityUtils.getEntityByUUID(this.entityUUID);
            boolean bl = thingy = newEntityInstance != null;
            if (thingy) {
                this.entity = newEntityInstance;
            }
        }
        return thingy;
    }

    protected Level getLevel() {
        return ((EntityAccessor)this.entity).getLevel();
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_loaded")
    public boolean isLoaded() {
        return this.checkEntity();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_pos")
    public FiguraVec3 getPos(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec3.fromVec3(this.entity.m_20318_(delta.floatValue()));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_rot")
    public FiguraVec2 getRot(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec2.of(Mth.m_14179_((float)delta.floatValue(), (float)((Entity)this.entity).f_19860_, (float)this.entity.m_146909_()), Mth.m_14179_((float)delta.floatValue(), (float)((Entity)this.entity).f_19859_, (float)this.entity.m_146908_()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_uuid")
    public String getUUID() {
        return this.entityUUID.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_type")
    public String getType() {
        this.checkEntity();
        return this.cacheType != null ? this.cacheType : (this.cacheType = BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_()).toString());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_velocity")
    public FiguraVec3 getVelocity() {
        this.checkEntity();
        return FiguraVec3.of(this.entity.m_20185_() - ((Entity)this.entity).f_19790_, this.entity.m_20186_() - ((Entity)this.entity).f_19791_, this.entity.m_20189_() - ((Entity)this.entity).f_19792_);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_look_dir")
    public FiguraVec3 getLookDir() {
        this.checkEntity();
        return FiguraVec3.fromVec3(this.entity.m_20154_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_frozen_ticks")
    public int getFrozenTicks() {
        this.checkEntity();
        return this.entity.m_146888_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_max_air")
    public int getMaxAir() {
        this.checkEntity();
        return this.entity.m_6062_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_dimension_name")
    public String getDimensionName() {
        this.checkEntity();
        return this.getLevel().m_46472_().m_135782_().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_pose")
    public String getPose() {
        this.checkEntity();
        return this.entity.m_20089_().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_vehicle")
    public EntityAPI<?> getVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.m_20202_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_ground")
    public boolean isOnGround() {
        this.checkEntity();
        return this.entity.m_20096_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_height")
    public float getEyeHeight() {
        this.checkEntity();
        return this.entity.m_20236_(this.entity.m_20089_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_bounding_box")
    public FiguraVec3 getBoundingBox() {
        this.checkEntity();
        EntityDimensions dim = this.entity.m_6972_(this.entity.m_20089_());
        return FiguraVec3.of(dim.f_20377_, dim.f_20378_, dim.f_20377_);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_name")
    public String getName() {
        this.checkEntity();
        return this.entity.m_7755_().getString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_wet")
    public boolean isWet() {
        this.checkEntity();
        return this.entity.m_20071_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_water")
    public boolean isInWater() {
        this.checkEntity();
        return this.entity.m_20069_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_underwater")
    public boolean isUnderwater() {
        this.checkEntity();
        return this.entity.m_5842_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_lava")
    public boolean isInLava() {
        this.checkEntity();
        return this.entity.m_20077_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_rain")
    public boolean isInRain() {
        this.checkEntity();
        BlockPos blockPos = this.entity.m_20183_();
        return this.getLevel().m_46758_(blockPos) || this.getLevel().m_46758_(new BlockPos(blockPos.m_123341_(), (int)this.entity.m_20191_().f_82292_, (int)this.entity.m_20189_()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_avatar")
    public boolean hasAvatar() {
        this.checkEntity();
        return AvatarManager.getAvatar(this.entity) != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sprinting")
    public boolean isSprinting() {
        this.checkEntity();
        return this.entity.m_20142_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_y")
    public double getEyeY() {
        this.checkEntity();
        return this.entity.m_20188_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_glowing")
    public boolean isGlowing() {
        this.checkEntity();
        return this.entity.m_142038_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_invisible")
    public boolean isInvisible() {
        this.checkEntity();
        return this.entity.m_20145_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_silent")
    public boolean isSilent() {
        this.checkEntity();
        return this.entity.m_20067_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sneaking")
    public boolean isSneaking() {
        this.checkEntity();
        return this.entity.m_20163_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_crouching")
    public boolean isCrouching() {
        this.checkEntity();
        return this.entity.m_6047_();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={int.class}, argumentNames={"index"})}, value="entity.get_item")
    public ItemStackAPI getItem(int index) {
        this.checkEntity();
        if (--index < 0) {
            return null;
        }
        int i = 0;
        for (ItemStack item : this.entity.m_20158_()) {
            if (i == index) {
                return ItemStackAPI.verify(item);
            }
            ++i;
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_nbt")
    public LuaTable getNbt() {
        this.checkEntity();
        CompoundTag tag = new CompoundTag();
        this.entity.m_20240_(tag);
        return (LuaTable)NbtToLua.convert((Tag)tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_fire")
    public boolean isOnFire() {
        this.checkEntity();
        return this.entity.m_6051_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_alive")
    public boolean isAlive() {
        this.checkEntity();
        return this.entity.m_6084_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_permission_level")
    public int getPermissionLevel() {
        this.checkEntity();
        return ((EntityAccessor)this.entity).getPermissionLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_passengers")
    public List<EntityAPI<?>> getPassengers() {
        this.checkEntity();
        ArrayList list = new ArrayList();
        for (Entity passenger : this.entity.m_20197_()) {
            list.add(EntityAPI.wrap(passenger));
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlling_passenger")
    public EntityAPI<?> getControllingPassenger() {
        this.checkEntity();
        return EntityAPI.wrap((Entity)this.entity.m_6688_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlled_vehicle")
    public EntityAPI<?> getControlledVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.m_275832_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_container")
    public boolean hasContainer() {
        this.checkEntity();
        return this.entity instanceof ContainerEntity;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_inventory")
    public boolean hasInventory() {
        this.checkEntity();
        return this.entity instanceof HasCustomInventoryScreen;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"ignoreLiquids"}), @LuaMethodOverload(argumentTypes={Boolean.class, Double.class}, argumentNames={"ignoreLiquids", "distance"})}, value="entity.get_targeted_block")
    public Object[] getTargetedBlock(boolean ignoreLiquids, Double distance) {
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), -20.0);
        HitResult result = this.entity.m_19907_(distance.doubleValue(), 1.0f, !ignoreLiquids);
        return LuaUtils.parseBlockHitResult(result);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"distance"})}, value="entity.get_targeted_entity")
    public Object[] getTargetedEntity(Double distance) {
        AABB aABB;
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), 0.0);
        Vec3 vec3 = this.entity.m_20299_(1.0f);
        HitResult result = this.entity.m_19907_(distance.doubleValue(), 1.0f, false);
        distance = result.m_82450_().m_82557_(vec3);
        Vec3 vec32 = this.entity.m_20252_(1.0f);
        Vec3 vec33 = vec3.m_82520_(vec32.f_82479_ * distance, vec32.f_82480_ * distance, vec32.f_82481_ * distance);
        EntityHitResult entityHit = ProjectileUtil.m_37287_(this.entity, (Vec3)vec3, (Vec3)vec33, (AABB)(aABB = this.entity.m_20191_().m_82369_(vec32.m_82490_(distance.doubleValue())).m_82400_(1.0)), e -> e != this.entity, (double)distance);
        if (entityHit != null) {
            return new Object[]{EntityAPI.wrap(entityHit.m_82443_()), FiguraVec3.fromVec3(entityHit.m_82450_())};
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"key"})}, value="entity.get_variable")
    public LuaValue getVariable(String key) {
        this.checkEntity();
        Avatar a = AvatarManager.getAvatar(this.entity);
        LuaTable table = a == null || a.luaRuntime == null ? new LuaTable() : a.luaRuntime.avatar_meta.storedStuff;
        table = new ReadOnlyLuaTable((LuaValue)table);
        return key == null ? table : table.get(key);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_living")
    public boolean isLiving() {
        return this instanceof LivingEntityAPI;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_player")
    public boolean isPlayer() {
        return this instanceof PlayerAPI;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={boolean.class, EntityAPI.class, EntityAPI.class})})
    public boolean __eq(EntityAPI<?> rhs) {
        return this.entity.equals(rhs.entity);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, EntityAPI.class})})
    public String __tostring() {
        return this.toString();
    }

    public String toString() {
        this.checkEntity();
        return (String)(this.entity.m_8077_() ? this.entity.m_7770_().getString() + " (" + this.getType() + ")" : this.getType()) + " (Entity)";
    }
}

