/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractConfigElement
extends AbstractContainerElement {
    protected final ConfigType<?> config;
    protected final ConfigList parentList;
    protected final CategoryWidget parentCategory;
    protected Button resetButton;
    protected Object initValue;
    private String filter = "";

    public AbstractConfigElement(int width, ConfigType<?> config, ConfigList parentList, CategoryWidget parentCategory) {
        super(0, 0, width, 20);
        this.config = config;
        this.parentList = parentList;
        this.parentCategory = parentCategory;
        this.initValue = config.value;
        this.resetButton = new ParentedButton(0, 0, 60, 20, (Component)Component.m_237115_((String)"controls.reset"), this, button -> config.resetTemp());
        this.children.add(this.resetButton);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int n = this.m_252907_() + this.m_93694_() / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        this.setHovered(this.m_5953_(mouseX, mouseY));
        if (this.isHovered()) {
            gui.m_280430_(font, HOVERED_ARROW, (int)((float)(this.m_252754_() + 8) - (float)font.m_92852_((FormattedText)HOVERED_ARROW) / 2.0f), textY, 0xFFFFFF);
        }
        this.renderTitle(gui, font, textY);
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    public void renderTitle(GuiGraphics gui, Font font, int y) {
        gui.m_280430_(font, this.config.name, this.m_252754_() + 16, y, (this.config.disabled ? ChatFormatting.DARK_GRAY : ChatFormatting.WHITE).m_126665_().intValue());
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        boolean over;
        boolean bl = over = this.parentList.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        if (over && mouseX < (double)(this.m_252754_() + this.m_5711_() - 158)) {
            UIHelper.setTooltip((Component)this.getTooltip());
        }
        return over;
    }

    public MutableComponent getTooltip() {
        return this.config.tooltip.m_6881_();
    }

    public boolean isDefault() {
        return this.config.isDefault();
    }

    public boolean isChanged() {
        return !Objects.equals(this.config.tempValue, this.initValue);
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.resetButton.m_252865_(x + this.m_5711_() - 60);
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.resetButton.m_253211_(y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible && this.parentCategory.isShowingChildren() && this.matchesFilter());
    }

    public void updateFilter(String query) {
        this.filter = query;
    }

    public boolean matchesFilter() {
        return this.config.name.getString().toLowerCase(Locale.US).contains(this.filter) || this.config.tooltip.getString().toLowerCase(Locale.US).contains(this.filter);
    }
}

