/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class Label
implements FiguraWidget,
GuiEventListener,
NarratableEntry {
    private final Font font;
    private Component rawText;
    private List<Component> formattedText;
    public TextUtils.Alignment alignment;
    public Integer outlineColor;
    public Integer backgroundColor;
    private Integer alpha;
    private int alphaPrecise = 255;
    public int maxWidth;
    public boolean wrap;
    private Style hovered;
    private int x;
    private int y;
    private int width;
    private int height;
    private float scale;
    private boolean visible = true;
    public boolean centerVertically;

    public Label(Object text, int x, int y, float scale, int maxWidth, boolean wrap, TextUtils.Alignment alignment, Integer outlineColor) {
        MutableComponent mutableComponent;
        this.font = Minecraft.m_91087_().f_91062_;
        if (text instanceof Component) {
            Component c = (Component)text;
            mutableComponent = c;
        } else {
            mutableComponent = Component.m_237113_((String)String.valueOf(text));
        }
        this.rawText = mutableComponent;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.maxWidth = maxWidth;
        this.wrap = wrap;
        this.alignment = alignment;
        this.outlineColor = outlineColor;
        this.updateText();
    }

    public Label(Object text, int x, int y, int outlineColor) {
        this(text, x, y, 1.0f, -1, false, TextUtils.Alignment.LEFT, outlineColor);
    }

    public Label(Object text, int x, int y, TextUtils.Alignment alignment) {
        this(text, x, y, 1.0f, -1, false, alignment, null);
    }

    public Label(Object text, int x, int y, TextUtils.Alignment alignment, int outlineColor) {
        this(text, x, y, 1.0f, -1, false, alignment, outlineColor);
    }

    public Label(Object text, int x, int y, int maxWidth, boolean wrap, TextUtils.Alignment alignment) {
        this(text, x, y, 1.0f, maxWidth, wrap, alignment, null);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.hovered = null;
        if (!this.isVisible()) {
            return;
        }
        this.renderBackground(gui);
        this.renderText(gui, mouseX, mouseY, delta);
    }

    private void renderBackground(GuiGraphics gui) {
        if (this.backgroundColor == null) {
            return;
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        gui.m_280509_(x, y, x + this.width, y + this.height, this.backgroundColor.intValue());
    }

    private void renderText(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)this.x, (float)this.m_252907_(), 0.0f);
        pose.m_85841_(this.scale, this.scale, this.scale);
        if (this.alpha != null) {
            float lerpDelta = MathUtils.magicDelta(0.6f, delta);
            this.alphaPrecise = (int)Mth.m_14179_((float)lerpDelta, (float)this.alphaPrecise, (float)(this.m_5953_(mouseX, mouseY) ? 255.0f : (float)this.alpha.intValue()));
        }
        int y = 0;
        Objects.requireNonNull(this.font);
        int height = 9;
        for (Component text : this.formattedText) {
            int x = -this.alignment.apply(this.font, (FormattedText)text);
            int width = this.font.m_92852_((FormattedText)text);
            if ((float)mouseX >= (float)this.x + (float)x * this.scale && (float)mouseX < (float)this.x + (float)(x + width) * this.scale && (float)mouseY >= (float)this.y + (float)y * this.scale && (float)mouseY < (float)this.y + (float)(y + height) * this.scale) {
                ClickEvent event;
                int pos = (int)(((float)(mouseX - this.x) - (float)x * this.scale) / this.scale);
                this.hovered = this.font.m_92865_().m_92386_((FormattedText)text, pos);
                ClickEvent clickEvent = event = this.hovered != null ? this.hovered.m_131182_() : null;
                if (event != null) {
                    text = TextUtils.replaceStyle((FormattedText)text, Style.f_131099_.m_131162_(Boolean.valueOf(true)), style -> event.equals((Object)style.m_131182_()));
                }
                UIHelper.setTooltip(this.hovered);
            }
            if (this.outlineColor != null) {
                UIHelper.renderOutlineText(gui, this.font, text, x, y, 0xFFFFFF, this.outlineColor);
            } else {
                gui.m_280430_(this.font, text, x, y, 0xFFFFFF + (this.alphaPrecise << 24));
            }
            y += height;
        }
        pose.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hovered != null && Minecraft.m_91087_().f_91080_ != null) {
            Minecraft.m_91087_().f_91080_.m_5561_(this.hovered);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.isVisible()) {
            return false;
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        if (mouseX >= (double)x && mouseX < (double)(x + this.width) && mouseY >= (double)y && mouseY < (double)(y + this.height)) {
            return true;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    public void m_93692_(boolean focused) {
    }

    public boolean m_93696_() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput builder) {
        builder.m_169146_(NarratedElementType.POSITION, this.rawText);
    }

    @Override
    public int m_5711_() {
        return this.width;
    }

    @Override
    public int m_93694_() {
        return this.height;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateText();
    }

    public void setText(Component text) {
        this.rawText = text;
        this.updateText();
    }

    private void updateText() {
        this.formattedText = TextUtils.formatInBounds((FormattedText)this.rawText, this.font, (int)((float)this.maxWidth / this.scale), this.wrap);
        this.width = (int)((float)TextUtils.getWidth(this.formattedText, this.font) * this.scale);
        Objects.requireNonNull(this.font);
        this.height = (int)((float)(9 * this.formattedText.size()) * this.scale);
    }

    @Override
    public int m_252754_() {
        int x = this.x;
        if (this.alignment == TextUtils.Alignment.RIGHT) {
            x -= this.width;
        } else if (this.alignment == TextUtils.Alignment.CENTER) {
            x -= this.width / 2;
        }
        return x;
    }

    public int getRawX() {
        return this.x;
    }

    @Override
    public void m_252865_(int x) {
        this.x = x;
    }

    @Override
    public int m_252907_() {
        int y = this.y;
        if (this.centerVertically) {
            y -= this.height / 2;
        }
        return y;
    }

    public int getRawY() {
        return this.y;
    }

    @Override
    public void m_253211_(int y) {
        this.y = y;
    }

    @Override
    public void m_93674_(int width) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeight(int height) {
        throw new UnsupportedOperationException();
    }

    public void setAlpha(int alpha) {
        this.alphaPrecise = alpha;
        this.alpha = this.alphaPrecise;
    }
}

