/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class KeybindWidgetHelper {
    private Component tooltip;
    private boolean vanillaConflict;
    private boolean avatarConflict;

    public void renderConflictBars(GuiGraphics gui, int x, int y, int width, int height) {
        if (this.vanillaConflict || this.avatarConflict) {
            if (this.avatarConflict) {
                gui.m_280509_(x, y, x + width, y + height, ChatFormatting.YELLOW.m_126665_() | 0xFF000000);
                x -= width + 4;
            }
            if (this.vanillaConflict) {
                gui.m_280509_(x, y, x + width, y + height, ChatFormatting.RED.m_126665_() | 0xFF000000);
            }
        }
    }

    public void renderTooltip() {
        if (this.tooltip != null) {
            UIHelper.setTooltip(this.tooltip);
        }
    }

    public void setTooltip(FiguraKeybind keybind, List<FiguraKeybind> keyBindings) {
        Component vanilla;
        boolean hasAvatarConflict;
        MutableComponent text = Component.m_237119_();
        Component avatar = this.checkForAvatarConflicts(keybind, keyBindings);
        boolean bl = hasAvatarConflict = avatar != null && !avatar.getString().isBlank();
        if (hasAvatarConflict) {
            text.m_7220_(avatar);
        }
        if ((vanilla = this.checkForVanillaConflicts(keybind)) != null && !vanilla.getString().isBlank()) {
            if (hasAvatarConflict) {
                text.m_130946_("\n");
            }
            text.m_7220_(vanilla);
        }
        this.setTooltipTail((Component)text);
    }

    public void setTooltip(KeyMapping keybind) {
        MutableComponent text = Component.m_237119_();
        Component vanilla = this.checkForVanillaConflicts(keybind);
        if (vanilla != null && !vanilla.getString().isBlank()) {
            text.m_7220_(vanilla);
        }
        this.setTooltipTail((Component)text);
    }

    private void setTooltipTail(Component text) {
        this.tooltip = this.vanillaConflict || this.avatarConflict ? FiguraText.of("gui.duplicate_keybind", text) : null;
    }

    public Component getText(boolean isDefault, boolean isSelected, Component initialMessage) {
        MutableComponent message = initialMessage.m_6881_();
        if (isDefault || isSelected) {
            message.m_130940_(ChatFormatting.WHITE);
        } else {
            message.m_130948_(FiguraMod.getAccentColor());
        }
        if (isSelected) {
            message.m_130940_(ChatFormatting.UNDERLINE);
        }
        if (this.avatarConflict || this.vanillaConflict) {
            MutableComponent left = Component.m_237113_((String)"[ ").m_130940_(this.vanillaConflict ? ChatFormatting.RED : ChatFormatting.YELLOW);
            MutableComponent right = Component.m_237113_((String)" ]").m_130940_(this.avatarConflict ? ChatFormatting.YELLOW : ChatFormatting.RED);
            message = left.m_7220_((Component)message).m_7220_((Component)right);
        }
        if (isSelected) {
            message = Component.m_237113_((String)"> ").m_7220_((Component)message).m_130946_(" <").m_130948_(FiguraMod.getAccentColor());
        }
        return message;
    }

    public Component checkForAvatarConflicts(FiguraKeybind keybind, List<FiguraKeybind> keyBindings) {
        this.avatarConflict = false;
        int id = keybind.getID();
        if (id == -1) {
            return null;
        }
        MutableComponent message = Component.m_237119_();
        for (FiguraKeybind keyBinding : keyBindings) {
            if (keyBinding == keybind || keyBinding.getID() != id) continue;
            this.avatarConflict = true;
            message.m_7220_((Component)Component.m_237113_((String)"\n\u2022 ").m_130940_(ChatFormatting.YELLOW).m_130946_(keyBinding.getName()));
        }
        return message;
    }

    public Component checkForVanillaConflicts(FiguraKeybind keybind) {
        this.vanillaConflict = false;
        if (keybind.getID() == -1) {
            return null;
        }
        String keyName = keybind.getKey();
        MutableComponent message = Component.m_237119_();
        for (KeyMapping key : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!key.m_90865_().equals(keyName)) continue;
            this.vanillaConflict = true;
            message.m_7220_((Component)Component.m_237113_((String)"\n\u2022 ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237115_((String)key.m_90858_())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)key.m_90860_())));
        }
        return message;
    }

    public Component checkForVanillaConflicts(KeyMapping keybind) {
        this.vanillaConflict = false;
        if (keybind.m_90862_()) {
            return null;
        }
        String keyName = keybind.m_90865_();
        MutableComponent message = Component.m_237119_();
        for (KeyMapping key : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (key == keybind || !key.m_90865_().equals(keyName)) continue;
            this.vanillaConflict = true;
            message.m_7220_((Component)Component.m_237113_((String)"\n\u2022 ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237115_((String)key.m_90858_())).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)key.m_90860_())));
        }
        return message;
    }
}

