/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import org.figuramc.figura.gui.screens.KeybindScreen;
import org.figuramc.figura.gui.screens.SoundScreen;
import org.figuramc.figura.gui.widgets.AvatarInfoWidget;
import org.figuramc.figura.gui.widgets.BackendMotdWidget;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.EntityPreview;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.LoadingErrorWidget;
import org.figuramc.figura.gui.widgets.StatusWidget;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class WardrobeScreen
extends AbstractPanelScreen {
    private static final Component DEBUG_MOTD_FALLBACK = Component.m_237113_((String)"No motd could be loaded.\n\n").m_130946_("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"(This is some text you can hover)\n").m_130948_(Style.f_131099_.m_178520_(-847456).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"hi chat"))))).m_7220_((Component)Component.m_237113_((String)"(This is some text you can click on)\n").m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/FiguraMC/Figura")))).m_7220_((Component)Component.m_237113_((String)"(This is only visible in debug mode)").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    private Label panic;
    private Button upload;
    private Button delete;
    private Button back;
    private AvatarInfoWidget infoWidget;
    private BackendMotdWidget motdWidget;

    public WardrobeScreen(Screen parentScreen) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.wardrobe"));
    }

    @Override
    protected void m_7856_() {
        boolean oldVersion;
        super.m_7856_();
        Minecraft minecraft = Minecraft.m_91087_();
        int middle = this.f_96543_ / 2;
        int panels = this.getPanels();
        int modelBgSize = Math.min(this.f_96543_ - panels * 2 - 16, this.f_96544_ - 96);
        panels = Math.max((this.f_96543_ - modelBgSize) / 2 - 8, panels);
        AvatarList avatarList = new AvatarList(4, 28, panels, this.f_96544_ - 32, this);
        this.m_142416_((GuiEventListener)avatarList);
        int entitySize = 11 * modelBgSize / 29;
        int entityX = middle - modelBgSize / 2;
        int entityY = this.f_96544_ / 2 - modelBgSize / 2;
        EntityPreview entity = new EntityPreview(entityX, entityY, modelBgSize, modelBgSize, entitySize, -15.0f, 30.0f, (LivingEntity)minecraft.f_91074_, this);
        this.m_142416_((GuiEventListener)entity);
        int buttX = entity.m_252754_() + entity.m_5711_() / 2;
        int buttY = entity.m_252907_() + entity.m_93694_() + 4;
        this.upload = new Button(buttX - 48, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/upload.png"), 72, 24, (Component)FiguraText.of("gui.wardrobe.upload.tooltip"), button -> {
            Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NetworkStuff.uploadAvatar(avatar);
            AvatarList.selectedEntry = null;
        });
        this.m_142416_((GuiEventListener)this.upload);
        this.upload.setActive(false);
        this.m_142416_((GuiEventListener)new Button(buttX - 12, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/reload.png"), 72, 24, (Component)FiguraText.of("gui.wardrobe.reload.tooltip"), button -> {
            AvatarManager.clearAvatars(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AvatarManager.localUploaded = true;
            AvatarList.selectedEntry = null;
            NetworkStuff.auth();
        }));
        this.delete = new Button(buttX + 24, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/delete.png"), 72, 24, (Component)FiguraText.of("gui.wardrobe.delete.tooltip"), button -> NetworkStuff.deleteAvatar(null));
        this.m_142416_((GuiEventListener)this.delete);
        this.delete.setActive(false);
        StatusWidget statusWidget = new StatusWidget(entity.m_252754_() + entity.m_5711_() - 64, 0, 64);
        statusWidget.m_253211_(entity.m_252907_() - statusWidget.m_93694_() - 4);
        this.m_169394_(statusWidget);
        this.m_169394_(new LoadingErrorWidget(statusWidget.m_252754_() - 18, statusWidget.m_252907_(), 14));
        MutableComponent versionText = FiguraText.of().m_130946_(" " + FiguraMod.VERSION.noBuildString()).m_130940_(ChatFormatting.ITALIC);
        int versionStatus = NetworkStuff.latestVersion != null ? NetworkStuff.latestVersion.compareTo(FiguraMod.VERSION) : 0;
        boolean bl = oldVersion = versionStatus > 0;
        if (oldVersion) {
            versionText.m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"=").m_130948_(Style.f_131099_.m_131150_(UIHelper.UI_FONT).m_131155_(Boolean.valueOf(false)).m_131164_(ChatFormatting.WHITE))).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)FiguraText.of("gui.new_version.tooltip", Component.m_237113_((String)NetworkStuff.latestVersion.toString()).m_130940_(ChatFormatting.GREEN)))).m_131142_((ClickEvent)new TextUtils.FiguraClickEvent(UIHelper.openURL(NetworkStuff.latestVersion.pre == null ? FiguraMod.Links.Modrinth.url + "/versions" : FiguraMod.Links.Github.url + "/releases"))));
        } else if (versionStatus < 0) {
            versionText.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)FiguraText.of("gui.old_version.tooltip", Component.m_237113_((String)NetworkStuff.latestVersion.toString()).m_130940_(ChatFormatting.LIGHT_PURPLE)))));
        }
        Label version = new Label((Object)versionText, middle, this.f_96544_ - 4, TextUtils.Alignment.CENTER);
        this.m_142416_(version);
        if (!oldVersion) {
            version.setAlpha(51);
        }
        version.m_253211_(version.getRawY() - version.m_93694_());
        int rightSide = Math.min(panels, 134);
        this.back = new Button(this.f_96543_ - rightSide - 4, this.f_96544_ - 24, rightSide, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.back);
        rightSide = panels / 2 + 52;
        Button avatarSettings = new Button(this.f_96543_ - rightSide, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/avatar_settings.png"), 72, 24, (Component)FiguraText.of("gui.avatar_settings.tooltip").m_130946_("\n").m_7220_((Component)FiguraText.of("gui.not_available_yet").m_130940_(ChatFormatting.RED)), bx -> {});
        this.m_142416_((GuiEventListener)avatarSettings);
        avatarSettings.setActive(false);
        Button sounds = new Button(this.f_96543_ - rightSide + 36, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/sound.png"), 72, 24, (Component)FiguraText.of("gui.wardrobe.sound.tooltip"), button -> Minecraft.m_91087_().m_91152_((Screen)new SoundScreen(this)));
        this.m_142416_((GuiEventListener)sounds);
        Button keybinds = new Button(this.f_96543_ - rightSide + 72, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/keybind.png"), 72, 24, (Component)FiguraText.of("gui.wardrobe.keybind.tooltip"), button -> Minecraft.m_91087_().m_91152_((Screen)new KeybindScreen(this)));
        this.m_142416_((GuiEventListener)keybinds);
        this.infoWidget = new AvatarInfoWidget(this.f_96543_ - panels - 4, 56, panels, this.back.m_252907_() - 60);
        this.m_169394_(this.infoWidget);
        if (this.motdWidget != null) {
            this.m_169411_((GuiEventListener)this.motdWidget);
            this.motdWidget = null;
        }
        this.updateMotdWidget();
        this.panic = new Label(FiguraText.of("gui.panic", Configs.PANIC_BUTTON.keyBind.m_90863_()).m_130940_(ChatFormatting.YELLOW), middle, version.getRawY(), TextUtils.Alignment.CENTER, 0);
        this.m_142416_(this.panic);
        this.panic.m_253211_(this.panic.getRawY() - this.panic.m_93694_());
        this.panic.setVisible(false);
    }

    private int getPanels() {
        return Math.min(this.f_96543_ / 3, 256) - 8;
    }

    private void updateMotdWidget() {
        int panels = this.getPanels();
        int infoBottom = this.infoWidget.m_252907_() + this.infoWidget.m_93694_();
        int width = panels - 8;
        int height = this.back.m_252907_() - infoBottom - 16;
        int x = this.f_96543_ - panels;
        int y = infoBottom + 8;
        this.infoWidget.tick();
        if (this.motdWidget == null) {
            Component motd;
            Component component = motd = NetworkStuff.motd == null ? DEBUG_MOTD_FALLBACK : NetworkStuff.motd;
            if (!FiguraMod.debugModeEnabled() && motd == DEBUG_MOTD_FALLBACK) {
                return;
            }
            this.motdWidget = (BackendMotdWidget)this.m_142416_((GuiEventListener)new BackendMotdWidget(x, y, width, height, motd, this.f_96547_));
        } else {
            Component motd;
            this.motdWidget.m_264152_(x, y);
            this.motdWidget.m_93674_(width);
            this.motdWidget.setHeight(height);
            Component component = motd = NetworkStuff.motd == null ? DEBUG_MOTD_FALLBACK : NetworkStuff.motd;
            if (!FiguraMod.debugModeEnabled() && motd == DEBUG_MOTD_FALLBACK) {
                return;
            }
            this.motdWidget.m_93666_(motd);
        }
        this.motdWidget.f_93624_ = this.motdWidget.m_93694_() > 48;
    }

    @Override
    public void m_86600_() {
        Avatar avatar;
        super.m_86600_();
        this.panic.setVisible(AvatarManager.panic);
        this.upload.setActive(NetworkStuff.canUpload() && !AvatarManager.localUploaded && (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) != null && avatar.nbt != null && avatar.loaded);
        this.delete.setActive(NetworkStuff.isConnected() && AvatarManager.localUploaded);
        this.updateMotdWidget();
    }

    public void m_7861_() {
        super.m_7861_();
        LocalAvatarFetcher.save();
    }

    public void m_7400_(List<Path> paths) {
        super.m_7400_(paths);
        StringBuilder packs = new StringBuilder();
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                packs.append("\n");
            }
            packs.append(IOUtils.getFileNameOrEmpty(paths.get(i)));
        }
        this.f_96541_.m_91152_((Screen)new FiguraConfirmScreen(confirmed -> {
            if (confirmed) {
                try {
                    LocalAvatarFetcher.loadExternal(paths);
                    FiguraToast.sendToast(FiguraText.of("toast.wardrobe_copy.success", paths.size()));
                }
                catch (Exception e) {
                    FiguraToast.sendToast((Object)FiguraText.of("toast.wardrobe_copy.error"), FiguraToast.ToastType.ERROR);
                    FiguraMod.LOGGER.error("Failed to copy files", (Throwable)e);
                }
            }
            this.f_96541_.m_91152_((Screen)this);
        }, FiguraText.of("gui.wardrobe.drop_files"), packs.toString(), this));
    }
}

