/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class FiguraToast
implements Toast {
    private final ToastType type;
    private Component title;
    private Component message;
    private long startTime;
    private boolean update;

    public FiguraToast(Component title, Component message, ToastType type) {
        this.type = type;
        this.update(title, message, false);
    }

    public void update(Component title, Component message, boolean update) {
        this.title = Component.m_237119_().m_6270_(this.type.style).m_7220_(title);
        this.message = message;
        this.update = update;
    }

    public Toast.Visibility m_7172_(GuiGraphics gui, ToastComponent component, long startTime) {
        int time = Math.round(((Float)Configs.TOAST_TIME.value).floatValue() * 1000.0f);
        int titleTime = Math.round(((Float)Configs.TOAST_TITLE_TIME.value).floatValue() * 1000.0f);
        if (this.update) {
            if (startTime - this.startTime < (long)time) {
                Toast.Visibility.SHOW.m_94909_(component.m_94929_().m_91106_());
            }
            this.startTime = startTime;
            this.update = false;
        }
        long timeDiff = startTime - this.startTime;
        UIHelper.enableBlend();
        int frame = (Boolean)Configs.REDUCED_MOTION.value != false ? 0 : (int)((float)FiguraMod.ticks / 5.0f % (float)this.type.frames);
        gui.m_280163_(this.type.texture, 0, 0, 0.0f, (float)(frame * this.m_94899_()), this.m_7828_(), this.m_94899_(), this.m_7828_(), this.m_94899_() * this.type.frames);
        Font font = component.m_94929_().f_91062_;
        if (this.message.getString().isBlank()) {
            this.renderText(this.title, font, gui, 255);
        } else if (this.title.getString().isBlank()) {
            this.renderText(this.message, font, gui, 255);
        } else {
            List a = font.m_92923_((FormattedText)this.title, this.m_7828_() - this.type.spacing - 1);
            List b = font.m_92923_((FormattedText)this.message, this.m_7828_() - this.type.spacing - 1);
            if (a.size() == 1 && b.size() == 1) {
                float f = (float)this.m_94899_() / 2.0f;
                Objects.requireNonNull(font);
                int y = Math.round(f - 9.0f - 1.0f);
                gui.m_280430_(font, this.title, this.type.spacing, y, 0xFFFFFF);
                gui.m_280430_(font, this.message, this.type.spacing, y * 2 + 4, 0xFFFFFF);
            } else if (timeDiff < (long)titleTime) {
                this.renderText(this.title, font, gui, Math.round(Math.min(Math.max((float)((long)titleTime - timeDiff) / 300.0f, 0.0f), 1.0f) * 255.0f));
            } else {
                this.renderText(this.message, font, gui, Math.round(Math.min(Math.max((float)(timeDiff - (long)titleTime) / 300.0f, 0.0f), 1.0f) * 255.0f));
            }
        }
        return timeDiff < (long)time ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public void renderText(Component text, Font font, GuiGraphics gui, int alpha) {
        List list = font.m_92923_((FormattedText)text, this.m_7828_() - this.type.spacing - 1);
        if (list.size() == 1) {
            int n = this.type.spacing;
            float f = (float)this.m_94899_() / 2.0f;
            Objects.requireNonNull(font);
            gui.m_280430_(font, text, n, Math.round(f - 9.0f / 2.0f), 0xFFFFFF + (alpha << 24));
        } else {
            float f = (float)this.m_94899_() / 2.0f;
            Objects.requireNonNull(font);
            int y = Math.round(f - 9.0f - 1.0f);
            for (int i = 0; i < list.size(); ++i) {
                gui.m_280648_(font, (FormattedCharSequence)list.get(i), this.type.spacing, y * (i + 1) + 4 * i, 0xFFFFFF + (alpha << 24));
            }
        }
    }

    public Object m_7283_() {
        return this.type;
    }

    public int m_7828_() {
        return this.type.width;
    }

    public int m_94899_() {
        return 32;
    }

    public static void sendToast(Object title) {
        FiguraToast.sendToast(title, Component.m_237119_());
    }

    public static void sendToast(Object title, ToastType type) {
        FiguraToast.sendToast(title, Component.m_237119_(), type);
    }

    public static void sendToast(Object title, Object message) {
        FiguraToast.sendToast(title, message, ToastType.DEFAULT);
    }

    public static void sendToast(Object title, Object message, ToastType type) {
        MutableComponent text2;
        MutableComponent text;
        if (title instanceof Component) {
            Component t = (Component)title;
            v0 = t;
        } else {
            v0 = text = Component.m_237115_((String)title.toString());
        }
        if (message instanceof Component) {
            Component m = (Component)message;
            v1 = m;
        } else {
            v1 = text2 = Component.m_237115_((String)message.toString());
        }
        if (type == ToastType.DEFAULT && ((Boolean)Configs.EASTER_EGGS.value).booleanValue()) {
            Calendar calendar = FiguraMod.CALENDAR;
            calendar.setTime(new Date());
            if (calendar.get(5) == 1 && calendar.get(2) == 3 || Math.random() < 1.0E-4) {
                type = ToastType.CHEESE;
            }
        }
        ToastComponent toasts = Minecraft.m_91087_().m_91300_();
        FiguraToast toast = (FiguraToast)toasts.m_94926_(FiguraToast.class, (Object)type);
        FiguraMod.debug("Sent toast: \"{}\", \"{}\" of type: \"{}\"", text.getString(), text2.getString(), type.name());
        if (toast != null) {
            toast.update((Component)text, (Component)text2, true);
        } else {
            toasts.m_94922_((Toast)new FiguraToast((Component)text, (Component)text2, type));
        }
    }

    public static enum ToastType {
        DEFAULT(new FiguraIdentifier("textures/gui/toast/default.png"), 4, 160, 31, 0x55FFFF),
        WARNING(new FiguraIdentifier("textures/gui/toast/warning.png"), 4, 160, 31, 0xFFFF00),
        ERROR(new FiguraIdentifier("textures/gui/toast/error.png"), 4, 160, 31, 0xFF0000),
        CHEESE(new FiguraIdentifier("textures/gui/toast/cheese.png"), 1, 160, 31, ColorUtils.Colors.CHEESE.hex);

        private final ResourceLocation texture;
        private final int frames;
        private final Style style;
        private final int width;
        private final int spacing;

        private ToastType(ResourceLocation texture, int frames, int width, int spacing, int color) {
            this.texture = texture;
            this.frames = frames;
            this.width = width;
            this.spacing = spacing;
            this.style = Style.f_131099_.m_178520_(color);
        }
    }
}

