/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.forge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.forge.ModConfig;
import org.figuramc.figura.gui.forge.GuiOverlay;
import org.figuramc.figura.gui.forge.GuiUnderlay;
import org.figuramc.figura.utils.forge.FiguraResourceListenerImpl;

@Mod.EventBusSubscriber(modid="figura", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FiguraModClientForge
extends FiguraMod {
    public static List<KeyMapping> KEYBINDS = new ArrayList<KeyMapping>();
    private static final List<NamedGuiOverlay> vanillaOverlays = new ArrayList<NamedGuiOverlay>();

    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent event) {
        FiguraModClientForge.onClientInit();
        ModConfig.registerConfigScreen();
        for (VanillaGuiOverlay overlay : VanillaGuiOverlay.values()) {
            vanillaOverlays.add(overlay.type());
        }
    }

    @SubscribeEvent
    public static void registerResourceListener(RegisterClientReloadListenersEvent event) {
        FiguraModClientForge.getResourceListeners().forEach(figuraResourceListener -> event.registerReloadListener((PreparableReloadListener)((FiguraResourceListenerImpl)figuraResourceListener)));
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("figura_overlay", (IGuiOverlay)new GuiOverlay());
        event.registerBelowAll("figura_underlay", (IGuiOverlay)new GuiUnderlay());
    }

    public static void cancelVanillaOverlays(RenderGuiOverlayEvent.Pre event) {
        if (vanillaOverlays.contains(event.getOverlay())) {
            Avatar avatar;
            Entity entity = Minecraft.m_91087_().m_91288_();
            Avatar avatar2 = avatar = entity == null ? null : AvatarManager.getAvatar(entity);
            if (avatar != null && avatar.luaRuntime != null && !avatar.luaRuntime.renderer.renderHUD) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        ConfigManager.init();
        for (KeyMapping value : KEYBINDS) {
            if (value == null) continue;
            event.register(value);
        }
    }
}

