/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.font.EmojiContainer;
import org.figuramc.figura.font.EmojiUnicodeLookup;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;

class EmojiListCommand {
    private static final Component COMMA_SPACE = Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY);

    EmojiListCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder load = LiteralArgumentBuilder.literal((String)"emojis");
        RequiredArgumentBuilder path = RequiredArgumentBuilder.argument((String)"category", (ArgumentType)StringArgumentType.greedyString());
        path.suggests(EmojiListCommand::getSuggestions);
        path.executes(EmojiListCommand::listCategory);
        return (LiteralArgumentBuilder)load.then((ArgumentBuilder)path);
    }

    public static CompletableFuture<Suggestions> getSuggestions(CommandContext<FiguraClientCommandSource> context, SuggestionsBuilder builder) {
        builder.suggest("all");
        Emojis.getCategoryNames().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int listCategory(CommandContext<FiguraClientCommandSource> context) {
        FiguraClientCommandSource src = (FiguraClientCommandSource)context.getSource();
        String category = (String)context.getArgument("category", String.class);
        if (Objects.equals(category, "all")) {
            for (String curCategory : Emojis.getCategoryNames()) {
                if (!EmojiListCommand.printEmojis(curCategory, src::figura$sendFeedback, src::figura$sendError)) {
                    return 0;
                }
                src.figura$sendFeedback((Component)Component.m_237113_((String)""));
            }
            return 1;
        }
        return EmojiListCommand.printEmojis(category, src::figura$sendFeedback, src::figura$sendError) ? 1 : 0;
    }

    private static boolean printEmojis(String category, Consumer<Component> feedback, Consumer<Component> error) {
        if (!Emojis.hasCategory(category)) {
            error.accept((Component)Component.m_237113_((String)("Emoji category \"" + category + "\" doesn't exist!")));
            return false;
        }
        EmojiContainer container = Emojis.getCategory(category);
        Collection<String> unicodeValues = container.getLookup().unicodeValues();
        EmojiUnicodeLookup lookup = container.getLookup();
        feedback.accept((Component)Component.m_237113_((String)String.format("--- %s (%s) ---", container.name, unicodeValues.size())).m_130948_(ColorUtils.Colors.AWESOME_BLUE.style));
        MutableComponent comp = Component.m_237113_((String)"");
        unicodeValues.stream().sorted().forEach(unicode -> {
            String[] aliases = lookup.getNames((String)unicode);
            if (aliases != null) {
                MutableComponent msg = Component.m_237113_((String)"");
                for (int i = 0; i < aliases.length; ++i) {
                    msg.m_7220_((Component)Component.m_237113_((String)aliases[i]).m_130948_(ColorUtils.Colors.AWESOME_BLUE.style));
                    if (i >= aliases.length - 1) continue;
                    msg.m_7220_(COMMA_SPACE);
                }
                msg.m_7220_((Component)Component.m_237113_((String)("\ncodepoint: " + unicode.codePointAt(0))).m_130940_(ChatFormatting.GRAY));
                comp.m_7220_(Emojis.getEmoji(aliases[0], msg));
            }
        });
        feedback.accept((Component)comp);
        return true;
    }
}

