/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.datafixers.util.Pair;
import java.util.BitSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class Badges {
    public static final ResourceLocation FONT = new FiguraIdentifier("badges");

    public static Component fetchBadges(UUID id) {
        int i;
        if (PermissionManager.get(id).getCategory() == Permissions.Category.BLOCKED) {
            return Component.m_237119_();
        }
        Pair<BitSet, BitSet> pair = AvatarManager.getBadges(id);
        if (pair == null) {
            return Component.m_237119_();
        }
        MutableComponent badges = Component.m_237119_().m_130948_(Style.f_131099_.m_131150_(FONT).m_131140_(ChatFormatting.WHITE).m_178524_(Boolean.valueOf(false)));
        Avatar avatar = AvatarManager.getAvatarForPlayer(id);
        if (avatar != null) {
            if (!avatar.loaded) {
                badges.m_7220_((Component)Component.m_237113_((String)Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)));
            } else if (avatar.nbt != null) {
                block20: {
                    BitSet prideSet = (BitSet)pair.getFirst();
                    Pride[] pride = Pride.values();
                    for (i = pride.length - 1; i >= 0; --i) {
                        if (!prideSet.get(i)) continue;
                        badges.m_7220_(pride[i].badge);
                        break block20;
                    }
                    badges.m_7220_((Component)System.DEFAULT.badge.m_6881_().m_130948_(Style.f_131099_.m_178520_(ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.color)))));
                }
                if (avatar.scriptError) {
                    if (avatar.errorText == null) {
                        badges.m_7220_(System.ERROR.badge);
                    } else {
                        badges.m_7220_((Component)System.ERROR.badge.m_6881_().m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)System.ERROR.desc.m_6881_().m_130946_("\n\n").m_7220_(avatar.errorText)))));
                    }
                }
                if (avatar.versionStatus > 0) {
                    badges.m_7220_(System.WARNING.badge);
                }
                if (!avatar.noPermissions.isEmpty()) {
                    MutableComponent badge = System.PERMISSIONS.badge.m_6881_();
                    MutableComponent desc = System.PERMISSIONS.desc.m_6881_().m_130946_("\n");
                    for (Permissions t : avatar.noPermissions) {
                        desc.m_130946_("\n\u2022 ").m_7220_((Component)FiguraText.of("badges.no_permissions." + t.name.toLowerCase(Locale.US)));
                    }
                    badges.m_7220_((Component)badge.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)desc))));
                }
            }
        }
        if (avatar != null) {
            BitSet specialSet = (BitSet)pair.getSecond();
            Special[] specialValues = Special.values();
            for (i = specialValues.length - 1; i >= 0; --i) {
                if (!specialSet.get(i)) continue;
                Special special = specialValues[i];
                Integer color = special.color;
                if (avatar.badgeToColor.containsKey(special.name().toLowerCase(Locale.US))) {
                    color = ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.badgeToColor.get(special.name().toLowerCase(Locale.US))));
                }
                Component badge = color != null ? special.badge.m_6881_().m_130948_(Style.f_131099_.m_178520_(color.intValue())) : special.badge;
                badges.m_7220_(badge);
            }
        }
        if (avatar != null && ((Boolean)Configs.SOUND_BADGE.value).booleanValue()) {
            if (avatar.lastPlayingSound > 0) {
                badges.m_7220_(System.SOUND.badge);
            } else if (SoundAPI.getSoundEngine().figura$isPlaying(id)) {
                avatar.lastPlayingSound = 20;
                badges.m_7220_(System.SOUND.badge);
            }
        }
        return badges;
    }

    public static Component noBadges4U(Component text) {
        return TextUtils.replaceInText((FormattedText)text, "[-*/+=\u2757\u274c\ud83d\udee1\u2605\u2606\u2764\u6587\u2712\ud83d\uddff0-9a-f]", TextUtils.UNKNOWN, (s, style) -> style.m_131192_().equals((Object)FONT) || style.m_131192_().equals((Object)UIHelper.UI_FONT), Integer.MAX_VALUE);
    }

    public static Pair<BitSet, BitSet> emptyBadges() {
        return Pair.of((Object)new BitSet(Pride.values().length), (Object)new BitSet(Special.values().length));
    }

    public static boolean hasCustomBadges(Component text) {
        return text.m_7451_((style, string) -> string.contains("${badges}") || string.contains("${segdab}") ? FormattedText.f_130759_ : Optional.empty(), Style.f_131099_).isPresent();
    }

    public static Component appendBadges(Component text, UUID id, boolean allow) {
        MutableComponent badges = allow ? Badges.fetchBadges(id) : Component.m_237119_();
        boolean custom = Badges.hasCustomBadges(text);
        if (!custom) {
            return badges.getString().isBlank() ? text : text.m_6881_().m_130946_(" ").m_7220_((Component)badges);
        }
        text = TextUtils.replaceInText((FormattedText)text, "\\$\\{badges\\}(?s)", badges);
        text = TextUtils.replaceInText((FormattedText)text, "\\$\\{segdab\\}(?s)", TextUtils.reverse((FormattedText)badges));
        return text;
    }

    public static enum Pride {
        AGENDER("\u16a0"),
        AROACE("\u16a1"),
        AROMANTIC("\u16a2"),
        ASEXUAL("\u16a3"),
        BIGENDER("\u16a4"),
        BISEXUAL("\u16a5"),
        DEMIBOY("\u16a6"),
        DEMIGENDER("\u16a7"),
        DEMIGIRL("\u16a8"),
        DEMIROMANTIC("\u16a9"),
        DEMISEXUAL("\u16aa"),
        DISABILITY("\u16ab"),
        FINSEXUAL("\u16ac"),
        GAYMEN("\u16ad"),
        GENDERFAE("\u16ae"),
        GENDERFLUID("\u16af"),
        GENDERQUEER("\u16b0"),
        INTERSEX("\u16b1"),
        LESBIAN("\u16b2"),
        NONBINARY("\u16b3"),
        PANSEXUAL("\u16b4"),
        PLURAL("\u16b5"),
        POLYSEXUAL("\u16b6"),
        PRIDE("\u16b7"),
        TRANSGENDER("\u16b8");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.pride." + this.name().toLowerCase(Locale.US));

        private Pride(String unicode) {
            this.badge = Component.m_237113_((String)unicode).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.desc)));
        }
    }

    public static enum System {
        DEFAULT("\u25b3"),
        PERMISSIONS("\ud83d\udee1"),
        WARNING("\u2757"),
        ERROR("\u274c"),
        SOUND("\ud83d\udd0a");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.system." + this.name().toLowerCase(Locale.US));

        private System(String unicode) {
            this.badge = Component.m_237113_((String)unicode).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.desc)));
        }
    }

    public static enum Special {
        DEV("\u2605"),
        DISCORD_STAFF("\u2606", ColorUtils.Colors.DISCORD.hex),
        CONTEST("\u2606", ColorUtils.Colors.AWESOME_BLUE.hex),
        DONATOR("\u2764", ColorUtils.Colors.AWESOME_BLUE.hex),
        TRANSLATOR("\u6587"),
        TEXTURE_ARTIST("\u2712"),
        IMMORTALIZED("\ud83d\uddff");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.special." + this.name().toLowerCase(Locale.US));
        public final Integer color;

        private Special(String unicode) {
            this(unicode, null);
        }

        private Special(String unicode, Integer color) {
            Style style = Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.desc));
            if (color != null) {
                style = style.m_178520_(color.intValue());
            }
            this.color = color;
            this.badge = Component.m_237113_((String)unicode).m_130948_(style);
        }
    }
}

