/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.blaze3d.audio.OggAudioStream;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.animation.AnimationPlayer;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.FiguraLuaPrinter;
import org.figuramc.figura.lua.FiguraLuaRuntime;
import org.figuramc.figura.lua.api.data.FiguraBuffer;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.particle.ParticleAPI;
import org.figuramc.figura.lua.api.ping.PingArg;
import org.figuramc.figura.lua.api.ping.PingFunction;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.PartCustomization;
import org.figuramc.figura.model.rendering.AvatarRenderer;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.model.rendering.ImmediateAvatarRenderer;
import org.figuramc.figura.model.rendering.PartFilterScheme;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.PathUtils;
import org.figuramc.figura.utils.RefilledNumber;
import org.figuramc.figura.utils.Version;
import org.figuramc.figura.utils.ui.UIHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class Avatar {
    private static CompletableFuture<Void> tasks;
    public static boolean firstPerson;
    public final UUID owner;
    public final EntityType<?> entityType;
    public CompoundTag nbt;
    public boolean loaded = true;
    public final boolean isHost;
    public String name;
    public String entityName;
    public String authors;
    public Version version;
    public String id;
    public int fileSize;
    public String color;
    public Map<String, String> badgeToColor = new HashMap<String, String>();
    public Map<String, byte[]> resources = new HashMap<String, byte[]>();
    public boolean minify;
    private final Queue<Runnable> events = new ConcurrentLinkedQueue<Runnable>();
    public final ArrayList<FiguraBuffer> openBuffers = new ArrayList();
    public AvatarRenderer renderer;
    public FiguraLuaRuntime luaRuntime;
    public EntityRenderMode renderMode = EntityRenderMode.OTHER;
    public final PermissionPack.PlayerPermissionPack permissions;
    public final Map<String, SoundBuffer> customSounds = new HashMap<String, SoundBuffer>();
    public final Map<Integer, Animation> animations = new HashMap<Integer, Animation>();
    public boolean hasTexture;
    public boolean scriptError;
    public Component errorText;
    public Set<Permissions> noPermissions = new HashSet<Permissions>();
    public Set<Permissions> permissionsToTick = new HashSet<Permissions>();
    public int lastPlayingSound = 0;
    public int versionStatus = 0;
    public int animationComplexity;
    public final Instructions complexity;
    public final Instructions init;
    public final Instructions render;
    public final Instructions worldRender;
    public final Instructions tick;
    public final Instructions worldTick;
    public final Instructions animation;
    public final RefilledNumber particlesRemaining;
    public final RefilledNumber soundsRemaining;
    private static final PartCustomization PIVOT_PART_RENDERING_CUSTOMIZATION;

    private Avatar(UUID owner, EntityType<?> type, String name) {
        this.owner = owner;
        this.entityType = type;
        this.isHost = type == EntityType.f_20532_ && FiguraMod.isLocal(owner);
        this.permissions = type == EntityType.f_20532_ ? PermissionManager.get(owner) : PermissionManager.getMobPermissions(owner);
        this.complexity = new Instructions(this.permissions.get(Permissions.COMPLEXITY));
        this.init = new Instructions(this.permissions.get(Permissions.INIT_INST));
        this.render = new Instructions(this.permissions.get(Permissions.RENDER_INST));
        this.worldRender = new Instructions(this.permissions.get(Permissions.WORLD_RENDER_INST));
        this.tick = new Instructions(this.permissions.get(Permissions.TICK_INST));
        this.worldTick = new Instructions(this.permissions.get(Permissions.WORLD_TICK_INST));
        this.animation = new Instructions(this.permissions.get(Permissions.ANIMATION_INST));
        this.particlesRemaining = new RefilledNumber(this.permissions.get(Permissions.PARTICLES));
        this.soundsRemaining = new RefilledNumber(this.permissions.get(Permissions.SOUNDS));
        this.entityName = name == null ? "" : name;
    }

    public Avatar(UUID owner) {
        this(owner, EntityType.f_20532_, EntityUtils.getNameForUUID(owner));
    }

    public Avatar(Entity entity) {
        this(entity.m_20148_(), entity.m_6095_(), entity.m_7755_().getString());
    }

    public void load(CompoundTag nbt) {
        Runnable toRun = () -> {
            this.nbt = nbt;
            this.loaded = false;
        };
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
        tasks.join();
        if (nbt == null) {
            this.loaded = true;
            return;
        }
        tasks.thenRun(() -> {
            try {
                CompoundTag metadata = nbt.m_128469_("metadata");
                this.name = metadata.m_128461_("name");
                this.authors = metadata.m_128461_("authors");
                this.version = new Version(metadata.m_128461_("ver"));
                if (metadata.m_128441_("id")) {
                    this.id = metadata.m_128461_("id");
                }
                if (metadata.m_128441_("color")) {
                    this.color = metadata.m_128461_("color");
                }
                if (metadata.m_128441_("minify")) {
                    this.minify = metadata.m_128471_("minify");
                }
                if (nbt.m_128441_("resources")) {
                    CompoundTag res = nbt.m_128469_("resources");
                    for (String k : res.m_128431_()) {
                        this.resources.put(k, res.m_128463_(k));
                    }
                }
                for (String key : metadata.m_128431_()) {
                    if (!key.contains("badge_color_")) continue;
                    this.badgeToColor.put(key.replace("badge_color_", ""), metadata.m_128461_(key));
                }
                this.fileSize = this.getFileSize();
                this.versionStatus = this.getVersionStatus();
                if (this.entityName.isBlank()) {
                    this.entityName = this.name;
                }
                this.loadAnimations();
                this.renderer = new ImmediateAvatarRenderer(this);
                this.loadCustomSounds();
                this.createLuaRuntime();
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("", (Throwable)e);
                this.clean();
                this.nbt = null;
                this.renderer = null;
                this.luaRuntime = null;
            }
            this.loaded = true;
        });
    }

    public void tick() {
        Entity entity;
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return;
        }
        if (this.luaRuntime.getUser() == null && (entity = EntityUtils.getEntityByUUID(this.owner)) != null) {
            this.luaRuntime.setUser(entity);
            this.run("ENTITY_INIT", this.init.post(), new Object[0]);
        }
        for (Permissions t : this.permissionsToTick) {
            if (this.permissions.get(t) > 0) {
                this.noPermissions.remove(t);
                continue;
            }
            this.noPermissions.add(t);
        }
        if (this.lastPlayingSound > 0) {
            --this.lastPlayingSound;
        }
        this.particlesRemaining.set(this.permissions.get(Permissions.PARTICLES));
        this.particlesRemaining.tick();
        this.soundsRemaining.set(this.permissions.get(Permissions.SOUNDS));
        this.soundsRemaining.tick();
        FiguraMod.pushProfiler("worldTick");
        this.worldTick.reset(this.permissions.get(Permissions.WORLD_TICK_INST));
        this.run("WORLD_TICK", this.worldTick, new Object[0]);
        FiguraMod.popPushProfiler("tick");
        this.tick.reset(this.permissions.get(Permissions.TICK_INST));
        this.tickEvent();
        FiguraMod.popProfiler();
    }

    public void render(float delta) {
        if (this.complexity.remaining <= 0) {
            this.noPermissions.add(Permissions.COMPLEXITY);
        } else {
            this.noPermissions.remove(Permissions.COMPLEXITY);
        }
        this.complexity.reset(this.permissions.get(Permissions.COMPLEXITY));
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return;
        }
        this.render.reset(this.permissions.get(Permissions.RENDER_INST));
        this.worldRender.reset(this.permissions.get(Permissions.WORLD_RENDER_INST));
        this.run("WORLD_RENDER", this.worldRender, Float.valueOf(delta));
    }

    public void runPing(int id, byte[] data) {
        this.events.offer(() -> {
            if (this.scriptError || this.luaRuntime == null || !this.loaded) {
                return;
            }
            LuaValue[] args = PingArg.fromByteArray(data, this);
            String name = this.luaRuntime.ping.getName(id);
            PingFunction function = this.luaRuntime.ping.get(name);
            if (args == null || function == null) {
                return;
            }
            FiguraLuaPrinter.sendPingMessage(this, name, data.length, args);
            this.luaRuntime.run(function.func, this.tick, args);
        });
    }

    public LuaValue loadScript(String name, String chunk) {
        return this.scriptError || this.luaRuntime == null || !this.loaded ? null : this.luaRuntime.load(name, chunk);
    }

    private void flushQueuedEvents() {
        Runnable e;
        while ((e = this.events.poll()) != null) {
            try {
                e.run();
            }
            catch (Exception | StackOverflowError ex) {
                if (this.luaRuntime == null) continue;
                this.luaRuntime.error(ex);
            }
        }
    }

    @Nullable
    public Varargs run(Object toRun, Instructions limit, Object ... args) {
        this.flushQueuedEvents();
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return null;
        }
        Varargs ret = this.luaRuntime.run(toRun, limit, args);
        this.flushQueuedEvents();
        return ret;
    }

    public void punish(int amount) {
        if (this.luaRuntime != null) {
            this.luaRuntime.takeInstructions(amount);
        }
    }

    private boolean isCancelled(Varargs args) {
        if (args == null) {
            return false;
        }
        for (int i = 1; i <= args.narg(); ++i) {
            if (!args.arg(i).isboolean() || !args.arg(i).checkboolean()) continue;
            return true;
        }
        return false;
    }

    public void tickEvent() {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("TICK", this.tick, new Object[0]);
        }
    }

    public void renderEvent(float delta, FiguraMat4 poseMatrix) {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("RENDER", this.render, Float.valueOf(delta), this.renderMode.name(), poseMatrix);
        }
    }

    public void postRenderEvent(float delta, FiguraMat4 poseMatrix) {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("POST_RENDER", this.render.post(), Float.valueOf(delta), this.renderMode.name(), poseMatrix);
        }
        this.renderMode = EntityRenderMode.OTHER;
    }

    public void postWorldRenderEvent(float delta) {
        if (!this.loaded) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.allowMatrixUpdate = false;
        }
        this.run("POST_WORLD_RENDER", this.worldRender.post(), Float.valueOf(delta));
    }

    public boolean skullRenderEvent(float delta, BlockStateAPI block, ItemStackAPI item, EntityAPI<?> entity, String mode) {
        Varargs result = null;
        if (this.loaded && this.renderer != null && this.renderer.interceptRendersIntoFigura) {
            result = this.run("SKULL_RENDER", this.render, Float.valueOf(delta), block, item, entity, mode);
        }
        return this.isCancelled(result);
    }

    public boolean useItemEvent(ItemStackAPI stack, String type, int particleCount) {
        Varargs result = this.loaded ? this.run("USE_ITEM", this.tick, stack, type, particleCount) : null;
        return this.isCancelled(result);
    }

    public boolean arrowRenderEvent(float delta, EntityAPI<?> arrow) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("ARROW_RENDER", this.render, Float.valueOf(delta), arrow);
        }
        return this.isCancelled(result);
    }

    public boolean tridentRenderEvent(float delta, EntityAPI<?> trident) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("TRIDENT_RENDER", this.render, Float.valueOf(delta), trident);
        }
        return this.isCancelled(result);
    }

    public boolean itemRenderEvent(ItemStackAPI item, String mode, FiguraVec3 pos, FiguraVec3 rot, FiguraVec3 scale, boolean leftHanded, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        if (!this.loaded || this.renderer == null || !this.renderer.interceptRendersIntoFigura) {
            return false;
        }
        Varargs result = this.run("ITEM_RENDER", this.render, item, mode, pos, rot, scale, leftHanded);
        if (result == null) {
            return false;
        }
        boolean rendered = false;
        for (int i = 1; i <= result.narg(); ++i) {
            if (!result.arg(i).isuserdata(FiguraModelPart.class)) continue;
            rendered |= this.renderItem(stack, bufferSource, (FiguraModelPart)result.arg(i).checkuserdata(FiguraModelPart.class), light, overlay);
        }
        return rendered;
    }

    public boolean playSoundEvent(String id, FiguraVec3 pos, float vol, float pitch, boolean loop, String category, String file) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("ON_PLAY_SOUND", this.tick, id, pos, Float.valueOf(vol), Float.valueOf(pitch), loop, category, file);
        }
        return this.isCancelled(result);
    }

    public void resourceReloadEvent() {
        if (this.loaded) {
            this.run("RESOURCE_RELOAD", this.tick, new Object[0]);
        }
    }

    public String chatSendMessageEvent(String message) {
        Varargs val;
        Varargs varargs = val = this.loaded ? this.run("CHAT_SEND_MESSAGE", this.tick, message) : null;
        return val == null || !val.isnil(1) && (Boolean)Configs.CHAT_MESSAGES.value == false ? message : (val.isnil(1) ? "" : val.arg(1).tojstring());
    }

    public Pair<String, Integer> chatReceivedMessageEvent(String message, String json) {
        Varargs val;
        Varargs varargs = val = this.loaded ? this.run("CHAT_RECEIVE_MESSAGE", this.tick, message, json) : null;
        if (val == null) {
            return null;
        }
        if (val.arg(1).isboolean() && !val.arg(1).checkboolean()) {
            return Pair.of(null, null);
        }
        String msg = val.isnil(1) ? json : val.arg(1).tojstring();
        Integer color = null;
        if (val.arg(2).isuserdata(FiguraVec3.class)) {
            color = ColorUtils.rgbToInt((FiguraVec3)val.arg(2).checkuserdata(FiguraVec3.class));
        }
        return Pair.of((Object)msg, color);
    }

    public boolean mouseScrollEvent(double delta) {
        Varargs result = this.loaded ? this.run("MOUSE_SCROLL", this.tick, delta) : null;
        return this.isCancelled(result);
    }

    public boolean mouseMoveEvent(double x, double y) {
        Varargs result = this.loaded ? this.run("MOUSE_MOVE", this.tick, x, y) : null;
        return this.isCancelled(result);
    }

    public boolean mousePressEvent(int button, int action, int modifiers) {
        Varargs result = this.loaded ? this.run("MOUSE_PRESS", this.tick, button, action, modifiers) : null;
        return this.isCancelled(result);
    }

    public boolean keyPressEvent(int key, int action, int modifiers) {
        Varargs result = this.loaded ? this.run("KEY_PRESS", this.tick, key, action, modifiers) : null;
        return this.isCancelled(result);
    }

    public void charTypedEvent(String chars, int modifiers, int codePoint) {
        if (this.loaded) {
            this.run("CHAR_TYPED", this.tick, chars, modifiers, codePoint);
        }
    }

    private void render() {
        if (this.renderMode == EntityRenderMode.RENDER || this.renderMode == EntityRenderMode.FIRST_PERSON) {
            this.complexity.use(this.renderer.render());
            return;
        }
        int prev = this.complexity.remaining;
        this.complexity.remaining = this.permissions.get(Permissions.COMPLEXITY);
        this.renderer.render();
        this.complexity.remaining = prev;
    }

    public void render(Entity entity, float yaw, float delta, float alpha, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, LivingEntityRenderer<?, ?> entityRenderer, PartFilterScheme filter, boolean translucent, boolean glowing) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        this.renderer.vanillaModelData.update(entityRenderer);
        this.renderer.yaw = yaw;
        this.renderer.entity = entity;
        this.renderer.setupRenderer(filter, bufferSource, stack, delta, light, alpha, overlay, translucent, glowing);
        this.render();
    }

    public synchronized void worldRender(Entity entity, double camX, double camY, double camZ, PoseStack stack, MultiBufferSource bufferSource, int lightFallback, float tickDelta, EntityRenderMode mode) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        EntityRenderMode prevRenderMode = this.renderMode;
        this.renderMode = mode;
        boolean update = prevRenderMode != EntityRenderMode.OTHER || this.renderMode == EntityRenderMode.FIRST_PERSON_WORLD;
        this.renderer.pivotCustomizations.values().clear();
        this.renderer.allowMatrixUpdate = this.renderer.updateLight = update;
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.WORLD, bufferSource, stack, tickDelta, lightFallback, 1.0f, OverlayTexture.f_118083_, false, false, camX, camY, camZ);
        this.complexity.use(this.renderer.renderSpecialParts());
        this.renderMode = prevRenderMode;
        this.renderer.updateLight = false;
    }

    public void capeRender(Entity entity, MultiBufferSource bufferSource, PoseStack stack, int light, float tickDelta, ModelPart cloak) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("capeRender");
        this.renderer.vanillaModelData.update(ParentType.Cape, cloak);
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.CAPE, bufferSource, stack, tickDelta, light, 1.0f, OverlayTexture.f_118083_, this.renderer.translucent, this.renderer.glowing);
        this.render();
        FiguraMod.popProfiler(3);
    }

    public void elytraRender(Entity entity, MultiBufferSource bufferSource, PoseStack stack, int light, float tickDelta, EntityModel<?> model) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("elytraRender");
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.LEFT_ELYTRA, bufferSource, stack, tickDelta, light, 1.0f, OverlayTexture.f_118083_, this.renderer.translucent, this.renderer.glowing);
        FiguraMod.pushProfiler("leftWing");
        this.renderer.vanillaModelData.update(ParentType.LeftElytra, model);
        this.renderer.renderSpecialParts();
        FiguraMod.popPushProfiler("rightWing");
        this.renderer.vanillaModelData.update(ParentType.RightElytra, model);
        this.renderer.currentFilterScheme = PartFilterScheme.RIGHT_ELYTRA;
        this.renderer.renderSpecialParts();
        FiguraMod.popProfiler(4);
    }

    public void firstPersonWorldRender(Entity watcher, MultiBufferSource bufferSource, PoseStack matrices, Camera camera, float tickDelta) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("firstPersonWorldRender");
        int light = Minecraft.m_91087_().m_91290_().m_114394_(watcher, tickDelta);
        Vec3 camPos = camera.m_90583_();
        this.worldRender(watcher, camPos.f_82479_, camPos.f_82480_, camPos.f_82481_, matrices, bufferSource, light, tickDelta, EntityRenderMode.FIRST_PERSON_WORLD);
        FiguraMod.popProfiler(3);
    }

    public void firstPersonRender(PoseStack stack, MultiBufferSource bufferSource, Player player, PlayerRenderer playerRenderer, ModelPart arm, int light, float tickDelta) {
        boolean config;
        if (this.renderer == null || !this.loaded) {
            return;
        }
        boolean lefty = arm == ((PlayerModel)playerRenderer.m_7200_()).f_102812_;
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("firstPersonRender");
        FiguraMod.pushProfiler(lefty ? "leftArm" : "rightArm");
        PartFilterScheme filter = lefty ? PartFilterScheme.LEFT_ARM : PartFilterScheme.RIGHT_ARM;
        this.renderer.allowHiddenTransforms = config = ((Boolean)Configs.ALLOW_FP_HANDS.value).booleanValue();
        this.renderer.allowMatrixUpdate = false;
        this.renderer.ignoreVanillaVisibility = true;
        stack.m_85836_();
        if (!config) {
            stack.m_252781_(Axis.f_252403_.m_252961_(arm.f_104205_));
            stack.m_252781_(Axis.f_252436_.m_252961_(arm.f_104204_));
            stack.m_252781_(Axis.f_252529_.m_252961_(arm.f_104203_));
        }
        this.render((Entity)player, 0.0f, tickDelta, 1.0f, stack, bufferSource, light, OverlayTexture.f_118083_, (LivingEntityRenderer<?, ?>)playerRenderer, filter, false, false);
        stack.m_85849_();
        this.renderer.allowHiddenTransforms = true;
        this.renderer.ignoreVanillaVisibility = false;
        FiguraMod.popProfiler(4);
    }

    public void hudRender(PoseStack stack, MultiBufferSource bufferSource, Entity entity, float tickDelta) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("hudRender");
        stack.m_85836_();
        stack.m_85850_().m_252922_().scale(16.0f, 16.0f, -16.0f);
        stack.m_85850_().m_252943_().scale(1.0f, 1.0f, -1.0f);
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.HUD, bufferSource, stack, tickDelta, 0xF000F0, 1.0f, OverlayTexture.f_118083_, false, false);
        if (this.renderer.renderSpecialParts() > 0) {
            ((MultiBufferSource.BufferSource)this.renderer.bufferSource).m_109911_();
        }
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        stack.m_85849_();
        FiguraMod.popProfiler(2);
    }

    public boolean skullRender(PoseStack stack, MultiBufferSource bufferSource, int light, Direction direction, float yaw) {
        if (this.renderer == null || !this.loaded || !this.renderer.interceptRendersIntoFigura) {
            return false;
        }
        stack.m_85836_();
        if (direction == null) {
            stack.m_85837_(0.5, 0.0, 0.5);
        } else {
            stack.m_85837_(0.5 - (double)direction.m_122429_() * 0.25, 0.25, 0.5 - (double)direction.m_122431_() * 0.25);
        }
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        this.renderer.allowPivotParts = false;
        this.renderer.setupRenderer(PartFilterScheme.SKULL, bufferSource, stack, 1.0f, light, 1.0f, OverlayTexture.f_118083_, false, false);
        int comp = this.renderer.renderSpecialParts();
        this.complexity.use(comp);
        boolean bool = comp > 0 || this.headRender(stack, bufferSource, light, true);
        this.renderer.allowPivotParts = true;
        stack.m_85849_();
        return bool;
    }

    public boolean headRender(PoseStack stack, MultiBufferSource bufferSource, int light, boolean useComplexity) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        boolean oldMat = this.renderer.allowMatrixUpdate;
        this.renderer.setupRenderer(PartFilterScheme.HEAD, bufferSource, stack, 1.0f, light, 1.0f, OverlayTexture.f_118083_, false, false);
        this.renderer.allowHiddenTransforms = false;
        this.renderer.allowMatrixUpdate = false;
        this.renderer.ignoreVanillaVisibility = true;
        int comp = this.renderer.render();
        if (useComplexity) {
            this.complexity.use(comp);
        }
        this.renderer.allowMatrixUpdate = oldMat;
        this.renderer.allowHiddenTransforms = true;
        this.renderer.ignoreVanillaVisibility = false;
        return comp > 0 && this.luaRuntime != null && !this.luaRuntime.vanilla_model.HEAD.checkVisible();
    }

    public boolean renderPortrait(GuiGraphics gui, int x, int y, int size, float modelScale, boolean upsideDown) {
        if (!((Boolean)Configs.AVATAR_PORTRAIT.value).booleanValue() || this.renderer == null || !this.loaded) {
            return false;
        }
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85837_((double)x, (double)y, 0.0);
        pose.m_85841_(modelScale, modelScale * (float)(upsideDown ? 1 : -1), modelScale);
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        Vector3f pos = pose.m_85850_().m_252922_().transformPosition(new Vector3f());
        int x1 = (int)pos.x;
        int y1 = (int)pos.y;
        int x2 = (int)pos.x + size;
        int y2 = (int)pos.y + size;
        gui.m_280588_(x1, y1, x2, y2);
        UIHelper.paperdoll = true;
        UIHelper.dollScale = 16.0f;
        pose.m_85837_(0.25, upsideDown ? 0.0 : 0.5, 0.0);
        Lighting.m_84930_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        int light = 0xF000F0;
        this.renderer.allowPivotParts = false;
        this.renderer.setupRenderer(PartFilterScheme.PORTRAIT, (MultiBufferSource)buffer, pose, 1.0f, light, 1.0f, OverlayTexture.f_118083_, false, false);
        int comp = this.renderer.renderSpecialParts();
        boolean ret = comp > 0 || this.headRender(pose, (MultiBufferSource)buffer, light, false);
        buffer.m_109911_();
        pose.m_85849_();
        gui.m_280618_();
        UIHelper.paperdoll = false;
        this.renderer.allowPivotParts = true;
        return ret;
    }

    public boolean renderArrow(PoseStack stack, MultiBufferSource bufferSource, float delta, int light) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        stack.m_85836_();
        Quaternionf quaternionf = Axis.f_252529_.m_252977_(135.0f);
        Quaternionf quaternionf2 = Axis.f_252436_.m_252977_(-90.0f);
        quaternionf.mul((Quaternionfc)quaternionf2);
        stack.m_252781_(quaternionf);
        this.renderer.setupRenderer(PartFilterScheme.ARROW, bufferSource, stack, delta, light, 1.0f, OverlayTexture.f_118083_, false, false);
        int comp = this.renderer.renderSpecialParts();
        stack.m_85849_();
        return comp > 0;
    }

    public boolean renderTrident(PoseStack stack, MultiBufferSource bufferSource, float delta, int light) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        stack.m_85836_();
        Quaternionf quaternionf = Axis.f_252403_.m_252977_(90.0f);
        Quaternionf quaternionf2 = Axis.f_252436_.m_252977_(90.0f);
        quaternionf.mul((Quaternionfc)quaternionf2);
        stack.m_252781_(quaternionf);
        this.renderer.setupRenderer(PartFilterScheme.TRIDENT, bufferSource, stack, delta, light, 1.0f, OverlayTexture.f_118083_, false, false);
        int comp = this.renderer.renderSpecialParts();
        stack.m_85849_();
        return comp > 0;
    }

    public boolean renderItem(PoseStack stack, MultiBufferSource bufferSource, FiguraModelPart part, int light, int overlay) {
        if (this.renderer == null || !this.loaded || part.parentType != ParentType.Item) {
            return false;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        this.renderer.setupRenderer(PartFilterScheme.ITEM, bufferSource, stack, 1.0f, light, 1.0f, overlay, false, false);
        this.renderer.itemToRender = part;
        int ret = this.renderer.renderSpecialParts();
        stack.m_85849_();
        return ret > 0;
    }

    public synchronized boolean pivotPartRender(ParentType parent, Consumer<PoseStack> consumer) {
        if (this.renderer == null || !this.loaded || !parent.isPivot) {
            return false;
        }
        Queue queue = this.renderer.pivotCustomizations.computeIfAbsent(parent, p -> new ConcurrentLinkedQueue());
        if (queue.isEmpty()) {
            return false;
        }
        int i = 0;
        while (!queue.isEmpty() && i++ < 1000) {
            Pair matrixPair = (Pair)queue.poll();
            PIVOT_PART_RENDERING_CUSTOMIZATION.setPositionMatrix((FiguraMat4)matrixPair.getFirst());
            PIVOT_PART_RENDERING_CUSTOMIZATION.setNormalMatrix((FiguraMat3)matrixPair.getSecond());
            Avatar.PIVOT_PART_RENDERING_CUSTOMIZATION.needsMatrixRecalculation = false;
            PoseStack stack = PIVOT_PART_RENDERING_CUSTOMIZATION.copyIntoGlobalPoseStack();
            consumer.accept(stack);
        }
        queue.clear();
        return true;
    }

    public void updateMatrices(LivingEntityRenderer<?, ?> entityRenderer, PoseStack stack) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("updateMatrices");
        this.renderer.vanillaModelData.update(entityRenderer);
        this.renderer.currentFilterScheme = PartFilterScheme.MODEL;
        this.renderer.setMatrices(stack);
        this.renderer.updateMatrices();
        FiguraMod.popProfiler(3);
    }

    public void applyAnimations() {
        int animationsLimit;
        if (!this.loaded || this.scriptError) {
            return;
        }
        this.animation.reset(this.permissions.get(Permissions.ANIMATION_INST));
        int limit = animationsLimit = this.permissions.get(Permissions.BB_ANIMATIONS);
        for (Animation animation : this.animations.values()) {
            limit = AnimationPlayer.tick(animation, limit);
        }
        this.animationComplexity = animationsLimit - limit;
        if (limit <= 0) {
            this.noPermissions.add(Permissions.BB_ANIMATIONS);
        } else {
            this.noPermissions.remove(Permissions.BB_ANIMATIONS);
        }
    }

    public void clearAnimations() {
        if (!this.loaded || this.scriptError) {
            return;
        }
        for (Animation animation : this.animations.values()) {
            AnimationPlayer.clear(animation);
        }
    }

    public void clean() {
        if (this.renderer != null) {
            this.renderer.invalidate();
        }
        this.clearSounds();
        this.clearParticles();
        this.closeBuffers();
        this.events.clear();
    }

    public void clearSounds() {
        SoundAPI.getSoundEngine().figura$stopSound(this.owner, null);
        for (SoundBuffer value : this.customSounds.values()) {
            value.m_83802_();
        }
    }

    public void closeBuffers() {
        for (FiguraBuffer buffer : this.openBuffers) {
            if (buffer.isClosed()) continue;
            try {
                buffer.baseClose();
            }
            catch (Exception exception) {}
        }
        this.openBuffers.clear();
    }

    public void clearParticles() {
        ParticleAPI.getParticleEngine().figura$clearParticles(this.owner);
    }

    private int getFileSize() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)this.nbt, (OutputStream)baos);
            return baos.size();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to generate file size for model " + this.name, (Throwable)e);
            return 0;
        }
    }

    private int getVersionStatus() {
        if (this.version == null || NetworkStuff.latestVersion != null && this.version.compareTo(NetworkStuff.latestVersion) > 0) {
            return 0;
        }
        return this.version.compareTo(FiguraMod.VERSION);
    }

    private void createLuaRuntime() {
        if (!this.nbt.m_128441_("scripts")) {
            return;
        }
        HashMap<String, String> scripts = new HashMap<String, String>();
        CompoundTag scriptsNbt = this.nbt.m_128469_("scripts");
        for (String s : scriptsNbt.m_128431_()) {
            scripts.put(PathUtils.computeSafeString(s), new String(scriptsNbt.m_128463_(s), StandardCharsets.UTF_8));
        }
        CompoundTag metadata = this.nbt.m_128469_("metadata");
        ListTag autoScripts = metadata.m_128441_("autoScripts") ? metadata.m_128437_("autoScripts", 8) : null;
        FiguraLuaRuntime runtime = new FiguraLuaRuntime(this, scripts);
        if (this.renderer != null && this.renderer.root != null) {
            runtime.setGlobal("models", this.renderer.root);
        }
        this.init.reset(this.permissions.get(Permissions.INIT_INST));
        runtime.setInstructionLimit(this.init.remaining);
        this.events.offer(() -> {
            if (runtime.init(autoScripts)) {
                this.init.use(runtime.getInstructions());
            }
        });
    }

    private void loadAnimations() {
        if (!this.nbt.m_128441_("animations")) {
            return;
        }
        ArrayList<String> autoAnims = new ArrayList<String>();
        CompoundTag metadata = this.nbt.m_128469_("metadata");
        if (metadata.m_128441_("autoAnims")) {
            for (Tag name : metadata.m_128437_("autoAnims", 8)) {
                autoAnims.add(name.m_7916_());
            }
        }
        ListTag root = this.nbt.m_128437_("animations", 10);
        for (int i = 0; i < root.size(); ++i) {
            try {
                CompoundTag animNbt = root.m_128728_(i);
                if (!animNbt.m_128441_("mdl") || !animNbt.m_128441_("name")) continue;
                String mdl = animNbt.m_128461_("mdl");
                String name = animNbt.m_128461_("name");
                Animation.LoopMode loop = Animation.LoopMode.ONCE;
                if (animNbt.m_128441_("loop")) {
                    try {
                        loop = Animation.LoopMode.valueOf(animNbt.m_128461_("loop").toUpperCase(Locale.US));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Animation animation = new Animation(this, mdl, name, loop, animNbt.m_128441_("ovr") && animNbt.m_128471_("ovr"), animNbt.m_128441_("len") ? animNbt.m_128457_("len") : 0.0f, animNbt.m_128441_("off") ? animNbt.m_128457_("off") : 0.0f, animNbt.m_128441_("bld") ? animNbt.m_128457_("bld") : 1.0f, animNbt.m_128441_("sdel") ? animNbt.m_128457_("sdel") : 0.0f, animNbt.m_128441_("ldel") ? animNbt.m_128457_("ldel") : 0.0f);
                if (animNbt.m_128441_("code")) {
                    for (Tag code : animNbt.m_128437_("code", 10)) {
                        CompoundTag compound = (CompoundTag)code;
                        animation.newCode(compound.m_128457_("time"), compound.m_128461_("src"));
                    }
                }
                this.animations.put(i, animation);
                if (!autoAnims.contains(mdl + "." + name)) continue;
                animation.play();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadCustomSounds() {
        if (!this.nbt.m_128441_("sounds")) {
            return;
        }
        CompoundTag root = this.nbt.m_128469_("sounds");
        for (String key : root.m_128431_()) {
            try {
                this.loadSound(key, root.m_128463_(key));
            }
            catch (Exception e) {
                FiguraMod.LOGGER.warn("Failed to load custom sound \"" + key + "\"", (Throwable)e);
            }
        }
    }

    public void loadSound(String name, byte[] data) throws Exception {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
             OggAudioStream oggAudioStream = new OggAudioStream((InputStream)inputStream);){
            SoundBuffer sound = new SoundBuffer(oggAudioStream.m_83764_(), oggAudioStream.m_6206_());
            this.customSounds.put(name, sound);
        }
    }

    public FiguraTexture registerTexture(String name, NativeImage image, boolean ignoreSize) {
        int max = this.permissions.get(Permissions.TEXTURE_SIZE);
        if (!(ignoreSize || image.m_84982_() <= max && image.m_85084_() <= max)) {
            this.noPermissions.add(Permissions.TEXTURE_SIZE);
            throw new LuaError("Texture exceeded max size of " + max + " x " + max + " resolution, got " + image.m_84982_() + " x " + image.m_85084_());
        }
        FiguraTexture oldText = this.renderer.customTextures.get(name);
        if (oldText != null) {
            oldText.close();
        }
        if (this.renderer.customTextures.size() > 128) {
            throw new LuaError("Maximum amount of textures reached!");
        }
        FiguraTexture texture = new FiguraTexture(this, name, image);
        this.renderer.customTextures.put(name, texture);
        return texture;
    }

    static {
        PIVOT_PART_RENDERING_CUSTOMIZATION = new PartCustomization();
    }

    public static class Instructions {
        public int max;
        public int remaining;
        private int currPre;
        private int currPost;
        public int pre;
        public int post;
        private boolean inverted;

        public Instructions(int remaining) {
            this.reset(remaining);
        }

        public Instructions post() {
            this.inverted = true;
            return this;
        }

        public int getTotal() {
            return this.pre + this.post;
        }

        public void reset(int remaining) {
            this.max = this.remaining = remaining;
            this.currPost = 0;
            this.currPre = 0;
        }

        public void use(int amount) {
            this.remaining -= amount;
            if (!this.inverted) {
                this.currPre += amount;
                this.pre = this.currPre;
            } else {
                this.currPost += amount;
                this.post = this.currPost;
                this.inverted = false;
            }
        }
    }
}

