/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.init.EntityTypeInit;
import com.alexander.whatareyouvotingfor.init.ItemInit;
import com.alexander.whatareyouvotingfor.init.TagInit;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Armadillo
extends Animal {
    private static final UUID HIDING_ARMOR_MODIFIER_UUID = UUID.fromString("0da06039-5f18-47b4-be77-a132a05c76d0");
    private static final AttributeModifier HIDING_ARMOR_MODIFIER = new AttributeModifier(HIDING_ARMOR_MODIFIER_UUID, "Hiding armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    public AnimationState hideAnimationState = new AnimationState();
    public int hideAnimationTick;
    public final int hideAnimationLength = 12;
    public AnimationState openAnimationState = new AnimationState();
    public int openAnimationTick;
    public final int openAnimationLength = 25;
    public boolean hiding;
    public int scaredTime;
    public List<Mob> nearbyNonMonsters = Lists.newArrayList();
    public Player nearestPlayer;
    public double nearestPlayerLastX;
    public double nearestPlayerLastY;
    public double nearestPlayerLastZ;

    public Armadillo(EntityType<? extends Armadillo> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HideGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal(this, 0.6){

            public boolean m_8036_() {
                return !Armadillo.this.hiding && super.m_8036_();
            }

            public boolean m_8045_() {
                return !Armadillo.this.hiding && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.6, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), false){

            public boolean m_8036_() {
                return !Armadillo.this.hiding && super.m_8036_();
            }

            public boolean m_8045_() {
                return !Armadillo.this.hiding && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal(this, 1.3){

            public boolean m_8036_() {
                return !Armadillo.this.hiding && super.m_8036_();
            }

            public boolean m_8045_() {
                return !Armadillo.this.hiding && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return !Armadillo.this.hiding && super.m_8036_();
            }

            public boolean m_8045_() {
                return !Armadillo.this.hiding && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<Armadillo> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(TagInit.Blocks.ARMADILLOS_SPAWNABLE_ON) && Armadillo.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        Entity entity;
        if (this.hiding && (entity = p_27567_.m_7640_()) instanceof AbstractArrow) {
            return false;
        }
        boolean flag = super.m_6469_(p_27567_, p_27568_);
        if (flag) {
            this.scaredTime = 140;
            for (Armadillo armadillo : this.m_9236_().m_45976_(Armadillo.class, this.m_20191_().m_82400_(5.0))) {
                if (armadillo == this) continue;
                armadillo.scaredTime = 80;
            }
        }
        return flag;
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.m_213877_() && this.hiding;
    }

    protected SoundEvent m_7515_() {
        return this.hiding ? null : SoundEvents.f_11944_;
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12415_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.75f;
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12412_, 0.15f, 1.5f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.scaredTime > 0) {
            --this.scaredTime;
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.hiding && this.m_21051_(Attributes.f_22284_).m_22109_(HIDING_ARMOR_MODIFIER)) {
                this.m_21051_(Attributes.f_22284_).m_22130_(HIDING_ARMOR_MODIFIER);
            } else if (this.hiding && !this.m_21051_(Attributes.f_22284_).m_22109_(HIDING_ARMOR_MODIFIER)) {
                this.m_21051_(Attributes.f_22284_).m_22125_(HIDING_ARMOR_MODIFIER);
            }
        }
        Player player = this.m_9236_().m_45930_((Entity)this, 7.5);
        Predicate<Entity> NOT_THIS = p_33346_ -> p_33346_.m_6084_() && p_33346_ != this;
        if (!this.m_9236_().f_46443_) {
            if (this.hiding && this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82386_(0.0, (double)this.m_20206_(), 0.0).m_82400_(0.01), NOT_THIS).size() > 0) {
                this.scaredTime = 20;
            }
            if (player != this.nearestPlayer) {
                if (player != null && player.m_6087_() && this.m_142582_((Entity)player) && !player.m_150110_().f_35937_) {
                    this.nearestPlayer = player;
                    this.nearestPlayerLastX = this.nearestPlayer.m_20185_();
                    this.nearestPlayerLastY = this.nearestPlayer.m_20186_();
                    this.nearestPlayerLastZ = this.nearestPlayer.m_20189_();
                } else {
                    this.nearestPlayer = null;
                    this.nearestPlayerLastX = 0.0;
                    this.nearestPlayerLastY = 0.0;
                    this.nearestPlayerLastZ = 0.0;
                }
            }
            if (this.nearestPlayer != null) {
                if (!this.nearestPlayer.m_6047_() && this.nearestPlayerLastX != 0.0 && (double)Mth.m_14154_((float)((float)(this.nearestPlayer.m_20185_() - this.nearestPlayerLastX))) > 0.1 || (double)this.nearestPlayer.f_19789_ > 0.6 || !this.nearestPlayer.m_6047_() && this.nearestPlayerLastZ != 0.0 && (double)Mth.m_14154_((float)((float)(this.nearestPlayer.m_20189_() - this.nearestPlayerLastZ))) > 0.1 || Mth.m_14154_((float)(this.nearestPlayer.f_20885_ - this.nearestPlayer.f_20886_)) > 15.0f || Mth.m_14154_((float)(this.nearestPlayer.m_146909_() - this.nearestPlayer.f_19860_)) > 15.0f) {
                    this.scaredTime = 40;
                }
                this.nearestPlayerLastX = this.nearestPlayer.m_20185_();
                this.nearestPlayerLastY = this.nearestPlayer.m_20186_();
                this.nearestPlayerLastZ = this.nearestPlayer.m_20189_();
            }
        }
        if (this.f_19797_ % 10 == 0) {
            for (Mob entity : this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(5.0))) {
                if (!this.m_142582_((Entity)entity) || !entity.m_6084_() || entity instanceof Armadillo) continue;
                if (entity instanceof Enemy) {
                    this.scaredTime = 60;
                }
                if (entity instanceof Enemy || this.nearbyNonMonsters.contains(entity)) continue;
                this.scaredTime = 60;
                this.nearbyNonMonsters.add(entity);
            }
            ArrayList entitiesToRemoveFromNearbyNonMonsters = Lists.newArrayList();
            for (Mob entity : this.nearbyNonMonsters) {
                if (!(this.m_20270_((Entity)entity) > 10.0f)) continue;
                entitiesToRemoveFromNearbyNonMonsters.add(entity);
            }
            for (Mob entity : entitiesToRemoveFromNearbyNonMonsters) {
                if (!this.nearbyNonMonsters.contains(entity)) continue;
                this.nearbyNonMonsters.remove(entity);
            }
        }
        if (this.openAnimationTick == this.openAnimationLength - 13) {
            this.m_5496_(SoundEvents.f_12416_, this.m_6121_(), this.m_6100_() * 1.25f);
        }
        if (this.hideAnimationTick == this.hideAnimationLength - 4) {
            this.m_5496_(SoundEvents.f_12412_, this.m_6121_(), this.m_6100_() * 1.25f);
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)ItemInit.ARMADILLO_SCUTE.get(), 1);
        }
    }

    public void tickDownAnimTimers() {
        if (this.hideAnimationTick > 0) {
            --this.hideAnimationTick;
        }
        if (this.m_9236_().f_46443_ && this.hideAnimationTick <= 0) {
            this.hideAnimationState.m_216973_();
        }
        if (this.openAnimationTick > 0) {
            --this.openAnimationTick;
            if (this.openAnimationTick < 5) {
                this.hiding = false;
            }
        }
        if (this.m_9236_().f_46443_ && this.openAnimationTick <= 0) {
            this.openAnimationState.m_216973_();
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.hiding = true;
            this.hideAnimationTick = this.hideAnimationLength;
            this.hideAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.openAnimationTick = this.openAnimationLength;
            this.openAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public InteractionResult m_6071_(Player p_27584_, InteractionHand p_27585_) {
        return this.hiding && !p_27584_.m_150110_().f_35937_ ? InteractionResult.FAIL : super.m_6071_(p_27584_, p_27585_);
    }

    public boolean m_6898_(ItemStack p_29446_) {
        return p_29446_.m_150930_(Items.f_42521_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_148993_, AgeableMob p_148994_) {
        return (AgeableMob)((EntityType)EntityTypeInit.ARMADILLO.get()).m_20615_((Level)p_148993_);
    }

    class HideGoal
    extends Goal {
        public Armadillo mob;

        public HideGoal(Armadillo mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return (this.mob.scaredTime > 0 || this.mob.hiding) && !this.mob.m_20072_() && this.mob.openAnimationTick <= 0;
        }

        public boolean m_8045_() {
            return this.mob.hiding;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.hiding = true;
            this.mob.hideAnimationTick = this.mob.hideAnimationLength;
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
            this.mob.m_5496_(SoundEvents.f_11949_, this.mob.m_6121_(), this.mob.m_6100_() * 1.25f);
        }

        public void m_8037_() {
            super.m_8037_();
            this.mob.m_21573_().m_26573_();
            if ((this.mob.scaredTime <= 0 || this.mob.m_20072_()) && this.mob.openAnimationTick <= 0) {
                this.mob.openAnimationTick = this.mob.openAnimationLength;
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)5);
                this.mob.m_5496_(SoundEvents.f_12416_, this.mob.m_6121_(), this.mob.m_6100_() * 1.25f);
            }
        }
    }
}

