/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.piston;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.api.ICollateralMover;
import org.violetmoon.zeta.api.IConditionalSticky;
import org.violetmoon.zeta.api.IIndirectConnector;
import org.violetmoon.zeta.block.ext.IZetaBlockExtensions;
import org.violetmoon.zeta.mixin.mixins.AccessorPistonStructureResolver;

public class ZetaPistonStructureResolver
extends PistonStructureResolver {
    private final PistonStructureResolver parent;
    private final Level world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final Direction moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public ZetaPistonStructureResolver(PistonStructureResolver parent) {
        super(((AccessorPistonStructureResolver)parent).zeta$level(), ((AccessorPistonStructureResolver)parent).zeta$pistonPos(), ((AccessorPistonStructureResolver)parent).zeta$pistonDirection(), ((AccessorPistonStructureResolver)parent).zeta$extending());
        this.parent = parent;
        this.world = ((AccessorPistonStructureResolver)parent).zeta$level();
        this.pistonPos = ((AccessorPistonStructureResolver)parent).zeta$pistonPos();
        Direction pistonFacing = ((AccessorPistonStructureResolver)parent).zeta$pistonDirection();
        if (((AccessorPistonStructureResolver)parent).zeta$extending()) {
            this.moveDirection = pistonFacing;
            this.blockToMove = this.pistonPos.m_121945_(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.m_122424_();
            this.blockToMove = this.pistonPos.m_5484_(pistonFacing, 2);
        }
    }

    public boolean m_60422_() {
        if (!GlobalSettings.isEnabled()) {
            return this.parent.m_60422_();
        }
        this.toMove.clear();
        this.toDestroy.clear();
        BlockState iblockstate = this.world.m_8055_(this.blockToMove);
        if (!PistonBaseBlock.m_60204_((BlockState)iblockstate, (Level)this.world, (BlockPos)this.blockToMove, (Direction)this.moveDirection, (boolean)false, (Direction)this.moveDirection)) {
            if (iblockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos blockpos = this.toMove.get(i);
            if (this.addBranchingBlocks(this.world, blockpos, this.isBlockBranching(this.world, blockpos)) != ICollateralMover.MoveResult.PREVENT) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, Direction face) {
        boolean doneFinding;
        BlockPos movePos;
        int max = GlobalSettings.getPushLimit();
        BlockPos target = origin;
        BlockState state = this.world.m_8055_(target);
        if (state.m_60795_() || !PistonBaseBlock.m_60204_((BlockState)state, (Level)this.world, (BlockPos)origin, (Direction)this.moveDirection, (boolean)false, (Direction)face) || origin.equals((Object)this.pistonPos) || this.toMove.contains(origin)) {
            return true;
        }
        int lineLen = 1;
        if (lineLen + this.toMove.size() > max) {
            return false;
        }
        BlockPos oldPos = origin;
        BlockState oldState = this.world.m_8055_(origin);
        boolean skippingNext = false;
        while (this.isBlockBranching(this.world, target)) {
            ICollateralMover.MoveResult res = this.getBranchResult(this.world, target);
            if (res == ICollateralMover.MoveResult.PREVENT) {
                return false;
            }
            if (res != ICollateralMover.MoveResult.MOVE) {
                skippingNext = true;
                break;
            }
            target = origin.m_5484_(this.moveDirection.m_122424_(), lineLen);
            state = this.world.m_8055_(target);
            if (state.m_60795_() || !PistonBaseBlock.m_60204_((BlockState)state, (Level)this.world, (BlockPos)target, (Direction)this.moveDirection, (boolean)false, (Direction)this.moveDirection.m_122424_()) || target.equals((Object)this.pistonPos) || this.getStickCompatibility(this.world, state, oldState, target, oldPos) != ICollateralMover.MoveResult.MOVE) break;
            oldState = state;
            oldPos = target;
            if (++lineLen + this.toMove.size() <= max) continue;
            return false;
        }
        int collisionEnd = 0;
        for (int j = lineLen - 1; j >= 0 && !this.toDestroy.contains(movePos = origin.m_5484_(this.moveDirection.m_122424_(), j)); --j) {
            this.toMove.add(movePos);
            ++collisionEnd;
        }
        if (skippingNext) {
            return true;
        }
        int offset = 1;
        do {
            BlockPos currentPos;
            int collisionStart;
            if ((collisionStart = this.toMove.indexOf(currentPos = origin.m_5484_(this.moveDirection, offset))) > -1) {
                this.reorderListAtCollision(collisionEnd, collisionStart);
                for (int i = 0; i <= collisionStart + collisionEnd; ++i) {
                    BlockPos collidingPos = this.toMove.get(i);
                    if (this.addBranchingBlocks(this.world, collidingPos, this.isBlockBranching(this.world, collidingPos)) != ICollateralMover.MoveResult.PREVENT) continue;
                    return false;
                }
                return true;
            }
            state = this.world.m_8055_(currentPos);
            if (state.m_60795_()) {
                return true;
            }
            if (!PistonBaseBlock.m_60204_((BlockState)state, (Level)this.world, (BlockPos)currentPos, (Direction)this.moveDirection, (boolean)true, (Direction)this.moveDirection) || currentPos.equals((Object)this.pistonPos)) {
                return false;
            }
            if (state.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(currentPos);
                this.toMove.remove(currentPos);
                return true;
            }
            doneFinding = false;
            if (this.isBlockBranching(this.world, currentPos)) {
                ICollateralMover.MoveResult res = this.getBranchResult(this.world, currentPos);
                if (res == ICollateralMover.MoveResult.PREVENT) {
                    return false;
                }
                if (res != ICollateralMover.MoveResult.MOVE) {
                    doneFinding = true;
                }
            }
            if (this.toMove.size() >= max) {
                return false;
            }
            this.toMove.add(currentPos);
            ++collisionEnd;
            ++offset;
        } while (!doneFinding);
        return true;
    }

    private void reorderListAtCollision(int collisionEnd, int collisionStart) {
        ArrayList before = Lists.newArrayList(this.toMove.subList(0, collisionStart));
        ArrayList collision = Lists.newArrayList(this.toMove.subList(this.toMove.size() - collisionEnd, this.toMove.size()));
        ArrayList after = Lists.newArrayList(this.toMove.subList(collisionStart, this.toMove.size() - collisionEnd));
        this.toMove.clear();
        this.toMove.addAll(before);
        this.toMove.addAll(collision);
        this.toMove.addAll(after);
    }

    private ICollateralMover.MoveResult addBranchingBlocks(Level world, BlockPos fromPos, boolean isSourceBranching) {
        BlockState state = world.m_8055_(fromPos);
        Block block = state.m_60734_();
        Direction opposite = this.moveDirection.m_122424_();
        ICollateralMover.MoveResult retResult = ICollateralMover.MoveResult.SKIP;
        for (Direction face : Direction.values()) {
            ICollateralMover.MoveResult res;
            BlockPos targetPos = fromPos.m_121945_(face);
            BlockState targetState = world.m_8055_(targetPos);
            if (!isSourceBranching) {
                IIndirectConnector indirect = ZetaPistonStructureResolver.getIndirectStickiness(targetState);
                res = indirect != null && indirect.isEnabled() && indirect.canConnectIndirectly(world, targetPos, fromPos, targetState, state) ? this.getStickCompatibility(world, state, targetState, fromPos, targetPos) : ICollateralMover.MoveResult.SKIP;
            } else if (block instanceof ICollateralMover) {
                ICollateralMover collateralMover = (ICollateralMover)block;
                res = collateralMover.getCollateralMovement(world, this.pistonPos, this.moveDirection, face, fromPos);
            } else {
                res = this.getStickCompatibility(world, state, targetState, fromPos, targetPos);
            }
            switch (res) {
                case PREVENT: {
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case MOVE: {
                    if (this.addBlockLine(targetPos, face)) break;
                    return ICollateralMover.MoveResult.PREVENT;
                }
                case BREAK: {
                    if (PistonBaseBlock.m_60204_((BlockState)targetState, (Level)world, (BlockPos)targetPos, (Direction)this.moveDirection, (boolean)true, (Direction)this.moveDirection)) {
                        this.toDestroy.add(targetPos);
                        this.toMove.remove(targetPos);
                        return ICollateralMover.MoveResult.BREAK;
                    }
                    return ICollateralMover.MoveResult.PREVENT;
                }
            }
            if (face != opposite) continue;
            retResult = res;
        }
        return retResult;
    }

    private boolean isBlockBranching(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        return block instanceof ICollateralMover ? ((ICollateralMover)block).isCollateralMover(world, this.pistonPos, this.moveDirection, pos) : ZetaPistonStructureResolver.isBlockSticky(state);
    }

    private ICollateralMover.MoveResult getBranchResult(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ICollateralMover) {
            ICollateralMover collateralMover = (ICollateralMover)block;
            return collateralMover.getCollateralMovement(world, this.pistonPos, this.moveDirection, this.moveDirection, pos);
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    private ICollateralMover.MoveResult getStickCompatibility(Level world, BlockState state1, BlockState state2, BlockPos pos1, BlockPos pos2) {
        IConditionalSticky stick = this.getStickCondition(state1);
        if (stick != null && !stick.canStickToBlock(world, this.pistonPos, pos1, pos2, state1, state2, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        stick = this.getStickCondition(state2);
        if (stick != null && !stick.canStickToBlock(world, this.pistonPos, pos2, pos1, state2, state1, this.moveDirection)) {
            return ICollateralMover.MoveResult.SKIP;
        }
        return ICollateralMover.MoveResult.MOVE;
    }

    private IConditionalSticky getStickCondition(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IConditionalSticky) {
            IConditionalSticky sticky = (IConditionalSticky)block;
            return sticky;
        }
        IIndirectConnector indirect = ZetaPistonStructureResolver.getIndirectStickiness(state);
        if (indirect != null) {
            return indirect.isEnabled() ? indirect.getStickyCondition() : null;
        }
        if (state.isStickyBlock()) {
            return DefaultStickCondition.INSTANCE;
        }
        return null;
    }

    @NotNull
    public List<BlockPos> m_60436_() {
        if (!GlobalSettings.isEnabled()) {
            return this.parent.m_60436_();
        }
        return this.toMove;
    }

    @NotNull
    public List<BlockPos> m_60437_() {
        if (!GlobalSettings.isEnabled()) {
            return this.parent.m_60437_();
        }
        return this.toDestroy;
    }

    private static IIndirectConnector getIndirectStickiness(BlockState state) {
        for (Pair<Predicate<BlockState>, IIndirectConnector> p : IIndirectConnector.INDIRECT_STICKY_BLOCKS) {
            if (!((Predicate)p.getLeft()).test(state)) continue;
            return (IIndirectConnector)p.getRight();
        }
        return null;
    }

    private static boolean isBlockSticky(BlockState state) {
        if (state.isStickyBlock()) {
            return true;
        }
        IIndirectConnector indirect = ZetaPistonStructureResolver.getIndirectStickiness(state);
        return indirect != null && indirect.isEnabled();
    }

    public static class GlobalSettings {
        private static boolean enabled = false;
        private static int pushLimit = 12;
        private static final Set<String> wantsEnabled = new HashSet<String>();
        private static final Object2IntMap<String> wantsPushLimit = new Object2IntOpenHashMap();

        public static boolean isEnabled() {
            return enabled;
        }

        public static int getPushLimit() {
            return pushLimit;
        }

        public static void requestEnabled(String modid, boolean enablePlease) {
            boolean wasEnabled = enabled;
            if (enablePlease) {
                wantsEnabled.add(modid);
            } else {
                wantsEnabled.remove(modid);
            }
            boolean bl = enabled = !wantsEnabled.isEmpty();
            if (!wasEnabled && enabled) {
                Zeta.GLOBAL_LOG.info("'{}' is enabling Zeta's piston structure resolver.", (Object)modid);
            } else if (wasEnabled && !enabled) {
                Zeta.GLOBAL_LOG.info("Zeta's piston structure resolver is now disabled.");
            }
        }

        public static void requestPushLimit(String modid, int pushLimitPlease) {
            int wasPushLimit = pushLimit;
            wantsPushLimit.put((Object)modid, pushLimitPlease);
            pushLimit = wantsPushLimit.values().intStream().max().orElse(12);
            if (wasPushLimit < pushLimit) {
                Zeta.GLOBAL_LOG.info("'{}' is raising Zeta's piston structure resolver push limit to {} blocks.", (Object)modid, (Object)pushLimit);
            }
        }
    }

    private static class DefaultStickCondition
    implements IConditionalSticky {
        private static final DefaultStickCondition INSTANCE = new DefaultStickCondition();

        private DefaultStickCondition() {
        }

        @Override
        public boolean canStickToBlock(Level world, BlockPos pistonPos, BlockPos pos, BlockPos slimePos, BlockState state, BlockState slimeState, Direction direction) {
            Block block = slimeState.m_60734_();
            if (block instanceof IZetaBlockExtensions) {
                IZetaBlockExtensions ext = (IZetaBlockExtensions)block;
                return ext.canStickToZeta(slimeState, state);
            }
            block = state.m_60734_();
            if (block instanceof IZetaBlockExtensions) {
                IZetaBlockExtensions ext = (IZetaBlockExtensions)block;
                return ext.canStickToZeta(state, slimeState);
            }
            return IZetaBlockExtensions.DEFAULT.canStickToZeta(slimeState, state);
        }
    }
}

