/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import plus.dragons.createcentralkitchen.foundation.data.recipe.builder.ConditionedRecipeBuilder;

public class ConditionedShapelessRecipeBuilder
implements RecipeBuilder,
ConditionedRecipeBuilder<ConditionedShapelessRecipeBuilder> {
    private final ResourceLocation id;
    private Item result;
    private int count = 1;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public ConditionedShapelessRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ConditionedShapelessRecipeBuilder require(TagKey<Item> tag) {
        return this.require(Ingredient.m_204132_(tag));
    }

    public ConditionedShapelessRecipeBuilder require(ItemLike item) {
        return this.require(item, 1);
    }

    public ConditionedShapelessRecipeBuilder require(ItemLike item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public ConditionedShapelessRecipeBuilder require(Ingredient ingredient) {
        return this.require(ingredient, 1);
    }

    public ConditionedShapelessRecipeBuilder require(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ConditionedShapelessRecipeBuilder requiredToUnlock(RegistrateRecipeProvider prov, DataIngredient ingredient) {
        this.unlockedBy("has_" + prov.safeName(ingredient), (CriterionTriggerInstance)ingredient.getCritereon(prov));
        return this.require((Ingredient)ingredient, 1);
    }

    public ConditionedShapelessRecipeBuilder requiredToUnlock(RegistrateRecipeProvider prov, DataIngredient ingredient, int quantity) {
        this.unlockedBy("has_" + prov.safeName(ingredient), (CriterionTriggerInstance)ingredient.getCritereon(prov));
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Ingredient)ingredient);
        }
        return this;
    }

    public ConditionedShapelessRecipeBuilder output(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
        return this;
    }

    public ConditionedShapelessRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    @Override
    public ConditionedShapelessRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public ConditionedShapelessRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public ConditionedShapelessRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    @Override
    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, this.id);
    }

    @Override
    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "crafting/" + id.m_135815_());
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_()), this.conditions));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.result == null) {
            throw new IllegalStateException("No result is defined for shapeless recipe " + id + "!");
        }
    }

    public static class Result
    extends ShapelessRecipeBuilder.Result {
        private final boolean serializeAdvancement;
        private final List<ICondition> conditions;

        public Result(ResourceLocation id, Item result, int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId, List<ICondition> conditions) {
            super(id, result, count, group, CraftingBookCategory.MISC, ingredients, advancement, advancementId);
            this.serializeAdvancement = !advancement.m_138405_().isEmpty() && conditions.isEmpty();
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (!this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)conds);
            }
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.serializeAdvancement ? super.m_5860_() : null;
        }
    }
}

