/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Attack", description="More damage and attack speed based off Elder Guardians Defeated")
@LoadFeature(module="progressivebosses:elder_guardian")
public class AttackFeature
extends Feature {
    @Config(min=0.0, max=128.0)
    @Label(name="Bonus Damage per Elder Guardian Defeated", description="Percentage Bonus damage per defeated Elder Guardian.")
    public static Double bonusDamage = 0.0;
    @Config(min=0.0, max=60.0)
    @Label(name="Attack Duration Reduction per Elder Guardian Defeated", description="How many ticks faster will Elder Guardian attack (multiplied by defeated Elder Guardians). Vanilla Attack Duration is 60 ticks (3 secs)")
    public static Integer attackDurationReduction = 25;
    private static final int BASE_ATTACK_DURATION = 60;

    public AttackFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || bonusDamage == 0.0 || !((entity = event.getSource().m_7639_()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        float bonusDmg = (float)(bonusDamage * (double)elderGuardian.getPersistentData().m_128451_("progressivebosses:difficulty"));
        event.setAmount(event.getAmount() * (1.0f + bonusDmg));
    }

    public static boolean shouldChangeAttackDuration(ElderGuardian elderGuardian) {
        int elderGuardiansNearby = elderGuardian.m_9236_().m_6249_((Entity)elderGuardian, elderGuardian.m_20191_().m_82400_(48.0), entity -> entity instanceof ElderGuardian).size();
        return AttackFeature.isEnabled(AttackFeature.class) && attackDurationReduction > 0 && elderGuardiansNearby < 2;
    }

    public static int getAttackDuration(ElderGuardian elderGuardian) {
        int elderGuardiansNearby = elderGuardian.m_9236_().m_6249_((Entity)elderGuardian, elderGuardian.m_20191_().m_82400_(48.0), entity -> entity instanceof ElderGuardian).size();
        return 60 - (2 - elderGuardiansNearby) * attackDurationReduction;
    }
}

