/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.models.entities;

import com.alexander.whatareyouvotingfor.animation.keyframe_animations.definition.ArmadilloKeyframeAnimations;
import com.alexander.whatareyouvotingfor.animation.sine_wave_animations.SineWaveAnimationUtils;
import com.alexander.whatareyouvotingfor.animation.sine_wave_animations.definition.ArmadilloSineWaveAnimations;
import com.alexander.whatareyouvotingfor.entities.Armadillo;
import com.alexander.whatareyouvotingfor.util.MiscUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ArmadilloModel<T extends Armadillo>
extends HierarchicalModel<T> {
    public final ModelPart root;
    public final ModelPart everything;
    public final ModelPart body;
    public final ModelPart shell;
    public final ModelPart back;
    public final ModelPart front;
    public final ModelPart middle;
    public final ModelPart closed;
    public final ModelPart main;
    public final ModelPart head;
    public final ModelPart leftEar;
    public final ModelPart rightEar;
    public final ModelPart tail;
    public final ModelPart rightLegBack;
    public final ModelPart rightLegFront;
    public final ModelPart leftLegBack;
    public final ModelPart leftLegFront;

    public ArmadilloModel(ModelPart root) {
        this.root = root;
        this.everything = root.m_171324_("everything");
        this.body = this.everything.m_171324_("body");
        this.shell = this.body.m_171324_("shell");
        this.back = this.shell.m_171324_("back");
        this.front = this.shell.m_171324_("front");
        this.middle = this.shell.m_171324_("middle");
        this.closed = this.middle.m_171324_("closed");
        this.main = this.body.m_171324_("main");
        this.head = this.body.m_171324_("head");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightEar = this.head.m_171324_("rightEar");
        this.tail = this.body.m_171324_("tail");
        this.rightLegBack = this.everything.m_171324_("rightLegBack");
        this.rightLegFront = this.everything.m_171324_("rightLegFront");
        this.leftLegBack = this.everything.m_171324_("leftLegBack");
        this.leftLegFront = this.everything.m_171324_("leftLegFront");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition everything = partdefinition.m_171599_("everything", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition body = everything.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition shell = body.m_171599_("shell", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition back = shell.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-6.0f, -5.9f, 0.0f, 12.0f, 12.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)3.5f));
        PartDefinition front = shell.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-6.0f, -5.9f, -6.0f, 12.0f, 12.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-3.5f));
        PartDefinition middle = shell.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(78, 39).m_171488_(-6.0f, -14.9f, -6.5f, 12.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition closed = middle.m_171599_("closed", CubeListBuilder.m_171558_().m_171514_(28, 39).m_171488_(-6.0f, -14.9f, -6.5f, 12.0f, 12.0f, 13.0f, new CubeDeformation(0.25f)).m_171514_(78, 15).m_171488_(-6.0f, -13.9f, -6.5f, 12.0f, 11.0f, 13.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition main = body.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-5.0f, -11.0f, -8.5f, 10.0f, 11.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, -7.0f, 3.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-9.0f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-2.0f, -5.0f, 0.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)-0.5f, (float)-2.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -5.0f, 0.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-0.5f, (float)-2.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)8.5f));
        PartDefinition rightLegBack = everything.m_171599_("rightLegBack", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171480_().m_171488_(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)5.5f));
        PartDefinition rightLegFront = everything.m_171599_("rightLegFront", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171480_().m_171488_(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)-5.5f));
        PartDefinition leftLegBack = everything.m_171599_("leftLegBack", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)5.5f));
        PartDefinition leftLegFront = everything.m_171599_("leftLegFront", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-5.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = Math.min((float)entity.m_20184_().m_82556_() * 50.0f, 8.0f);
        if (entity.m_6162_()) {
            this.head.f_233553_ = 2.0f;
            this.head.f_233554_ = 2.0f;
            this.head.f_233555_ = 2.0f;
        }
        if (!((Armadillo)((Object)entity)).hiding) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        if (((Armadillo)((Object)entity)).hideAnimationTick > 0) {
            this.m_233381_(((Armadillo)((Object)entity)).hideAnimationState, ArmadilloKeyframeAnimations.ARMADILLO_HIDE, ageInTicks);
        } else if (((Armadillo)((Object)entity)).openAnimationTick > 0) {
            this.m_233381_(((Armadillo)((Object)entity)).openAnimationState, ArmadilloKeyframeAnimations.ARMADILLO_OPEN, ageInTicks);
        } else if (((Armadillo)((Object)entity)).hiding) {
            ArmadilloSineWaveAnimations.armadilloShellIdleAnimation(this, SineWaveAnimationUtils.getTick(((Armadillo)((Object)entity)).f_19797_, true), 1.0f, 1.0f);
        } else if (MiscUtils.isMovingOnLand(entity)) {
            ArmadilloSineWaveAnimations.armadilloWalkAnimation(this, SineWaveAnimationUtils.getTick(((Armadillo)((Object)entity)).f_19797_, true), f, 1.0f);
        } else {
            ArmadilloSineWaveAnimations.armadilloIdleAnimation(this, SineWaveAnimationUtils.getTick(((Armadillo)((Object)entity)).f_19797_, true), 1.0f, 1.0f);
        }
    }

    private void animateHeadLookTarget(float yRot, float xRot) {
        this.head.f_104203_ = xRot * ((float)Math.PI / 180);
        this.head.f_104204_ = yRot * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

