/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.surface;

import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ACSurfaceRuleConditionRegistry {
    public static final DeferredRegister<Codec<? extends SurfaceRules.ConditionSource>> DEF_REG = DeferredRegister.create((ResourceKey)Registries.f_256793_, (String)"alexscaves");
    public static final RegistryObject<Codec<? extends SurfaceRules.ConditionSource>> AC_SIMPLEX_CONDITION = DEF_REG.register("ac_simplex", () -> SimplexConditionSource.CODEC.f_216232_());

    public static SurfaceRules.ConditionSource simplexCondition(float noiseMin, float noiseMax, float noiseScale, float yScale, int offsetType) {
        return new SimplexConditionSource(noiseMin, noiseMax, noiseScale, yScale, offsetType);
    }

    private record SimplexConditionSource(float noiseMin, float noiseMax, float noiseScale, float yScale, int offsetType) implements SurfaceRules.ConditionSource
    {
        private static final KeyDispatchDataCodec<SimplexConditionSource> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(group -> group.group((App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("noise_min").forGetter(SimplexConditionSource::noiseMin), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("noise_max").forGetter(SimplexConditionSource::noiseMax), (App)Codec.floatRange((float)1.0f, (float)10000.0f).fieldOf("noise_scale").forGetter(SimplexConditionSource::noiseScale), (App)Codec.floatRange((float)0.0f, (float)10000.0f).fieldOf("y_scale").forGetter(SimplexConditionSource::yScale), (App)Codec.intRange((int)0, (int)128).fieldOf("offset_type").forGetter(SimplexConditionSource::offsetType)).apply((Applicative)group, SimplexConditionSource::new)));

        public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
            return CODEC;
        }

        public SurfaceRules.Condition apply(SurfaceRules.Context contextIn) {
            class NoiseCondition
            implements SurfaceRules.Condition {
                private SurfaceRules.Context context;

                NoiseCondition(SurfaceRules.Context context) {
                    this.context = context;
                }

                public boolean m_183475_() {
                    double f = ACMath.sampleNoise3D(this.context.f_189546_ + SimplexConditionSource.this.offsetType * 1000, (int)((float)this.context.f_189557_ * SimplexConditionSource.this.yScale + (float)(SimplexConditionSource.this.offsetType * 2000)), this.context.f_189547_ - SimplexConditionSource.this.offsetType * 3000, SimplexConditionSource.this.noiseScale);
                    return f > (double)SimplexConditionSource.this.noiseMin && f <= (double)SimplexConditionSource.this.noiseMax;
                }
            }
            return new NoiseCondition(contextIn);
        }
    }
}

