/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.map;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.level.map.FilloutCaveBiomeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;

public final class CaveBiomeFinder {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();

    public void fillOutCaveMap(UUID uuid, ItemStack map, ServerLevel serverLevel, BlockPos center, Player player) {
        EXECUTORS.execute(new FilloutCaveBiomeMap(map, serverLevel, center, player, uuid));
    }

    public static class MapThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(Runnable runnable) {
            BlockableEventLoop workqueue = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            ClassLoader classLoader = workqueue.m_18695_() ? Thread.currentThread().getContextClassLoader() : CompletableFuture.supplyAsync(() -> Thread.currentThread().getContextClassLoader(), (Executor)workqueue).join();
            Thread thread = new Thread(runnable, "Alex's Caves Worker #" + id++);
            thread.setDaemon(true);
            thread.setPriority(10);
            if (thread.getContextClassLoader() != classLoader) {
                AlexsCaves.LOGGER.info("Corrected CCL of new Alex's Caves Thread, was: " + thread.getContextClassLoader().toString());
                thread.setContextClassLoader(classLoader);
            }
            thread.setUncaughtExceptionHandler((thread1, throwable) -> AlexsCaves.LOGGER.error("Alex's Caves Thread errored! ", throwable));
            return thread;
        }
    }
}

