/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.biome;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;

public class ACBiomeRarity {
    private static long lastTestedSeed = 0L;
    private static PerlinSimplexNoise noiseX;
    private static PerlinSimplexNoise noiseZ;
    private static VoronoiGenerator voronoiGenerator;
    private static final List<Integer> BIOME_OCTAVES;

    @Nullable
    public static Vec3 getRareBiomeCenterQuad(long worldSeed, int rarityOffset, int x, int z) {
        double scaledHash;
        double positionOffsetZ;
        if (lastTestedSeed != worldSeed || voronoiGenerator == null || noiseX == null || noiseZ == null) {
            lastTestedSeed = worldSeed;
            noiseX = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(1234L + worldSeed), BIOME_OCTAVES);
            noiseZ = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(4321L + worldSeed), BIOME_OCTAVES);
            voronoiGenerator = new VoronoiGenerator(worldSeed);
            voronoiGenerator.setOffsetAmount((Double)AlexsCaves.COMMON_CONFIG.caveBiomeSpacingRandomness.get());
        }
        double biomeSize = (Double)AlexsCaves.COMMON_CONFIG.caveBiomeMeanWidth.get() * 0.25;
        double seperationDistance = biomeSize + (double)((Integer)AlexsCaves.COMMON_CONFIG.caveBiomeMeanSeparation.get()).intValue() * 0.25;
        double sampleX = (double)x / seperationDistance;
        double sampleZ = (double)z / seperationDistance;
        double positionOffsetX = (Double)AlexsCaves.COMMON_CONFIG.caveBiomeWidthRandomness.get() * noiseX.m_75449_(sampleX, sampleZ, false);
        VoronoiGenerator.VoronoiInfo info = voronoiGenerator.get2(sampleX + positionOffsetX, sampleZ + (positionOffsetZ = (Double)AlexsCaves.COMMON_CONFIG.caveBiomeWidthRandomness.get() * noiseZ.m_75449_(sampleX, sampleZ, false)));
        if (info.distance() < biomeSize / seperationDistance && (int)(scaledHash = (info.hash() + 1.0) * 0.5 * (double)BiomeGenerationConfig.getBiomeCount()) == rarityOffset) {
            return info.cellPos().m_82490_(seperationDistance);
        }
        return null;
    }

    static {
        BIOME_OCTAVES = ImmutableList.of((Object)0);
    }
}

