/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexmodguy.alexscaves.server.message.UpdateItemTagMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class TotemOfPossessionItem
extends Item
implements Vanishable,
UpdatesStackTags {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public TotemOfPossessionItem() {
        super(new Item.Properties().m_41503_(1000).m_41497_(Rarity.UNCOMMON));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TotemOfPossessionItem.updateEntityIdFromServer(serverLevel, player, itemstack);
        }
        Entity controlledEntity = this.getControlledEntity(level, itemstack);
        if (!(!TotemOfPossessionItem.isBound(itemstack) || controlledEntity != null && controlledEntity.m_6084_() || level.f_46443_)) {
            TotemOfPossessionItem.resetBound(itemstack);
        }
        if (TotemOfPossessionItem.isBound(itemstack) && controlledEntity != null && TotemOfPossessionItem.isEntityLookingAt((LivingEntity)player, controlledEntity, 5.0)) {
            player.m_216990_((SoundEvent)ACSoundRegistry.TOTEM_OF_POSSESSION_USE.get());
            player.m_6672_(interactionHand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int i1) {
        if (level.f_46443_) {
            AlexsCaves.sendMSGToServer(new UpdateItemTagMessage(user.m_19879_(), stack));
        }
        if (stack.m_41773_() >= stack.m_41776_()) {
            stack.m_41774_(1);
        }
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int timeUsing) {
        block17: {
            Entity controlledEntity;
            block16: {
                int realStart;
                int i;
                Player player;
                controlledEntity = this.getControlledEntity(level, stack);
                if (TotemOfPossessionItem.isBound(stack) && (controlledEntity == null || !controlledEntity.m_6084_()) || stack.m_41773_() >= stack.m_41776_()) {
                    TotemOfPossessionItem.resetBound(stack);
                    user.m_5810_();
                    if (level.f_46443_) {
                        AlexsCaves.sendMSGToServer(new UpdateItemTagMessage(user.m_19879_(), stack));
                    }
                    return;
                }
                if (!TotemOfPossessionItem.isBound(stack) || controlledEntity == null || !TotemOfPossessionItem.isEntityLookingAt(user, controlledEntity, 5.0) || controlledEntity instanceof Player && !((Boolean)AlexsCaves.COMMON_CONFIG.totemOfPossessionPlayers.get()).booleanValue()) {
                    user.m_5810_();
                    if (level.f_46443_) {
                        AlexsCaves.sendMSGToServer(new UpdateItemTagMessage(user.m_19879_(), stack));
                    }
                    return;
                }
                if (!(timeUsing % 2 != 0 || !level.f_46443_ || user instanceof Player && (player = (Player)user).m_7500_())) {
                    stack.m_41721_(stack.m_41773_() + 1);
                }
                float time = (i = this.m_8105_(stack) - timeUsing) < (realStart = 15) ? (float)i / (float)realStart : 1.0f;
                float maxDist = 32.0f * time;
                HitResult hitResult = ProjectileUtil.m_278180_((Entity)user, entity -> entity.m_271807_() && !entity.equals((Object)controlledEntity), (double)maxDist);
                Vec3 vec3 = hitResult.m_82450_();
                if (controlledEntity instanceof Mob) {
                    Mob mob = (Mob)controlledEntity;
                    PathNavigation pathNavigation = mob.m_21573_();
                    pathNavigation.m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)time * 2.0);
                } else {
                    boolean flying = controlledEntity instanceof FlyingAnimal || controlledEntity instanceof FlyingMob;
                    Vec3 vec31 = vec3.m_82546_(controlledEntity.m_20182_());
                    boolean jumpFlag = false;
                    if (!flying && controlledEntity.f_19862_ && controlledEntity.m_20096_() && vec31.f_82480_ > 0.0) {
                        jumpFlag = true;
                    } else if (!flying && vec31.f_82480_ > 0.0) {
                        vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
                    }
                    float yaw = -((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f;
                    if (vec31.m_82553_() > 1.0) {
                        vec31 = vec31.m_82541_();
                        if (!level.f_46443_) {
                            controlledEntity.m_146922_(yaw);
                            controlledEntity.m_5618_(controlledEntity.m_146908_());
                        }
                    }
                    Vec3 jumpAdd = vec31.m_82490_(0.25);
                    if (jumpFlag) {
                        jumpAdd = jumpAdd.m_82520_(0.0, 0.6, 0.0);
                    }
                    controlledEntity.m_20256_(controlledEntity.m_20184_().m_82490_((double)0.8f).m_82549_(jumpAdd));
                }
                if (!level.f_46443_) break block16;
                int particles = 0;
                while ((float)particles < 1.0f + controlledEntity.m_20205_() * 2.0f) {
                    level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, controlledEntity.m_20208_(0.75), controlledEntity.m_20187_(), controlledEntity.m_20262_(0.75), 0.0, 0.0, 0.0);
                    ++particles;
                }
                break block17;
            }
            AABB hitBox = controlledEntity.m_20191_().m_82400_(3.0);
            if (!(controlledEntity instanceof Player) && !(controlledEntity instanceof Mob)) break block17;
            for (Entity entity2 : level.m_6249_(controlledEntity, hitBox, Entity::m_271807_)) {
                if (controlledEntity.m_7306_(entity2) || controlledEntity.m_7307_(entity2) || entity2.m_7306_((Entity)user) || entity2.m_7307_(controlledEntity) || entity2.m_20365_(controlledEntity) || !(entity2 instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)entity2;
                if (controlledEntity instanceof Mob) {
                    Mob mob = (Mob)controlledEntity;
                    mob.m_6710_(target);
                    mob.m_6703_(target);
                    continue;
                }
                if (!(controlledEntity instanceof Player)) continue;
                Player player = (Player)controlledEntity;
                player.m_5706_((Entity)target);
                player.m_36334_();
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }

    private static void resetBound(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128473_("BoundEntityTag");
        tag.m_128473_("BoundEntityUUID");
        tag.m_128473_("ControllingEntityID");
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Optional optional;
        Tag entity;
        if (stack.m_41783_() != null && (entity = stack.m_41783_().m_128423_("BoundEntityTag")) instanceof CompoundTag && (optional = EntityType.m_20637_((CompoundTag)((CompoundTag)entity))).isPresent()) {
            MutableComponent untranslated = ((EntityType)optional.get()).m_20676_().m_6881_().m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)untranslated);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    private static UUID getBoundEntityUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128441_("BoundEntityUUID") ? tag.m_128342_("BoundEntityUUID") : null;
        }
        return null;
    }

    private static void updateEntityIdFromServer(ServerLevel level, Player player, ItemStack itemStack) {
        UUID uuid = TotemOfPossessionItem.getBoundEntityUUID(itemStack);
        CompoundTag tag = itemStack.m_41784_();
        int prev = !tag.m_128441_("ControllingEntityID") ? -1 : tag.m_128451_("ControllingEntityID");
        int set = -1;
        if (uuid != null) {
            Entity entity = level.m_8791_(uuid);
            set = entity == null ? -1 : entity.m_19879_();
        }
        tag.m_128405_("ControllingEntityID", set);
        if (prev != set) {
            AlexsCaves.sendMSGToAll(new UpdateItemTagMessage(player.m_19879_(), itemStack));
        }
    }

    private Entity getControlledEntity(Level level, ItemStack itemStack) {
        if (level.f_46443_) {
            CompoundTag tag = itemStack.m_41784_();
            int id = tag.m_128441_("ControllingEntityID") ? tag.m_128451_("ControllingEntityID") : -1;
            return id == -1 ? null : level.m_6815_(id);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = TotemOfPossessionItem.getBoundEntityUUID(itemStack);
            return uuid == null ? null : serverLevel.m_8791_(uuid);
        }
        return null;
    }

    private static boolean isEntityLookingAt(LivingEntity looker, Entity seen, double degree) {
        Vec3 vec3 = looker.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(seen.m_20185_() - looker.m_20185_(), seen.m_20191_().f_82289_ + (double)seen.m_20192_() - (looker.m_20186_() + (double)looker.m_20192_()), seen.m_20189_() - looker.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.m_20270_(seen) * 0.1) / d0 && looker.m_142582_(seen);
    }

    public static boolean isBound(ItemStack stack) {
        return TotemOfPossessionItem.getBoundEntityUUID(stack) != null;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity hurtMob, LivingEntity livingEntity1) {
        if (hurtMob.m_6095_().m_204039_(ACTagRegistry.RESISTS_TOTEM_OF_POSSESSION) || hurtMob instanceof Player && !((Boolean)AlexsCaves.COMMON_CONFIG.totemOfPossessionPlayers.get()).booleanValue()) {
            if (livingEntity1 instanceof Player) {
                Player player = (Player)livingEntity1;
                player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.totem_of_possession.invalid"), true);
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128362_("BoundEntityUUID", hurtMob.m_20148_());
            CompoundTag entityTag = hurtMob.serializeNBT();
            entityTag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)hurtMob.m_6095_()).toString());
            tag.m_128365_("BoundEntityTag", (Tag)entityTag);
            livingEntity1.m_216990_((SoundEvent)ACSoundRegistry.TOTEM_OF_POSSESSION_USE.get());
        }
        return true;
    }
}

