/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.misc.CaveBookProgress;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class CaveInfoItem
extends Item {
    private boolean hideCaveId;

    public CaveInfoItem(Item.Properties properties, boolean hideCaveId) {
        super(properties);
        this.hideCaveId = hideCaveId;
    }

    public static int getBiomeColorOf(Level level, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128471_("Rainbow")) {
            float hue = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int rainbow = Color.HSBtoRGB(hue, 1.0f, 0.8f);
            return rainbow;
        }
        if (stack.m_41720_() instanceof CaveInfoItem) {
            ResourceKey<Biome> biomeResourceKey = CaveInfoItem.getCaveBiome(stack);
            if (biomeResourceKey == null) {
                int selectedBiomeIndex = (int)((float)((long)ACBiomeRegistry.ALEXS_CAVES_BIOMES.size() * (System.currentTimeMillis() % 4000L)) / 4000.0f);
                biomeResourceKey = ACBiomeRegistry.ALEXS_CAVES_BIOMES.get(selectedBiomeIndex);
            }
            return biomeResourceKey == null ? -1 : CaveInfoItem.getBiomeColor(level, biomeResourceKey);
        }
        return -1;
    }

    private static int getBiomeColor(Level level, ResourceKey<Biome> biomeResourceKey) {
        int color = ACBiomeRegistry.getBiomeTabletColor(biomeResourceKey);
        if (color == -1) {
            Registry registry;
            if (level != null && (registry = (Registry)level.m_9598_().m_6632_(Registries.f_256952_).orElse(null)) != null && registry.m_203636_(biomeResourceKey).isPresent()) {
                return ((Biome)((Holder.Reference)registry.m_203636_(biomeResourceKey).get()).m_203334_()).m_47542_();
            }
            return 0;
        }
        return color;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        ResourceKey<Biome> biomeResourceKey = CaveInfoItem.getCaveBiome(itemstack);
        if (itemstack.m_150930_((Item)ACItemRegistry.CAVE_CODEX.get()) && biomeResourceKey != null) {
            String biomeStr = biomeResourceKey.m_135782_().toString();
            CaveBookProgress progress = CaveBookProgress.getCaveBookProgress(player);
            if (progress.unlockNextFor(biomeStr)) {
                player.m_6674_(hand);
                if (!level.f_46443_) {
                    CaveBookProgress.saveCaveBookProgress(progress, player);
                    CaveBookProgress.Subcategory subcategory = progress.getLastUnlockedCategory(biomeStr);
                    MutableComponent biomeTitle = Component.m_237115_((String)("biome." + biomeResourceKey.m_135782_().toString().replace(":", ".")));
                    if (((Boolean)AlexsCaves.COMMON_CONFIG.onlyOneResearchNeeded.get()).booleanValue()) {
                        player.m_5661_((Component)Component.m_237110_((String)"item.alexscaves.cave_codex.add_all", (Object[])new Object[]{biomeTitle}), true);
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)"item.alexscaves.cave_codex.add", (Object[])new Object[]{biomeTitle, Component.m_237115_((String)("item.alexscaves.cave_book." + subcategory.toString().toLowerCase()))}), true);
                    }
                }
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                player.m_216990_(SoundEvents.f_11871_);
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.cave_codex.end").m_130940_(ChatFormatting.RED), true);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static ItemStack create(Item item, ResourceKey<Biome> biomeResourceKey) {
        ItemStack map = new ItemStack((ItemLike)item);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("CaveBiome", biomeResourceKey.m_135782_().toString());
        map.m_41751_(tag);
        return map;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceKey<Biome> biomeResourceKey = CaveInfoItem.getCaveBiome(stack);
        if (biomeResourceKey != null && !this.hideCaveId) {
            String biomeName = "biome." + biomeResourceKey.m_135782_().toString().replace(":", ".");
            tooltip.add((Component)Component.m_237115_((String)biomeName).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static ResourceKey<Biome> getCaveBiome(ItemStack stack) {
        if (stack.m_41783_() != null) {
            String s = stack.m_41783_().m_128461_("CaveBiome");
            return s == null ? null : ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(s));
        }
        return null;
    }
}

