/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MultipleDinosaurEggsBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalJoinPackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.SubterranodonFleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.SubterranodonFlightGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.SubterranodonFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FlyingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.PackAnimal;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SubterranodonEntity
extends DinosaurEntity
implements PackAnimal,
FlyingAnimal,
KeybindUsingMount,
FlyingMount {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(SubterranodonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.m_135353_(SubterranodonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> METER_AMOUNT = SynchedEntityData.m_135353_(SubterranodonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SubterranodonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float flyProgress;
    private float prevFlyProgress;
    private float flapAmount;
    private float prevFlapAmount;
    private float hoverProgress;
    private float prevHoverProgress;
    private float flightPitch = 0.0f;
    private float prevFlightPitch = 0.0f;
    private float flightRoll = 0.0f;
    private float prevFlightRoll = 0.0f;
    private float tailYaw;
    private float prevTailYaw;
    private boolean isLandNavigator;
    private SubterranodonEntity priorPackMember;
    private SubterranodonEntity afterPackMember;
    public int timeFlying;
    public Vec3 lastFlightTargetPos;
    public boolean resetFlightAIFlag = false;
    public boolean landingFlag;
    public boolean slowRidden;
    private int controlUpTicks = 0;
    private int controlDownTicks = 0;
    private AABB flightCollisionBox;
    private int timeVehicle;
    public float prevAttackProgress;
    public float attackProgress;
    private double lastStepX = 0.0;
    private double lastStepZ = 0.0;

    public SubterranodonEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.switchNavigator(true);
        this.tailYaw = this.f_20883_;
        this.prevTailYaw = this.f_20883_;
    }

    public static boolean checkSubterranodonSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        BlockState below = levelAccessor.m_8055_(pos.m_7495_());
        return (below.m_204336_(ACTagRegistry.DINOSAURS_SPAWNABLE_ON) || below.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get()) || below.m_204336_(BlockTags.f_13035_)) && levelAccessor.m_6425_(pos).m_76178_() && levelAccessor.m_6425_(pos.m_7495_()).m_76178_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(3, (Goal)new SubterranodonFollowOwnerGoal(this, 1.2, 5.0f, 2.0f, true));
        this.f_21345_.m_25352_(4, (Goal)new AnimalJoinPackGoal((LivingEntity)this, 30, 5));
        this.f_21345_.m_25352_(5, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42530_, (ItemLike)ACItemRegistry.COOKED_TRILOCARIS_TAIL.get(), (ItemLike)ACItemRegistry.TRILOCARIS_TAIL.get()}), false));
        this.f_21345_.m_25352_(7, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new SubterranodonFleeGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new SubterranodonFlightGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFlying(compound.m_128471_("Flying"));
        this.timeFlying = compound.m_128451_("TimeFlying");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Flying", this.m_29443_());
        compound.m_128405_("TimeFlying", this.timeFlying);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(HOVERING, (Object)false);
        this.f_19804_.m_135372_(METER_AMOUNT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new FlightMoveHelper(this);
            this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        float yMov;
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.prevHoverProgress = this.hoverProgress;
        this.prevAttackProgress = this.attackProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevFlightPitch = this.flightPitch;
        this.prevFlightRoll = this.flightRoll;
        this.prevTailYaw = this.tailYaw;
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isHovering() && this.hoverProgress < 5.0f) {
            this.hoverProgress += 1.0f;
        }
        if (!this.isHovering() && this.hoverProgress > 0.0f) {
            this.hoverProgress -= 1.0f;
        }
        if (this.f_19797_ % 100 == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if ((yMov = (float)this.m_20184_().f_82480_) > 0.0f || this.isHovering()) {
            if (this.flapAmount < 5.0f) {
                this.flapAmount += 1.0f;
            }
        } else if (yMov <= 0.05f && this.flapAmount > 0.0f) {
            this.flapAmount -= 0.5f;
        }
        if (this.m_29443_()) {
            if (this.timeFlying % 10 == 0 && (this.flapAmount > 0.0f || this.controlUpTicks > 0)) {
                this.m_216990_((SoundEvent)ACSoundRegistry.SUBTERRANODON_FLAP.get());
            }
            ++this.timeFlying;
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (this.m_20184_().f_82480_ < 0.0 && this.m_6084_()) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            }
            if (this.isDancing() || this.m_20159_()) {
                this.setHovering(false);
                this.setFlying(false);
            }
            if (!this.m_9236_().f_46443_ && this.m_20096_() && (target = this.m_5448_()) != null && target.m_6084_()) {
                this.setHovering(false);
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (this.m_20160_() && !this.m_6162_()) {
            this.setFlying(true);
            LivingEntity rider = this.m_6688_();
            if (rider != null) {
                this.flightCollisionBox = this.m_20191_().m_82363_(0.0, (double)(-0.5f - rider.m_20206_()), 0.0);
                if (this.isRiderInWall()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setHovering(this.isHoveringFromServer() && this.m_29443_());
            if (this.isHovering() && this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
                if (this.timeFlying < 30) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.075, 0.0));
                }
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.3, 0.0));
                }
            }
            if (!this.isHovering() && this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        } else {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            Player player = AlexsCaves.PROXY.getClientSidePlayer();
            if (player != null && player.m_20365_((Entity)this)) {
                if (AlexsCaves.PROXY.isKeyDown(0) && !AlexsCaves.PROXY.isKeyDown(1) && this.controlUpTicks < 2 && this.getMeterAmount() > 0.1f && this.getMeterAmount() > 0.1f) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 0));
                    this.controlUpTicks = 5;
                }
                if (AlexsCaves.PROXY.isKeyDown(1) && !AlexsCaves.PROXY.isKeyDown(0) && this.controlDownTicks < 2) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 1));
                    this.controlDownTicks = 5;
                }
            }
        }
        if (this.controlDownTicks > 0) {
            --this.controlDownTicks;
        } else if (this.controlUpTicks > 0) {
            --this.controlUpTicks;
        }
        this.timeVehicle = this.m_20160_() ? ++this.timeVehicle : 0;
        if (this.getMeterAmount() < 1.0f && this.controlUpTicks == 0) {
            this.setMeterAmount(this.getMeterAmount() + (this.slowRidden ? 0.002f : 0.001f));
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else {
            target = this.m_5448_();
            if (this.attackProgress == 5.0f && target != null && (double)this.m_20270_((Entity)target) < 3.0 + (double)target.m_20205_() && this.m_142582_((Entity)target)) {
                target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                this.m_216990_((SoundEvent)ACSoundRegistry.SUBTERRANODON_ATTACK.get());
            }
            if (this.attackProgress > 0.0f) {
                this.attackProgress -= 1.0f;
            }
        }
        this.tickRotation(Mth.m_14036_((float)yMov, (float)-1.0f, (float)1.0f) * -57.295776f);
        this.lastStepX = this.f_19854_;
        this.lastStepZ = this.f_19856_;
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected Vec3 m_274312_(Player player, Vec3 deltaIn) {
        float f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        return new Vec3((double)(player.f_20900_ * 0.25f), this.controlUpTicks > 0 ? 1.0 : (this.controlDownTicks > 0 ? -1.0 : 0.0), (double)(player.f_20902_ * 0.5f * f));
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        boolean bl = this.slowRidden = player.f_20902_ < 0.3f || this.timeVehicle < 10 || this.m_20096_();
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) {
            this.m_19915_(player.m_146908_(), player.m_146909_() * 0.25f);
            this.m_6710_(null);
        }
    }

    protected float m_274460_() {
        return this.m_6113_();
    }

    protected float m_245547_(Player rider) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public boolean isRiderInWall() {
        LivingEntity rider = this.m_6688_();
        if (rider == null || rider.f_19794_) {
            return false;
        }
        float f = rider.m_6972_((Pose)Pose.STANDING).f_20377_ * 0.8f;
        AABB aabb = AABB.m_165882_((Vec3)rider.m_20182_().m_82520_(0.0, 0.5, 0.0), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(state -> {
            BlockState blockstate = this.m_9236_().m_8055_(state);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)this.m_9236_(), state) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), state).m_83216_((double)state.m_123341_(), (double)state.m_123342_(), (double)state.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean m_7327_(Entity entityIn) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)7);
        return true;
    }

    private boolean isHoveringFromServer() {
        if (this.m_20160_()) {
            return this.slowRidden;
        }
        return this.landingFlag || this.timeFlying < 30;
    }

    private void tickRotation(float yMov) {
        this.flightPitch = Mth.m_14148_((float)this.flightPitch, (float)yMov, (float)10.0f);
        float threshold = 1.0f;
        boolean flag = false;
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() > threshold) {
            this.flightRoll += 10.0f;
            flag = true;
        }
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() < -threshold) {
            this.flightRoll -= 10.0f;
            flag = true;
        }
        if (!flag) {
            if (this.flightRoll > 0.0f) {
                this.flightRoll = Math.max(this.flightRoll - 5.0f, 0.0f);
            }
            if (this.flightRoll < 0.0f) {
                this.flightRoll = Math.min(this.flightRoll + 5.0f, 0.0f);
            }
        }
        this.flightRoll = Mth.m_14036_((float)this.flightRoll, (float)-60.0f, (float)60.0f);
        this.tailYaw = Mth.m_14148_((float)this.tailYaw, (float)this.f_20883_, (float)8.0f);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVERING);
    }

    public void setHovering(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        this.f_19804_.m_135381_(HOVERING, (Object)flying);
    }

    @Override
    public boolean hasRidingMeter() {
        return true;
    }

    @Override
    public float getMeterAmount() {
        return ((Float)this.f_19804_.m_135370_(METER_AMOUNT)).floatValue();
    }

    public void setMeterAmount(float flightPower) {
        this.f_19804_.m_135381_(METER_AMOUNT, (Object)Float.valueOf(flightPower));
    }

    public float getFlapAmount(float partialTick) {
        return (this.prevFlapAmount + (this.flapAmount - this.prevFlapAmount) * partialTick) * 0.2f;
    }

    public float getFlyProgress(float partialTick) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTick) * 0.2f;
    }

    public float getHoverProgress(float partialTick) {
        return (this.prevHoverProgress + (this.hoverProgress - this.prevHoverProgress) * partialTick) * 0.2f;
    }

    public float getBiteProgress(float partialTick) {
        return (this.prevAttackProgress + (this.attackProgress - this.prevAttackProgress) * partialTick) * 0.2f;
    }

    public float getFlightPitch(float partialTick) {
        return this.prevFlightPitch + (this.flightPitch - this.prevFlightPitch) * partialTick;
    }

    public float getFlightRoll(float partialTick) {
        return this.prevFlightRoll + (this.flightRoll - this.prevFlightRoll) * partialTick;
    }

    public float getTailYaw(float partialTick) {
        return this.prevTailYaw + (this.tailYaw - this.prevTailYaw) * partialTick;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    public void resetPackFlags() {
        this.resetFlightAIFlag = true;
    }

    @Override
    public PackAnimal getPriorPackMember() {
        return this.priorPackMember;
    }

    @Override
    public PackAnimal getAfterPackMember() {
        return this.afterPackMember;
    }

    @Override
    public void setPriorPackMember(PackAnimal animal) {
        this.priorPackMember = (SubterranodonEntity)animal;
    }

    @Override
    public void setAfterPackMember(PackAnimal animal) {
        this.afterPackMember = (SubterranodonEntity)animal;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.SUBTERRANODON.get()).m_20615_((Level)serverLevel);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    @Override
    public BlockState createEggBlockState() {
        return (BlockState)((Block)ACBlockRegistry.SUBTERRANODON_EGG.get()).m_49966_().m_61124_((Property)MultipleDinosaurEggsBlock.EGGS, (Comparable)Integer.valueOf(1 + this.f_19796_.m_188503_(3)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult prev = super.m_6071_(player, hand);
        if (prev != InteractionResult.SUCCESS) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!this.m_21824_() && (itemStack.m_150930_((Item)ACItemRegistry.TRILOCARIS_TAIL.get()) || itemStack.m_150930_((Item)ACItemRegistry.COOKED_TRILOCARIS_TAIL.get()))) {
                this.m_142075_(player, hand, itemStack);
                if (this.m_217043_().m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_147271_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return prev;
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this)) {
            if (type == 0) {
                if (this.controlUpTicks != 10) {
                    this.setMeterAmount(Math.max(this.getMeterAmount() - 0.075f, 0.0f));
                }
                this.controlUpTicks = 10;
            }
            if (type == 1) {
                this.controlDownTicks = 10;
            }
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                float flight = this.getFlyProgress(1.0f) - this.getHoverProgress(1.0f);
                Vec3 seatOffset = new Vec3(0.0, 0.0, (double)(0.2f - 1.5f * flight)).m_82496_((float)Math.toRadians(this.m_146909_())).m_82524_((float)Math.toRadians(-this.f_20883_));
                double targetY = this.m_20186_() - (double)passenger.m_20206_() - 0.5 + (double)(0.25f * flight);
                passenger.m_5618_(this.f_20883_);
                passenger.f_19789_ = 0.0f;
                this.clampRotation(living, 105.0f);
                moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, targetY, this.m_20189_() + seatOffset.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    @Override
    public boolean tamesFromHatching() {
        return true;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.lastStepX), (double)0.0, (double)(this.m_20189_() - this.lastStepZ));
        float f2 = Math.min(f1 * 4.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public Vec3 m_20272_(Vec3 movement) {
        if (this.flightCollisionBox != null && !this.m_146899_() && this.m_20160_()) {
            boolean flag3;
            AABB aabb = this.flightCollisionBox;
            List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(movement));
            Vec3 vec3 = movement.m_82556_() == 0.0 ? movement : SubterranodonEntity.m_198894_((Entity)this, (Vec3)movement, (AABB)aabb, (Level)this.m_9236_(), (List)list);
            boolean flag = movement.f_82479_ != vec3.f_82479_;
            boolean flag1 = movement.f_82480_ != vec3.f_82480_;
            boolean flag2 = movement.f_82481_ != vec3.f_82481_;
            boolean bl = flag3 = this.m_20096_() || flag1 && movement.f_82480_ < 0.0;
            if (this.getStepHeight() > 0.0f && flag3 && (flag || flag2)) {
                Vec3 vec33;
                Vec3 vec31 = SubterranodonEntity.m_198894_((Entity)this, (Vec3)new Vec3(movement.f_82479_, (double)this.getStepHeight(), movement.f_82481_), (AABB)aabb, (Level)this.m_9236_(), (List)list);
                Vec3 vec32 = SubterranodonEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)this.getStepHeight(), 0.0), (AABB)aabb.m_82363_(movement.f_82479_, 0.0, movement.f_82481_), (Level)this.m_9236_(), (List)list);
                if (vec32.f_82480_ < (double)this.getStepHeight() && (vec33 = SubterranodonEntity.m_198894_((Entity)this, (Vec3)new Vec3(movement.f_82479_, 0.0, movement.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                    vec31 = vec33;
                }
                if (vec31.m_165925_() > vec3.m_165925_()) {
                    return vec31.m_82549_(SubterranodonEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.f_82480_ + movement.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list));
                }
            }
            return vec3;
        }
        return super.m_20272_(movement);
    }

    @Override
    public boolean canOwnerMount(Player player) {
        return !this.m_6162_();
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return ownerPlayer.m_6144_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42526_) || stack.m_150930_(Items.f_42530_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.SUBTERRANODON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.SUBTERRANODON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.SUBTERRANODON_DEATH.get();
    }

    class FlightMoveHelper
    extends MoveControl {
        private final SubterranodonEntity parentEntity;

        public FlightMoveHelper(SubterranodonEntity bird) {
            super((Mob)bird);
            this.parentEntity = bird;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d5 = vector3d.m_82553_();
                if (d5 < this.parentEntity.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_(0.5));
                } else {
                    float hoverSlow = this.parentEntity.isHoveringFromServer() && !this.parentEntity.landingFlag ? 0.2f : 1.0f;
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.1 / d5).m_82542_((double)hoverSlow, 1.0, (double)hoverSlow)));
                    Vec3 vector3d1 = this.parentEntity.m_20184_();
                    float f = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 180.0f / (float)Math.PI;
                    this.parentEntity.m_146922_(Mth.m_14148_((float)this.parentEntity.m_146908_(), (float)f, (float)20.0f));
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }
}

