/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.AbstractMovingBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PlayMessages;

public class FallingTreeBlockEntity
extends AbstractMovingBlockEntity {
    private static final EntityDataAccessor<Direction> FALL_DIRECTION = SynchedEntityData.m_135353_(FallingTreeBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Float> FALL_PROGRESS = SynchedEntityData.m_135353_(FallingTreeBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float prevFallProgress = 0.0f;
    private boolean droppedItems = false;

    public FallingTreeBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public FallingTreeBlockEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.FALLING_TREE_BLOCK.get(), level);
        this.m_20011_(this.m_142242_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FALL_DIRECTION, (Object)Direction.NORTH);
        this.f_19804_.m_135372_(FALL_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFallDirection(Direction.m_122376_((int)compound.m_128445_("FallDirection")));
        this.setFallProgress(compound.m_128457_("FallProgress"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("FallDirection", (byte)this.getFallDirection().m_122411_());
        compound.m_128350_("FallProgress", 0.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevFallProgress = this.getFallProgress();
        if (this.getFallProgress() >= 1.0f) {
            BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82292_, (double)this.m_20189_());
            if (!this.m_9236_().f_46443_ && !this.droppedItems) {
                for (MovingBlockData dataBlock : this.getData()) {
                    BlockPos offset = dataBlock.getOffset();
                    if (offset.equals((Object)BlockPos.f_121853_)) continue;
                    BlockPos rotatedOffset = new BlockPos(offset.m_123341_(), offset.m_123343_(), -offset.m_123342_()).m_7954_(this.getRotationFromDirection(this.getFallDirection()));
                    BlockPos fallPos = pos.m_121955_((Vec3i)rotatedOffset);
                    while (this.m_9236_().m_8055_(fallPos).m_60795_() && fallPos.m_123342_() > this.m_9236_().m_141937_()) {
                        fallPos = fallPos.m_7495_();
                    }
                    this.createBlockDropAt(fallPos.m_7494_(), dataBlock.getState(), dataBlock.blockData);
                }
                this.droppedItems = true;
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.setFallProgress(Math.min(this.getFallProgress() + 0.05f, 1.0f));
    }

    private void createBlockDropAt(BlockPos fallPos, BlockState state, CompoundTag blockData) {
        Block.m_49950_((BlockState)state, (Level)this.m_9236_(), (BlockPos)fallPos);
    }

    public Rotation getRotationFromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public Direction getFallDirection() {
        return (Direction)this.f_19804_.m_135370_(FALL_DIRECTION);
    }

    public void setFallDirection(Direction direction) {
        this.f_19804_.m_135381_(FALL_DIRECTION, (Object)direction);
    }

    protected float getFallProgress() {
        return ((Float)this.f_19804_.m_135370_(FALL_PROGRESS)).floatValue();
    }

    public float getFallProgress(float partialTick) {
        return this.prevFallProgress + (this.getFallProgress() - this.prevFallProgress) * partialTick;
    }

    public void setFallProgress(float f) {
        this.f_19804_.m_135381_(FALL_PROGRESS, (Object)Float.valueOf(f));
    }

    @Override
    public boolean canBePlaced() {
        return false;
    }

    @Override
    public boolean movesEntities() {
        return false;
    }
}

