/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;

public class DarkArrowEntity
extends AbstractArrow {
    private float fadeOut = 0.0f;
    private float prevFadeOut = 0.0f;
    private boolean startFading = false;

    public DarkArrowEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public DarkArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ACEntityRegistry.DARK_ARROW.get(), shooter, level);
    }

    public DarkArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.DARK_ARROW.get(), x, y, z, level);
    }

    public DarkArrowEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.DARK_ARROW.get(), level);
        this.m_20011_(this.m_142242_());
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_36799_() {
        this.f_36703_ = false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFadeOut = this.fadeOut;
        if (this.f_36703_) {
            this.startFading = true;
        }
        if (this.startFading) {
            this.f_19794_ = true;
            this.m_20256_(this.m_20184_().m_82490_((double)0.7f));
            float f = this.fadeOut;
            this.fadeOut = f + 1.0f;
            if (f > 5.0f) {
                this.m_146870_();
            }
        }
    }

    protected float m_6882_() {
        return 0.9f;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = ACDamageTypes.causeDarkArrowDamage(entity.m_9236_().m_9598_(), owner);
        if (owner == null || !entity.m_7306_(owner) && !entity.m_7307_(owner) && !owner.m_7307_(entity)) {
            entity.m_6469_(damageSource, 0.45f);
        }
    }

    public float getFadeOut(float partialTicks) {
        return this.prevFadeOut + (this.fadeOut - this.prevFadeOut) * partialTicks;
    }
}

