/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneMageEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DeepOneWanderGoal
extends Goal {
    private BlockPos goal = null;
    private DeepOneBaseEntity mob;
    private int chance;
    private double speed;
    private boolean groundTarget = false;

    public DeepOneWanderGoal(DeepOneBaseEntity mob, int chance, double speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
        this.chance = chance;
        this.speed = speed;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return !(!this.mob.m_20072_() || target != null && target.m_6084_() || this.chance != 0 && this.mob.m_217043_().m_188503_(this.chance) != 0);
    }

    public boolean m_8045_() {
        return this.goal != null && !this.mob.m_21573_().m_26571_() && this.mob.m_217043_().m_188503_(200) != 0;
    }

    public void m_8056_() {
        this.groundTarget = this.mob.m_20096_() ? this.mob.m_217043_().m_188501_() < 0.7f : this.mob.m_217043_().m_188501_() < 0.2f;
        this.goal = this.findSwimToPos();
    }

    public void m_8037_() {
        this.mob.m_21573_().m_26519_((double)this.goal.m_123341_(), (double)this.goal.m_123342_(), (double)this.goal.m_123343_(), this.speed);
        if (this.groundTarget) {
            if (this.mob.m_20096_()) {
                this.mob.setDeepOneSwimming(false);
            } else if (this.mob.m_20238_(Vec3.m_82512_((Vec3i)this.goal)) < 4.0) {
                this.mob.m_20256_(this.mob.m_20184_().m_82490_(0.8).m_82520_(0.0, (double)-0.1f, 0.0));
            }
        }
        if (!this.groundTarget) {
            this.mob.setDeepOneSwimming(true);
        }
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        return this.mob.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob)).m_6662_() != HitResult.Type.MISS;
    }

    public BlockPos findSwimToPos() {
        BlockPos around = this.mob.m_20183_();
        BlockPos.MutableBlockPos move = new BlockPos.MutableBlockPos();
        move.m_122169_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        while (move.m_123342_() < this.mob.m_9236_().m_151558_() && this.mob.m_9236_().m_6425_((BlockPos)move).m_205070_(FluidTags.f_13131_)) {
            move.m_122184_(0, 5, 0);
        }
        int surfaceY = move.m_123342_();
        around = around.m_175288_(Math.max(surfaceY - 40, around.m_123342_()));
        int range = 18;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockPos = around.m_7918_(this.mob.m_217043_().m_188503_(range) - range / 2, this.mob.m_217043_().m_188503_(range) - range / 2, this.mob.m_217043_().m_188503_(range) - range / 2);
            if (!this.mob.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || this.isTargetBlocked(Vec3.m_82512_((Vec3i)blockPos)) || blockPos.m_123342_() <= this.mob.m_9236_().m_141937_() + 1) continue;
            if (this.groundTarget) {
                while (this.groundTarget && this.mob.m_9236_().m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && blockPos.m_123342_() > this.mob.m_9236_().m_141937_()) {
                    blockPos = blockPos.m_7495_();
                }
                if (this.mob instanceof DeepOneMageEntity) {
                    blockPos = blockPos.m_6630_(1 + this.mob.m_217043_().m_188503_(2));
                }
            }
            return blockPos;
        }
        return around;
    }
}

