/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.HullbreakerModel;
import com.github.alexmodguy.alexscaves.client.model.NotorModel;
import com.github.alexmodguy.alexscaves.client.model.UnderzealotModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.DeepOneMageRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneMageEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.NotorEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class NotorRenderer
extends MobRenderer<NotorEntity, NotorModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/notor.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/notor_glow.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexscaves:textures/entity/notor_eyes.png");
    private static final List<NotorEntity> allOnScreen = new ArrayList<NotorEntity>();

    public NotorRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new NotorModel(), 0.25f);
        this.m_115326_(new LayerGlow());
    }

    public boolean shouldRender(NotorEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        if (entity.getBeamProgress(1.0f) > 0.0f) {
            Vec3 vec3 = entity.m_20182_();
            Vec3 vec31 = entity.getBeamEndPosition(1.0f);
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    protected void scale(NotorEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public void render(NotorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
        Vec3 renderAt = entity.m_20318_(partialTicks);
        if (entity.m_6084_()) {
            Entity hologramEntity = entity.getHologramEntity();
            boolean scanning = !entity.showingHologram();
            Vec3 hologramScanPos = entity.getBeamEndPosition(partialTicks);
            float beamProgress = entity.getBeamProgress(partialTicks);
            if (hologramEntity != null && entity.showingHologram()) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
                poseStack.m_85836_();
                poseStack.m_85837_(hologramScanPos.f_82479_ - renderAt.f_82479_, hologramScanPos.f_82480_ - renderAt.f_82480_, hologramScanPos.f_82481_ - renderAt.f_82481_);
                poseStack.m_85841_(1.0f, entity.getHologramProgress(partialTicks), 1.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)entity.f_19797_ + partialTicks) * 3.0f));
                NotorRenderer.renderEntityInHologram(hologramEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, source, 240);
                poseStack.m_85849_();
            }
            if (hologramScanPos != null) {
                Vec3 eyeOffset = entity.m_20252_(1.0f).m_82490_((double)0.1f);
                Vec3 modelOffset = ((NotorModel)this.f_115290_).getChainPosition(Vec3.f_82478_).m_82549_(eyeOffset);
                Vec3 toTranslate = hologramScanPos.m_82546_(entity.m_20318_(partialTicks).m_82549_(modelOffset));
                float yRot = (float)Mth.m_14136_((double)toTranslate.f_82479_, (double)toTranslate.f_82481_) * 180.0f / (float)Math.PI;
                float xRot = -((float)(Mth.m_14136_((double)toTranslate.f_82480_, (double)toTranslate.m_165924_()) * 57.2957763671875));
                float length = ((float)toTranslate.m_82553_() - (float)(scanning ? false : false)) * beamProgress;
                float width = hologramEntity == null ? 1.3f : hologramEntity.m_20206_() / 2.0f;
                poseStack.m_85836_();
                poseStack.m_85837_(modelOffset.f_82479_, modelOffset.f_82480_, modelOffset.f_82481_);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
                poseStack.m_252781_(Axis.f_252393_.m_252977_(xRot));
                poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                if (scanning) {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                }
                PoseStack.Pose posestack$pose = poseStack.m_85850_();
                Matrix4f matrix4f1 = posestack$pose.m_252922_();
                Matrix3f matrix3f1 = posestack$pose.m_252943_();
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
                VertexConsumer lightConsumer = source.m_6299_(ACRenderTypes.getHologramLights());
                NotorRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
                NotorRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                NotorRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                NotorRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                poseStack.m_85849_();
            }
        }
    }

    public static <E extends Entity> void renderEntityInHologram(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
        EntityRenderer render = null;
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        try {
            render = manager.m_114382_(entityIn);
            float animSpeed = 0.0f;
            float animSpeedOld = 0.0f;
            float animPos = 0.0f;
            float xRot = entityIn.m_146909_();
            float xRotOld = entityIn.f_19860_;
            float yRot = entityIn.m_146908_();
            float yRotOld = entityIn.f_19859_;
            float yBodyRot = 0.0f;
            float yBodyRotOld = 0.0f;
            float headRot = 0.0f;
            float headRotOld = 0.0f;
            if (entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                headRot = living.f_20885_;
                headRotOld = living.f_20886_;
                yBodyRot = living.f_20883_;
                yBodyRotOld = living.f_20884_;
                living.f_20885_ = 0.0f;
                living.f_20886_ = 0.0f;
                living.f_20883_ = 0.0f;
                living.f_20884_ = 0.0f;
                entityIn.m_146926_(0.0f);
                entityIn.f_19860_ = 0.0f;
                entityIn.m_146922_(0.0f);
                entityIn.f_19859_ = 0.0f;
                if (render instanceof LivingEntityRenderer) {
                    HullbreakerModel hullbreakerModel;
                    UnderzealotModel underzealotModel;
                    HumanoidModel humanoidModel;
                    LivingEntityRenderer renderer = (LivingEntityRenderer)render;
                    EntityModel model = renderer.m_7200_();
                    VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getHologram(entityIn instanceof DeepOneMageEntity ? DeepOneMageRenderer.TEXTURE : render.m_5478_(entityIn)));
                    matrixStack.m_85836_();
                    boolean shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
                    model.f_102610_ = living.m_6162_();
                    model.f_102609_ = shouldSit;
                    model.f_102608_ = living.m_21324_(partialTicks);
                    boolean prevCrouching = false;
                    if (model instanceof HumanoidModel) {
                        humanoidModel = (HumanoidModel)model;
                        prevCrouching = humanoidModel.f_102817_;
                        humanoidModel.f_102817_ = false;
                    }
                    if (model instanceof UnderzealotModel) {
                        underzealotModel = (UnderzealotModel)model;
                        underzealotModel.noBurrowing = true;
                    }
                    if (model instanceof HullbreakerModel) {
                        hullbreakerModel = (HullbreakerModel)model;
                        hullbreakerModel.straighten = true;
                    }
                    model.m_6973_((Entity)living, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
                    if (model instanceof UnderzealotModel) {
                        underzealotModel = (UnderzealotModel)model;
                        underzealotModel.noBurrowing = false;
                    }
                    if (model instanceof HullbreakerModel) {
                        hullbreakerModel = (HullbreakerModel)model;
                        hullbreakerModel.straighten = false;
                    }
                    matrixStack.m_85841_(living.m_6134_(), -living.m_6134_(), living.m_6134_());
                    model.m_7695_(matrixStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStack.m_85849_();
                    if (model instanceof HumanoidModel) {
                        humanoidModel = (HumanoidModel)model;
                        humanoidModel.f_102817_ = prevCrouching;
                    }
                }
                entityIn.m_146926_(xRot);
                entityIn.f_19860_ = xRotOld;
                entityIn.m_146922_(yRot);
                entityIn.f_19859_ = yRotOld;
                living.f_20885_ = headRot;
                living.f_20886_ = headRotOld;
                living.f_20883_ = yBodyRot;
                living.f_20884_ = yBodyRotOld;
            }
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
        catch (Throwable throwable3) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            entityIn.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 230).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(0, 0, 255, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(0, 0, 255, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(NotorEntity entity) {
        return TEXTURE;
    }

    class LayerGlow
    extends RenderLayer<NotorEntity, NotorModel> {
        public LayerGlow() {
            super((RenderLayerParent)NotorRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, NotorEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder2;
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getGhostly(TEXTURE_GLOW));
            float alpha = 1.0f;
            ((NotorModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
            if (entitylivingbaseIn.getBeamProgress(partialTicks) > 0.0f) {
                PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
                ivertexbuilder2 = bufferIn.m_6299_(ACRenderTypes.getHologram(TEXTURE_EYES));
            } else {
                ivertexbuilder2 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_EYES));
            }
            ((NotorModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

