/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolver;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class TremorsaurusModel
extends AdvancedEntityModel<TremorsaurusEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox rleg2;
    private final AdvancedModelBox rfoot;
    private final AdvancedModelBox rclaw1;
    private final AdvancedModelBox rclaw2;
    private final AdvancedModelBox rclaw3;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox lleg2;
    private final AdvancedModelBox lfoot;
    private final AdvancedModelBox lclaw1;
    private final AdvancedModelBox lclaw2;
    private final AdvancedModelBox lclaw3;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox head;
    private final AdvancedModelBox glasses;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox tailTip;
    private final ModelAnimator animator;

    public TremorsaurusModel() {
        this.texWidth = 256;
        this.texHeight = 256;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -17.0f, 0.0f);
        this.body.setTextureOffset(0, 0).addBox(-13.0f, -15.0f, -20.0f, 26.0f, 30.0f, 39.0f, 0.0f, false);
        this.body.setTextureOffset(91, 0).addBox(-1.0f, -18.0f, -9.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(91, 0).addBox(-1.0f, -18.0f, -18.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(91, 0).addBox(-1.0f, -18.0f, -2.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(91, 0).addBox(-1.0f, -18.0f, 5.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(91, 0).addBox(-1.0f, -18.0f, 12.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-13.0f, 11.0f, -13.5f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.setRotateAngle(this.rarm, 0.0f, 0.0f, -1.2654f);
        this.rarm.setTextureOffset(16, 24).addBox(-8.0f, 0.0f, -1.5f, 8.0f, 3.0f, 3.0f, 0.0f, true);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(13.0f, 11.0f, -13.5f);
        this.body.addChild((BasicModelPart)this.larm);
        this.setRotateAngle(this.larm, 0.0f, 0.0f, 1.2654f);
        this.larm.setTextureOffset(16, 24).addBox(0.0f, 0.0f, -1.5f, 8.0f, 3.0f, 3.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-11.5f, 2.0f, 6.5f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(61, 106).addBox(-6.5f, -2.0f, -9.5f, 13.0f, 26.0f, 19.0f, 0.0f, true);
        this.rleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg2.setRotationPoint(0.0f, 21.5f, 7.0f);
        this.rleg.addChild((BasicModelPart)this.rleg2);
        this.rleg2.setTextureOffset(0, 0).addBox(-3.5f, -1.5f, -3.5f, 7.0f, 15.0f, 9.0f, 0.0f, true);
        this.rfoot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rfoot.setRotationPoint(0.5f, 13.5f, 1.0f);
        this.rleg2.addChild((BasicModelPart)this.rfoot);
        this.rfoot.setTextureOffset(125, 127).addBox(-6.0f, 0.0f, -12.5f, 11.0f, 4.0f, 17.0f, 0.0f, true);
        this.rclaw1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rclaw1.setRotationPoint(4.0f, 0.0f, -12.5f);
        this.rfoot.addChild((BasicModelPart)this.rclaw1);
        this.rclaw1.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, true);
        this.rclaw2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rclaw2.setRotationPoint(-0.5f, 0.0f, -12.5f);
        this.rfoot.addChild((BasicModelPart)this.rclaw2);
        this.rclaw2.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, true);
        this.rclaw3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rclaw3.setRotationPoint(-5.0f, 0.0f, -12.5f);
        this.rfoot.addChild((BasicModelPart)this.rclaw3);
        this.rclaw3.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(11.5f, 2.0f, 6.5f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(61, 106).addBox(-6.5f, -2.0f, -9.5f, 13.0f, 26.0f, 19.0f, 0.0f, false);
        this.lleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg2.setRotationPoint(0.0f, 21.5f, 7.0f);
        this.lleg.addChild((BasicModelPart)this.lleg2);
        this.lleg2.setTextureOffset(0, 0).addBox(-3.5f, -1.5f, -3.5f, 7.0f, 15.0f, 9.0f, 0.0f, false);
        this.lfoot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lfoot.setRotationPoint(-0.5f, 13.5f, 1.0f);
        this.lleg2.addChild((BasicModelPart)this.lfoot);
        this.lfoot.setTextureOffset(125, 127).addBox(-5.0f, 0.0f, -12.5f, 11.0f, 4.0f, 17.0f, 0.0f, false);
        this.lclaw1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lclaw1.setRotationPoint(-4.0f, 0.0f, -12.5f);
        this.lfoot.addChild((BasicModelPart)this.lclaw1);
        this.lclaw1.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, false);
        this.lclaw2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lclaw2.setRotationPoint(0.5f, 0.0f, -12.5f);
        this.lfoot.addChild((BasicModelPart)this.lclaw2);
        this.lclaw2.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, false);
        this.lclaw3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lclaw3.setRotationPoint(5.0f, 0.0f, -12.5f);
        this.lfoot.addChild((BasicModelPart)this.lclaw3);
        this.lclaw3.setTextureOffset(91, 8).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 4.0f, 4.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(0.0f, -5.0f, -14.0f);
        this.body.addChild((BasicModelPart)this.neck);
        this.setRotateAngle(this.neck, 0.7854f, 0.0f, 0.0f);
        this.neck.setTextureOffset(44, 111).addBox(-1.0f, -19.0f, 3.0f, 2.0f, 5.0f, 3.0f, 0.0f, false);
        this.neck.setTextureOffset(0, 69).addBox(-1.0f, -26.0f, 1.0f, 2.0f, 5.0f, 5.0f, 0.0f, false);
        this.neck.setTextureOffset(91, 0).addBox(-1.0f, -26.0f, -6.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.neck.setTextureOffset(0, 111).addBox(-7.0f, -23.0f, -13.0f, 14.0f, 26.0f, 16.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -17.0f, -8.0f);
        this.neck.addChild((BasicModelPart)this.head);
        this.setRotateAngle(this.head, -0.5672f, 0.0f, 0.0f);
        this.head.setTextureOffset(91, 0).addBox(-7.5f, -6.1f, -21.0f, 15.0f, 9.0f, 21.0f, 0.0f, false);
        this.head.setTextureOffset(130, 59).addBox(-7.5f, -0.1f, -7.0f, 15.0f, 3.0f, 7.0f, 0.0f, false);
        this.head.setTextureOffset(0, 25).addBox(2.5f, -9.1f, -7.0f, 5.0f, 3.0f, 6.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(5.5f, -11.1f, -7.0f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(-7.5f, -11.1f, -7.0f, 2.0f, 2.0f, 2.0f, 0.0f, true);
        this.head.setTextureOffset(0, 25).addBox(-7.5f, -9.1f, -7.0f, 5.0f, 3.0f, 6.0f, 0.0f, true);
        this.head.setTextureOffset(0, 153).addBox(-7.5f, 2.9f, -21.0f, 15.0f, 5.0f, 21.0f, 0.0f, false);
        this.glasses = new AdvancedModelBox((AdvancedEntityModel)this);
        this.glasses.setRotationPoint(0.0f, -7.6f, -2.5f);
        this.head.addChild((BasicModelPart)this.glasses);
        this.glasses.setTextureOffset(91, 30).addBox(-8.0f, -1.5f, -5.0f, 16.0f, 3.0f, 6.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, -0.25f, -2.0f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(124, 73).addBox(-8.5f, 3.15f, -20.0f, 17.0f, 7.0f, 15.0f, 0.0f, false);
        this.jaw.setTextureOffset(125, 106).addBox(-8.5f, -3.85f, -20.0f, 17.0f, 7.0f, 14.0f, 0.0f, false);
        this.jaw.setTextureOffset(57, 70).addBox(-8.5f, 0.15f, -5.0f, 17.0f, 10.0f, 8.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -4.0f, 18.0f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(135, 2).addBox(-8.0f, -9.0f, -3.0f, 16.0f, 18.0f, 28.0f, 0.0f, false);
        this.tail.setTextureOffset(91, 0).addBox(-1.0f, -12.0f, 3.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.tail.setTextureOffset(91, 0).addBox(-1.0f, -12.0f, 10.0f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.tail.setTextureOffset(0, 111).addBox(-1.0f, -11.0f, 17.0f, 2.0f, 2.0f, 4.0f, 0.0f, false);
        this.tailTip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tailTip.setRotationPoint(0.0f, -2.5f, 24.0f);
        this.tail.addChild((BasicModelPart)this.tailTip);
        this.tailTip.setTextureOffset(0, 1).addBox(0.0f, -5.5f, 20.0f, 0.0f, 1.0f, 3.0f, 0.0f, false);
        this.tailTip.setTextureOffset(0, 2).addBox(0.0f, -5.5f, 15.0f, 0.0f, 1.0f, 3.0f, 0.0f, false);
        this.tailTip.setTextureOffset(157, 64).addBox(-4.0f, -4.5f, -2.0f, 8.0f, 9.0f, 31.0f, 0.0f, false);
        this.tailTip.setTextureOffset(0, 111).addBox(-1.0f, -6.5f, 9.0f, 2.0f, 2.0f, 4.0f, 0.0f, false);
        this.tailTip.setTextureOffset(0, 111).addBox(-1.0f, -6.5f, 3.0f, 2.0f, 2.0f, 4.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            float f = 1.5f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
            matrixStackIn.m_85837_(0.0, 4.5, 0.0);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(TremorsaurusEntity.ANIMATION_SNIFF);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(TremorsaurusEntity.ANIMATION_SPEAK);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.neck, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(7);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(TremorsaurusEntity.ANIMATION_ROAR);
        this.animator.startKeyframe(5);
        this.animator.move(this.lleg, 0.0f, -1.5f, 0.0f);
        this.animator.move(this.rleg, 0.0f, -1.5f, 0.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.lleg, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.rleg, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animatePose(0);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0));
        this.animator.rotate(this.jaw, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animatePose(0);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0));
        this.animator.rotate(this.jaw, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(TremorsaurusEntity.ANIMATION_BITE);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.neck, 0.0f, 1.0f, -4.0f);
        this.animator.move(this.head, 0.0f, -3.0f, 1.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-45.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(70.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(TremorsaurusEntity.ANIMATION_SHAKE_PREY);
        this.animator.startKeyframe(5);
        this.animatePose(0);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(25);
        this.animator.resetKeyframe(5);
    }

    private void animatePose(int pose) {
        switch (pose) {
            case 0: {
                this.animator.move(this.body, 0.0f, 2.0f, -5.0f);
                this.animator.move(this.neck, 0.0f, 3.0f, 0.0f);
                this.animator.move(this.head, 0.0f, 0.0f, -5.0f);
                this.animator.move(this.lleg, 0.0f, 3.0f, 3.0f);
                this.animator.move(this.rleg, 0.0f, 3.0f, 3.0f);
                this.animator.rotate(this.body, (float)Math.toRadians(30.0), 0.0f, 0.0f);
                this.animator.rotate(this.lleg, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
                this.animator.rotate(this.rleg, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
                this.animator.rotate(this.neck, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
                this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
                this.animator.rotate(this.tail, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
                this.animator.rotate(this.tailTip, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
            }
        }
    }

    private void setupAnimForAnimation(TremorsaurusEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float animationIntensity;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        if (entity.getAnimation() == TremorsaurusEntity.ANIMATION_ROAR) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 5, 40);
            this.head.swing(1.0f, 0.1f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.jaw.walk(2.0f, 0.1f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == TremorsaurusEntity.ANIMATION_SHAKE_PREY) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 5, 30);
            this.body.swing(0.6f, 0.8f, false, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.lleg.swing(0.6f, 0.8f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.rleg.swing(0.6f, 0.8f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.swing(0.6f, 0.8f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.head.swing(0.6f, 0.8f, false, -2.0f, 0.0f, ageInTicks, animationIntensity);
            this.tail.swing(0.6f, 0.8f, true, 2.0f, 0.0f, ageInTicks, animationIntensity);
            this.tailTip.swing(0.6f, 0.8f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
        }
    }

    public void setupAnim(TremorsaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float danceAmount = entity.getDanceProgress(partialTicks);
        float sitAmount = entity.getSitProgress(partialTicks);
        float buryEggsAmount = entity.getBuryEggsProgress(partialTicks);
        float danceSpeed = 0.5f;
        this.glasses.showModel = danceAmount > 0.0f;
        float walkSpeed = 0.8f;
        float walkDegree = 1.0f;
        this.progressPositionPrev(this.body, sitAmount, 0.0f, 18.0f, -1.0f, 1.0f);
        this.progressPositionPrev(this.rleg, sitAmount, 0.0f, -11.0f, 12.0f, 1.0f);
        this.progressPositionPrev(this.lleg, sitAmount, 0.0f, -11.0f, 12.0f, 1.0f);
        this.progressRotationPrev(this.rleg, sitAmount, (float)Math.toRadians(-20.0), (float)Math.toRadians(15.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg2, sitAmount, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rfoot, sitAmount, (float)Math.toRadians(70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, sitAmount, (float)Math.toRadians(-20.0), (float)Math.toRadians(-15.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg2, sitAmount, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lfoot, sitAmount, (float)Math.toRadians(70.0), 0.0f, 0.0f, 1.0f);
        if (buryEggsAmount > 0.0f) {
            limbSwing = ageInTicks;
            limbSwingAmount = buryEggsAmount * 0.5f;
            this.body.swing(0.25f, 0.4f, false, 0.0f, 0.0f, ageInTicks, buryEggsAmount);
            this.neck.swing(0.25f, 0.4f, true, -1.0f, 0.0f, ageInTicks, buryEggsAmount);
        }
        float bodyIdleBob = this.walkValue(ageInTicks, 1.0f, 0.1f, -1.0f, 1.0f, false);
        this.walk(this.neck, 0.1f, 0.03f, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.head, 0.1f, 0.03f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.jaw, 0.1f, 0.03f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.rarm, 0.1f, 0.05f, false, 3.0f, -0.1f, ageInTicks, 1.0f);
        this.flap(this.larm, 0.1f, 0.05f, true, 3.0f, -0.1f, ageInTicks, 1.0f);
        this.swing(this.rarm, 0.1f, 0.1f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.larm, 0.1f, 0.1f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail, 0.1f, 0.15f, true, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tailTip, 0.1f, 0.15f, true, -2.0f, 0.0f, ageInTicks, 1.0f);
        float bodyWalkBob = -Math.abs(this.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, 4.0f, false));
        this.body.rotationPointY += bodyIdleBob + bodyWalkBob;
        this.lleg.rotationPointY -= bodyIdleBob + bodyWalkBob;
        this.rleg.rotationPointY -= bodyIdleBob + bodyWalkBob;
        this.swing(this.body, walkSpeed, walkDegree * 0.3f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tail, walkSpeed, walkDegree * 0.5f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tailTip, walkSpeed, walkDegree * 0.5f, false, -2.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.body, walkSpeed, walkDegree * 0.3f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.neck, walkSpeed, walkDegree * 0.3f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.lleg, walkSpeed, walkDegree * 0.3f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.rleg, walkSpeed, walkDegree * 0.3f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.body, walkSpeed, walkDegree * 0.5f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.tail, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.lleg, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.rleg, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.neck, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.6f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.lleg2, walkSpeed, walkDegree * 0.6f, false, 1.5f, -0.1f, limbSwing, limbSwingAmount);
        this.walk(this.lfoot, walkSpeed, walkDegree * 1.0f, false, -1.5f, 0.35f, limbSwing, limbSwingAmount);
        this.lleg.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 30.0f, true));
        this.lfoot.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, walkDegree * 2.0f, false));
        this.walk(this.rleg, walkSpeed, walkDegree * 0.6f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rleg2, walkSpeed, walkDegree * 0.6f, true, 1.5f, 0.1f, limbSwing, limbSwingAmount);
        this.walk(this.rfoot, walkSpeed, walkDegree * 1.0f, true, -1.5f, -0.35f, limbSwing, limbSwingAmount);
        this.rleg.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 30.0f, false));
        this.rfoot.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, walkDegree * 2.0f, true));
        this.flap(this.rarm, walkSpeed, walkDegree * 0.1f, false, -1.5f, 0.2f, limbSwing, limbSwingAmount);
        this.flap(this.larm, walkSpeed, walkDegree * 0.1f, true, -1.5f, 0.2f, limbSwing, limbSwingAmount);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.neck, this.head});
        this.articulateLegs(entity.legSolver, partialTicks);
        this.walk(this.neck, danceSpeed, 0.5f, false, 1.0f, 0.2f, ageInTicks, danceAmount);
        this.swing(this.neck, danceSpeed, 0.35f, false, 0.0f, 0.0f, ageInTicks, danceAmount);
        this.walk(this.head, danceSpeed, 0.5f, true, 1.0f, 0.2f, ageInTicks, danceAmount);
        this.swing(this.head, danceSpeed, 0.35f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.larm, danceSpeed, 0.6f, false, 1.0f, -0.3f, ageInTicks, danceAmount);
        this.swing(this.rarm, danceSpeed, 0.6f, false, 1.0f, -0.3f, ageInTicks, danceAmount);
        this.flap(this.larm, danceSpeed, 0.3f, false, 1.0f, -0.3f, ageInTicks, danceAmount);
        this.flap(this.rarm, danceSpeed, 0.3f, false, 1.0f, 0.3f, ageInTicks, danceAmount);
        this.swing(this.body, danceSpeed, 0.2f, false, -1.0f, 0.0f, ageInTicks, danceAmount);
    }

    private void articulateLegs(LegSolver legs, float partialTick) {
        float heightBackLeft = legs.legs[0].getHeight(partialTick);
        float heightBackRight = legs.legs[1].getHeight(partialTick);
        float max = (1.0f - ACMath.smin(1.0f - heightBackLeft, 1.0f - heightBackRight, 0.1f)) * 0.8f;
        this.body.rotationPointY += max * 16.0f;
        this.rleg.rotationPointY += (heightBackRight - max) * 16.0f;
        this.lleg.rotationPointY += (heightBackLeft - max) * 16.0f;
    }

    private float walkValue(float limbSwing, float limbSwingAmount, float speed, float offset, float degree, boolean inverse) {
        return (float)(Math.cos(limbSwing * speed + offset) * (double)degree * (double)limbSwingAmount * (double)(inverse ? -1 : 1));
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.neck, (Object)this.head, (Object)this.jaw, (Object)this.glasses, (Object)this.tail, (Object)this.tailTip, (Object)this.rarm, (Object)this.larm, (Object)this.rleg, (Object)this.rleg2, (Object)this.rfoot, (Object[])new AdvancedModelBox[]{this.rclaw1, this.rclaw2, this.rclaw3, this.lleg, this.lleg2, this.lfoot, this.lclaw1, this.lclaw2, this.lclaw3});
    }

    public void translateToMouth(PoseStack matrixStackIn) {
        this.body.translateAndRotate(matrixStackIn);
        this.neck.translateAndRotate(matrixStackIn);
        this.head.translateAndRotate(matrixStackIn);
    }

    public Vec3 getRiderPosition(Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        this.body.translateAndRotate(translationStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)armOffsetVec.x(), (double)armOffsetVec.y(), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3;
    }
}

