/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.world.gen.structures;

import com.google.common.collect.Lists;
import com.ninni.twigs.registry.TwigsLootTables;
import com.ninni.twigs.registry.TwigsStructurePieceTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ObeliskGenerator {
    private static final ResourceLocation OBELISK = new ResourceLocation("twigs", "bloodstone_obelisk/bloodstone_obelisk");

    public static void addPieces(StructureTemplateManager manager, BlockPos pos, Rotation rotation, StructurePiecesBuilder holder) {
        holder.m_142679_((StructurePiece)new Piece(manager, OBELISK, pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public static final String ROTATION_KEY = "Rotation";

        public Piece(StructureTemplateManager manager, ResourceLocation id, BlockPos pos, Rotation rotation) {
            super(TwigsStructurePieceTypes.BLOODSTONE_OBELISK, 0, manager, id, id.toString(), Piece.createPlacementData(rotation), pos);
        }

        public Piece(StructureTemplateManager manager, CompoundTag nbt) {
            super(TwigsStructurePieceTypes.BLOODSTONE_OBELISK, nbt, manager, id -> Piece.createPlacementData(Rotation.valueOf((String)nbt.m_128461_(ROTATION_KEY))));
        }

        private static StructurePlaceSettings createPlacementData(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }

        protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
            super.m_183620_(structurePieceSerializationContext, compoundTag);
            compoundTag.m_128359_(ROTATION_KEY, this.f_73657_.m_74404_().name());
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            if (world.m_8055_(this.f_73658_.m_7495_()).m_204336_(BlockTags.f_13077_) || world.m_8055_(this.f_73658_.m_7495_()).m_60713_(Blocks.f_50134_) && world.m_46859_(this.f_73658_)) {
                this.f_73658_ = this.f_73658_.m_7495_();
            }
            super.m_213694_(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        }

        protected void m_213704_(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
            if (metadata.startsWith("CHEST")) {
                Rotation rotation = this.f_73657_.m_74404_();
                BlockState blockState = Blocks.f_50087_.m_49966_();
                this.m_226762_(world, boundingBox, random, pos, TwigsLootTables.BLOODSTONE_OBELISK_CHEST, (BlockState)blockState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(switch (metadata) {
                    default -> Direction.NORTH;
                    case "ChestEast" -> Direction.EAST;
                    case "ChestSouth" -> Direction.SOUTH;
                    case "ChestWest" -> Direction.WEST;
                })));
            } else {
                ArrayList list = Lists.newArrayList();
                switch (metadata) {
                    case "PIGLIN_BRUTE": {
                        list.add((Mob)EntityType.f_20512_.m_20615_((Level)world.m_6018_()));
                        break;
                    }
                    case "PIGLIN": {
                        list.add((Mob)EntityType.f_20511_.m_20615_((Level)world.m_6018_()));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (Mob mob : list) {
                    if (mob == null) continue;
                    mob.m_21530_();
                    mob.m_20035_(pos, 0.0f, 0.0f);
                    mob.m_6518_(world, world.m_6436_(mob.m_20183_()), MobSpawnType.STRUCTURE, (SpawnGroupData)null, (CompoundTag)null);
                    world.m_47205_((Entity)mob);
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
    }
}

