/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.EMFModelPartWithState;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.EntityIntLRU;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartRoot
extends EMFModelPartVanilla {
    public final OptifineMobNameForFileAndEMFMapId modelName;
    public final ModelPart vanillaRoot;
    @NotNull
    public final EntityIntLRU entitySuffixMap = new EntityIntLRU();
    private final Map<String, EMFModelPartVanilla> allVanillaParts;
    private final Int2ObjectOpenHashMap<ModelPart> vanillaFormatModelPartOfEachState = new Int2ObjectOpenHashMap();
    public EMFManager.CemDirectoryApplier variantDirectoryApplier;
    public ETFApi.ETFVariantSuffixProvider variantTester = null;
    public boolean containsCustomModel = false;
    private long lastMobCountAnimatedOn = 0L;
    private boolean hasRemovedTopLevelJemTextureFromChildren = false;

    public EMFModelPartRoot(OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap, EMFManager.CemDirectoryApplier variantDirectoryApplier, ModelPart vanillaRoot, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> mapForCreatedParts) {
        super("EMF_root", vanillaRoot, optifinePartNames, mapForCreatedParts);
        this.allVanillaParts = mapForCreatedParts;
        this.allVanillaParts.put(this.name, this);
        this.modelName = mobNameForFileAndMap;
        this.variantDirectoryApplier = variantDirectoryApplier;
        this.vanillaRoot = vanillaRoot;
        this.receiveOneTimeRunnable(this::registerModelRunnableWithEntityTypeContext);
    }

    private void registerModelRunnableWithEntityTypeContext() {
        if (EMFAnimationHelper.getEMFEntity() != null) {
            String type;
            if (EMFConfig.getConfig().debugOnRightClick) {
                type = EMFAnimationHelper.getEMFEntity().emf$getTypeString();
                Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
                if (roots == null) {
                    ObjectLinkedOpenHashSet newRootSet = new ObjectLinkedOpenHashSet();
                    EMFManager.getInstance().rootPartsPerEntityTypeForDebug.put((Object)type, (Object)newRootSet);
                    newRootSet.add(this);
                } else {
                    roots.add(this);
                }
            }
            if (this.variantTester != null) {
                Set variators;
                type = EMFAnimationHelper.getEMFEntity().emf$getTypeString();
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.log("Registered new variating model for: " + type);
                }
                if ((variators = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.get((Object)type)) == null) {
                    HashSet<Runnable> newVariators = new HashSet<Runnable>();
                    EMFManager.getInstance().rootPartsPerEntityTypeForVariation.put((Object)type, newVariators);
                    newVariators.add(this::doVariantCheck);
                } else {
                    variators.add(this::doVariantCheck);
                }
            }
        }
        this.receiveOneTimeRunnable(null);
    }

    public void doVariantCheck() {
        int finalSuffix;
        UUID id = EMFAnimationHelper.getEMFEntity().etf$getUuid();
        int knownSuffix = this.entitySuffixMap.getInt((Object)id);
        if (knownSuffix != -1) {
            this.checkIfShouldExpireEntity(id);
            finalSuffix = knownSuffix;
        } else {
            int newSuffix = this.variantTester.getSuffixForETFEntity((ETFEntity)EMFAnimationHelper.getEMFEntity());
            if (newSuffix == 0) {
                this.entitySuffixMap.put(id, 1);
                finalSuffix = 1;
            } else {
                this.entitySuffixMap.put(id, newSuffix);
                finalSuffix = newSuffix;
            }
        }
        this.setVariantStateTo(finalSuffix);
    }

    public void checkIfShouldExpireEntity(UUID id) {
        if (this.variantTester.entityCanUpdate(id)) {
            switch (EMFConfig.getConfig().modelUpdateFrequency) {
                case Never: {
                    break;
                }
                case Instant: {
                    this.entitySuffixMap.removeInt((Object)id);
                    break;
                }
                default: {
                    int delay = EMFConfig.getConfig().modelUpdateFrequency.getDelay();
                    int time = (int)(EMFAnimationHelper.getTime() % (float)delay);
                    if (time != Math.abs(id.hashCode()) % delay) break;
                    this.entitySuffixMap.removeInt((Object)id);
                }
            }
        }
    }

    public void addVariantOfJem(EMFJemData jemData, int variant) {
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > " + jemData.getMobModelIDInfo().getfileName() + ", constructing variant #" + variant);
        }
        HashMap<String, EMFModelPartCustom> newEmfParts = new HashMap<String, EMFModelPartCustom>();
        for (EMFPartData eMFPartData : jemData.models) {
            if (eMFPartData.part == null) continue;
            String idUnique = EMFUtils.getIdUnique(newEmfParts.keySet(), eMFPartData.id);
            newEmfParts.put(idUnique, new EMFModelPartCustom(eMFPartData, variant, eMFPartData.part, idUnique));
        }
        for (Map.Entry entry : this.allVanillaParts.entrySet()) {
            String thisPartName = (String)entry.getKey();
            EMFModelPartVanilla thisPart = (EMFModelPartVanilla)((Object)entry.getValue());
            EMFModelPartWithState.EMFModelState vanillaState = EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)thisPart.allKnownStateVariants.get(0));
            thisPart.setFromState(vanillaState);
            if (thisPart instanceof EMFModelPartRoot) {
                EMFModelPartRoot root = (EMFModelPartRoot)thisPart;
                if (!root.f_104212_.isEmpty()) {
                    root.textureOverride = jemData.getCustomTexture();
                }
            }
            HashMap<String, EMFModelPartCustom> children = new HashMap<String, EMFModelPartCustom>();
            for (Map.Entry newPartEntry : newEmfParts.entrySet()) {
                EMFModelPartCustom newPart = (EMFModelPartCustom)((Object)newPartEntry.getValue());
                if (!thisPartName.equals(newPart.partToBeAttached)) continue;
                if (EMFConfig.getConfig().logModelCreationData) {
                    System.out.println(" > > > EMF custom part attached: " + (String)newPartEntry.getKey());
                }
                if (!newPart.attach) {
                    thisPart.f_104212_ = List.of();
                    thisPart.f_104213_.values().forEach(part -> {
                        if (part instanceof EMFModelPartVanilla) {
                            EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)((Object)part));
                            if (!vanilla.isOptiFinePartSpecified) {
                                vanilla.setHideInTheseStates(variant);
                            }
                        }
                    });
                }
                children.put(EMFUtils.getIdUnique(thisPart.f_104213_.keySet(), (String)newPartEntry.getKey()), newPart);
            }
            children.putAll(thisPart.vanillaChildren);
            thisPart.f_104213_ = children;
            thisPart.allKnownStateVariants.put(variant, (Object)thisPart.getCurrentState());
        }
        if (!this.allKnownStateVariants.containsKey(variant)) {
            this.allKnownStateVariants.put(variant, (Object)EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        }
    }

    public void discoverAndInitVariants() {
        String thisDirectoryFileName = this.variantDirectoryApplier.getThisDirectoryOfFilename(this.modelName.getfileName());
        ResourceLocation propertyID = new ResourceLocation(thisDirectoryFileName + ".properties");
        if (Minecraft.m_91087_().m_91098_().m_213713_(propertyID).isPresent()) {
            this.variantTester = ETFApi.getVariantSupplierOrNull((ResourceLocation)propertyID, (ResourceLocation)new ResourceLocation(thisDirectoryFileName + ".jem"), (String[])new String[]{"models"});
            if (this.variantTester != null) {
                IntOpenHashSet allModelVariants = this.variantTester.getAllSuffixes();
                allModelVariants.remove(1);
                allModelVariants.remove(0);
                if (!allModelVariants.isEmpty()) {
                    IntIterator intIterator = allModelVariants.iterator();
                    while (intIterator.hasNext()) {
                        EMFJemData jemDataVariant;
                        int variant = (Integer)intIterator.next();
                        this.setVariantStateTo(1);
                        String jemNameVariant = this.variantDirectoryApplier.getThisDirectoryOfFilename(this.modelName.getfileName() + variant + ".jem");
                        if (EMFConfig.getConfig().logModelCreationData) {
                            EMFUtils.log(" > incorporating variant jem file: " + jemNameVariant);
                        }
                        if ((jemDataVariant = EMFManager.getJemDataWithDirectory(jemNameVariant, this.modelName)) != null) {
                            this.addVariantOfJem(jemDataVariant, variant);
                            this.setVariantStateTo(variant);
                            EMFManager.getInstance().setupAnimationsFromJemToModel(jemDataVariant, this, variant);
                            this.containsCustomModel = true;
                            continue;
                        }
                        this.allKnownStateVariants.put(variant, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(1)));
                        if (!EMFConfig.getConfig().logModelCreationData) continue;
                        EMFUtils.log(" > invalid jem variant file: " + jemNameVariant);
                    }
                } else {
                    EMFUtils.logWarn("properties with only 1 variant found: " + propertyID + "\n please check this is correct.");
                }
            } else {
                EMFUtils.logWarn("null properties found for: " + propertyID);
                this.variantDirectoryApplier = null;
            }
        } else {
            EMFUtils.logWarn("no properties or variants found for found for: " + thisDirectoryFileName + ".jem");
            this.variantDirectoryApplier = null;
        }
    }

    public void setVariant1ToVanilla0() {
        this.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        this.allVanillaParts.forEach((k, child) -> child.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)child.allKnownStateVariants.get(0))));
    }

    public void tryRenderVanillaRootNormally(PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        if (this.vanillaRoot != null) {
            matrixStack.m_85836_();
            if (EMFConfig.getConfig().vanillaModelHologramRenderMode == EMFConfig.VanillaModelRenderMode.Positon_offset) {
                matrixStack.m_252880_(1.0f, 0.0f, 0.0f);
            }
            this.vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 0.5f, 0.5f, 0.5f);
            matrixStack.m_85849_();
        }
    }

    public void tryRenderVanillaFormatRoot(PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        if (EMFConfig.getConfig().attemptPhysicsModPatch_2 == EMFConfig.PhysicsModCompatChoice.VANILLA) {
            if (this.vanillaRoot != null) {
                this.vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            ModelPart vanillaFormat = this.getVanillaFormatRoot();
            if (vanillaFormat != null) {
                vanillaFormat.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public ModelPart getVanillaFormatRoot() {
        if (!this.vanillaFormatModelPartOfEachState.containsKey(this.currentModelVariant)) {
            this.vanillaFormatModelPartOfEachState.put(this.currentModelVariant, (Object)this.getVanillaModelPartsOfCurrentState());
        }
        return (ModelPart)this.vanillaFormatModelPartOfEachState.get(this.currentModelVariant);
    }

    public void receiveAnimations(int variant, Collection<EMFAnimation> animationList) {
        if (!animationList.isEmpty()) {
            Runnable run = () -> {
                if (this.lastMobCountAnimatedOn != EMFManager.getInstance().entityRenderCount) {
                    this.lastMobCountAnimatedOn = EMFManager.getInstance().entityRenderCount;
                    animationList.forEach(EMFAnimation::calculateAndSet);
                }
            };
            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, run));
        }
    }

    public ResourceLocation getTopLevelJemTexture() {
        if (this.hasRemovedTopLevelJemTextureFromChildren) {
            return this.textureOverride;
        }
        this.hasRemovedTopLevelJemTextureFromChildren = true;
        if (this.textureOverride != null) {
            this.allVanillaParts.values().forEach(emf -> {
                if (emf.textureOverride.equals((Object)this.textureOverride)) {
                    emf.textureOverride = null;
                }
            });
        }
        return this.textureOverride;
    }

    @Override
    public String toString() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }

    @Override
    public String toStringShort() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }
}

