/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends ModelPart {
    public ResourceLocation textureOverride;
    private long lastTextureOverride = -1L;

    public EMFModelPart(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
        this.f_104212_ = new ObjectArrayList(cuboids);
        this.f_104213_ = new Object2ObjectOpenHashMap(children);
    }

    void renderWithTextureOverride(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase() && vertices instanceof ETFVertexConsumer) {
            ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
            MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
            if (provider == null) {
                return;
            }
            RenderType originalLayer = etfVertexConsumer.etf$getRenderLayer();
            if (originalLayer == null) {
                return;
            }
            this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
            RenderType layerModified = EMFAnimationHelper.getLayerFromRecentFactoryOrTranslucent(this.textureOverride);
            VertexConsumer newConsumer = provider.m_6299_(layerModified);
            this.renderLikeVanilla(matrices, newConsumer, light, overlay, red, green, blue, alpha);
            if (newConsumer instanceof ETFVertexConsumer) {
                ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
                ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
                if (etfTexture == null) {
                    return;
                }
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha);
                ETFUtils2.renderEmissive((ETFTexture)etfTexture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
                ETFUtils2.renderEnchanted((ETFTexture)etfTexture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
            }
            provider.m_6299_(originalLayer);
        }
    }

    void renderLikeVanilla(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            matrices.m_85836_();
            this.m_104299_(matrices);
            if (!this.f_233556_) {
                this.m_104290_(matrices.m_85850_(), vertices, light, overlay, red, green, blue, alpha);
            }
            for (ModelPart modelPart : this.f_104213_.values()) {
                modelPart.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.m_85849_();
        }
    }

    void renderLikeETF(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, red, green, blue, alpha);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay;
                MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
                RenderType layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && ETFUtils2.renderEmissive((ETFTexture)texture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)(renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha))) | ETFUtils2.renderEnchanted((ETFTexture)texture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay)) {
                    provider.m_6299_(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(PoseStack matrices, VertexConsumer vertices) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            matrices.m_85836_();
            this.m_104299_(matrices);
            if (!this.f_233556_) {
                for (ModelPart.Cube cuboid : this.f_104212_) {
                    AABB box = new AABB((double)(cuboid.f_104335_ / 16.0f), (double)(cuboid.f_104336_ / 16.0f), (double)(cuboid.f_104337_ / 16.0f), (double)(cuboid.f_104338_ / 16.0f), (double)(cuboid.f_104339_ / 16.0f), (double)(cuboid.f_104340_ / 16.0f));
                    LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)vertices, (AABB)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            for (ModelPart modelPart : this.f_104213_.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.m_85849_();
        }
    }

    protected void m_104290_(PoseStack.Pose entry, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (ModelPart.Cube cuboid : this.f_104212_) {
            cuboid.m_171332_(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (ModelPart child : this.f_104213_.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public ModelPart getVanillaModelPartsOfCurrentState() {
        HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
        for (Map.Entry child : this.f_104213_.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<ModelPart.Cube> cubes = this.f_104212_.isEmpty() ? List.of(new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.f_104212_;
        ModelPart part = new ModelPart((List)cubes, children);
        part.m_233560_(this.m_233566_());
        part.f_104203_ = this.f_104203_;
        part.f_104205_ = this.f_104205_;
        part.f_104204_ = this.f_104204_;
        part.f_104202_ = this.f_104202_;
        part.f_104201_ = this.f_104201_;
        part.f_104200_ = this.f_104200_;
        part.f_233553_ = this.f_233553_;
        part.f_233554_ = this.f_233554_;
        part.f_233555_ = this.f_233555_;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (ModelPart part : this.f_104213_.values()) {
            boolean addThis;
            String thisKey;
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart part3 = (EMFModelPart)part;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partc = (EMFModelPartCustom)part;
                thisKey = partc.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partv = (EMFModelPartVanilla)part;
                thisKey = partv.name;
                addThis = partv.isOptiFinePartSpecified;
            } else {
                thisKey = "NULL_KEY_NAME";
                addThis = false;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.put((Object)thisKey, (Object)part3);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.put((Object)(prefixableParents + ":" + thisKey), (Object)part3);
                mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

