/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.inventory;

import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.arbor.extrasounds.misc.SoundManager;
import org.arbor.extrasounds.sounds.SoundType;
import org.arbor.extrasounds.sounds.Sounds;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Unique
    private static final CreativeModeTab GROUP_INVENTORY = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_257039_);
    @Shadow
    private static CreativeModeTab f_98507_;
    @Shadow
    @Nullable
    private Slot f_98512_;

    @Shadow
    protected abstract boolean m_98562_(CreativeModeTab var1, double var2, double var4);

    @Shadow
    protected abstract boolean m_98553_(@Nullable Slot var1);

    public CreativeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void extrasounds$creativeInventoryClickEvent(@Nullable Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        boolean bOnHotbar;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        boolean bl = bOnHotbar = slot != null && !this.m_98553_(slot);
        if (actionType == ClickType.THROW && slot != null && slotId >= 0) {
            ItemStack slotStack = slot.m_7993_().m_41777_();
            if (button == 1 && f_98507_ != GROUP_INVENTORY) {
                if (bOnHotbar) {
                    SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
                    return;
                }
                slotStack.m_41764_(slotStack.m_41741_());
            } else if (button == 0) {
                slotStack.m_41764_(1);
            }
            SoundManager.playThrow(slotStack);
            return;
        }
        if (actionType == ClickType.QUICK_MOVE && f_98507_ != GROUP_INVENTORY && bOnHotbar && slot.m_6657_()) {
            SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
            return;
        }
        ItemStack cursorStack = ((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).m_142621_().m_41777_();
        if (!cursorStack.m_41619_()) {
            if (this.f_98512_ != null && slot == this.f_98512_) {
                SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
                return;
            }
            if (slotId > 0 && actionType != ClickType.QUICK_CRAFT && actionType != ClickType.PICKUP_ALL && !bOnHotbar) {
                SoundManager.playSound(cursorStack, SoundType.PLACE);
                return;
            }
        }
        SoundManager.handleInventorySlot((Player)this.f_96541_.f_91074_, slot, slotId, cursorStack, actionType, button);
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    private void extrasounds$tabChange(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        double screenX = mouseX - (double)this.f_97735_;
        double screenY = mouseY - (double)this.f_97736_;
        for (CreativeModeTab itemGroup : CreativeModeTabs.m_257388_()) {
            if (!this.m_98562_(itemGroup, screenX, screenY) || f_98507_ == itemGroup) continue;
            SoundManager.playSound(itemGroup.m_40787_(), SoundType.PICKUP);
            return;
        }
    }
}

