/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.generate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMStructures;

public class FillBookshelvesProcessor
extends StructureProcessor {
    public static final Codec<FillBookshelvesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("replace_chance").forGetter(c -> Float.valueOf(c.replace_chance)), (App)Codec.FLOAT.fieldOf("fill_chance").forGetter(c -> Float.valueOf(c.fill_chance)), (App)Codec.FLOAT.fieldOf("enchant_chance").forGetter(c -> Float.valueOf(c.enchant_chance)), (App)IntProvider.m_146545_((int)0, (int)6).fieldOf("book_amount").forGetter(c -> c.book_amount), (App)IntProvider.m_146545_((int)0, (int)100).fieldOf("enchantment_level").forGetter(c -> c.enchantment_level)).apply((Applicative)instance, FillBookshelvesProcessor::new));
    private static final Direction[] CHECK_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
    private final float replace_chance;
    private final float fill_chance;
    private final float enchant_chance;
    private final IntProvider book_amount;
    private final IntProvider enchantment_level;

    public FillBookshelvesProcessor(float replace_chance, float fill_chance, float enchant_chance, IntProvider book_amount, IntProvider enchantment_level) {
        this.replace_chance = replace_chance;
        this.fill_chance = fill_chance;
        this.enchant_chance = enchant_chance;
        this.book_amount = book_amount;
        this.enchantment_level = enchantment_level;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo input, StructurePlaceSettings settings) {
        BlockState blockState = input.f_74676_();
        if (blockState.m_60713_(Blocks.f_244299_)) {
            BlockPos pos = input.f_74675_();
            RandomSource randomSource = settings.m_230326_(pos);
            if (randomSource.m_188501_() < this.replace_chance) {
                return new StructureTemplate.StructureBlockInfo(pos, Blocks.f_50078_.m_49966_(), null);
            }
            if (randomSource.m_188501_() > this.fill_chance) {
                return new StructureTemplate.StructureBlockInfo(pos, blockState, input.f_74677_());
            }
            NonNullList items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.book_amount.m_214085_(randomSource); ++i) {
                ItemStack book = new ItemStack((ItemLike)Items.f_42517_);
                if (randomSource.m_188501_() < this.enchant_chance) {
                    book = EnchantmentHelper.m_220292_((RandomSource)randomSource, (ItemStack)book, (int)this.enchantment_level.m_214085_(randomSource), (boolean)true);
                }
                int index = randomSource.m_188503_(items.size());
                items.set(index, (Object)book);
                blockState = (BlockState)blockState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(index), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag tags = new CompoundTag();
            ContainerHelper.m_18976_((CompoundTag)tags, (NonNullList)items, (boolean)true);
            return new StructureTemplate.StructureBlockInfo(pos, blockState, tags);
        }
        return input;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)BMStructures.FILL_BOOKSHELVES.get();
    }
}

