/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import party.lemons.biomemakeover.level.feature.mansion.MansionDetails;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplateType;
import party.lemons.biomemakeover.level.feature.mansion.MansionTemplates;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.NonRoofedMansionRoom;
import party.lemons.taniwha.util.collections.Grid;

public class RoofMansionRoom
extends NonRoofedMansionRoom {
    public RoofMansionRoom(BlockPos position) {
        super(position, RoomType.ROOF);
    }

    @Override
    public int getSortValue() {
        return -4 + this.getLayout().doorCount();
    }

    @Override
    public void addWalls(MansionDetails details, MansionTemplates templates, RandomSource random, BlockPos wallPos, StructureTemplateManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        if (this.isRoofConnected(Direction.NORTH, roomGrid)) {
            children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getRoofSplit(templates, random).toString(), wallPos.m_121945_(Direction.NORTH).m_7918_(-2, 0, 0), Rotation.NONE, this.getPosition().m_123342_() == 0, true));
        }
        if (this.isRoofConnected(Direction.WEST, roomGrid)) {
            children.m_142679_((StructurePiece)new MansionFeature.Piece(details, manager, this.getRoofSplit(templates, random).toString(), wallPos.m_121945_(Direction.WEST).m_7918_(0, 0, -2), Rotation.CLOCKWISE_90, this.getPosition().m_123342_() == 0, true));
        }
    }

    private ResourceLocation getRoofSplit(MansionTemplates templates, RandomSource random) {
        return MansionTemplateType.ROOF_SPLIT.getRandomTemplate(templates, random);
    }

    @Override
    public BlockPos getOffsetForRotation(BlockPos offsetPos, Rotation rotation) {
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return offsetPos.m_7918_(12, 0, 10);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return offsetPos.m_7918_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_7918_(10, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(0, 0, 12);
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return offsetPos.m_7918_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_7918_(-2, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(12, 0, -2);
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(0, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_7918_(-2, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(12, 0, 12);
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(12, 0, 10);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return offsetPos.m_7918_(-2, 0, 0);
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(0, 0, 12);
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return offsetPos.m_7918_(10, 0, -2);
                }
            }
            case 4: {
                return offsetPos.m_7918_(0, 0, 0);
            }
            case 0: {
                return offsetPos.m_7918_(-2, 0, -2);
            }
        }
        return offsetPos;
    }

    @Override
    public ResourceLocation getTemplate(MansionTemplates templates, RandomSource random) {
        List<ResourceLocation> ids = switch (this.layout.doorCount()) {
            case 0 -> MansionTemplateType.ROOF_0.getTemplates(templates);
            case 1 -> MansionTemplateType.ROOF_1.getTemplates(templates);
            case 2 -> {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() || ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    yield MansionTemplateType.ROOF_2_STRAIGHT.getTemplates(templates);
                }
                yield MansionTemplateType.ROOF_2.getTemplates(templates);
            }
            case 3 -> MansionTemplateType.ROOF_3.getTemplates(templates);
            case 4 -> MansionTemplateType.ROOF_4.getTemplates(templates);
            default -> MansionTemplateType.INNER_WALL.getTemplates(templates);
        };
        return ids.get(random.m_188503_(ids.size()));
    }

    @Override
    public Rotation getRotation(RandomSource random) {
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.NORTH)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_180;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue()) {
                    return Rotation.NONE;
                }
                if (((Boolean)this.layout.get(Direction.NORTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                if (((Boolean)this.layout.get(Direction.SOUTH)).booleanValue() && ((Boolean)this.layout.get(Direction.EAST)).booleanValue() && ((Boolean)this.layout.get(Direction.WEST)).booleanValue()) {
                    return Rotation.CLOCKWISE_90;
                }
            }
            case 4: {
                return Rotation.NONE;
            }
            case 0: {
                return Rotation.NONE;
            }
        }
        return null;
    }

    @Override
    public void setLayout(MansionLayout layout, RandomSource random) {
        Grid<MansionRoom> lo = layout.getLayout();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            MansionRoom neighbour = (MansionRoom)lo.get(this.getPosition().m_121945_(dir));
            if (neighbour == null || neighbour.getRoomType() != RoomType.ROOF && !neighbour.getRoomType().hasWalls()) continue;
            this.getLayout().put(dir, true);
        }
    }

    public boolean isRoofConnected(Direction direction, Grid<MansionRoom> roomGrid) {
        return (Boolean)this.layout.get(direction) != false && ((MansionRoom)roomGrid.get(this.getPosition().m_121945_(direction))).getRoomType() == RoomType.ROOF;
    }
}

