/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import party.lemons.biomemakeover.BMConfig;
import party.lemons.biomemakeover.init.BMEnchantments;
import party.lemons.biomemakeover.util.RandomUtil;

public class Cursing {
    private static final List<Enchantment> curses = Lists.newArrayList();

    public static boolean isValidForCurse(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() == Items.f_42690_) {
            return false;
        }
        if (stack.m_41720_() == Items.f_42517_) {
            return true;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.isEmpty() || stack.m_41782_() && stack.m_41783_().m_128441_("BMCursed")) {
            return false;
        }
        boolean hasNewCompatibleCurse = false;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!(BuiltInRegistries.f_256876_.m_263177_((Object)enchantment).m_203656_(BMEnchantments.ALTAR_CANT_UPGRADE) || enchantment.m_6586_() <= 1 || enchantment.m_6589_() || BMConfig.INSTANCE.strictAltarCursing && (Integer)enchantments.get(enchantment) >= enchantment.m_6586_() + 1)) {
                return true;
            }
            if (!enchantment.m_6589_() || !enchantment.m_6081_(stack) || enchantments.containsKey(enchantment)) continue;
            hasNewCompatibleCurse = true;
        }
        return hasNewCompatibleCurse;
    }

    public static Enchantment getRandomCurse(RegistryAccess registryAccess, RandomSource random) {
        if (curses.isEmpty()) {
            curses.addAll(registryAccess.m_175515_(Registries.f_256762_).m_123024_().filter(e -> e.m_6589_() && !BuiltInRegistries.f_256876_.m_263177_(e).m_203656_(BMEnchantments.ALTAR_CURSE_EXCLUDED)).toList());
        }
        if (curses.isEmpty()) {
            return null;
        }
        return curses.get(random.m_188503_(curses.size()));
    }

    public static ItemStack curseItemStack(Level level, ItemStack stack, RandomSource random) {
        if (Cursing.isValidForCurse(stack)) {
            if (stack.m_41720_() == Items.f_42517_) {
                ItemStack newStack = new ItemStack((ItemLike)Items.f_42690_);
                Enchantment curse = Cursing.getRandomCurse(level.m_9598_(), level.f_46441_);
                if (curse == null) {
                    return ItemStack.f_41583_;
                }
                EnchantedBookItem.m_41153_((ItemStack)newStack, (EnchantmentInstance)new EnchantmentInstance(curse, 1));
                return newStack;
            }
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            List<Enchantment> validEnchants = enchantments.keySet().stream().filter(e -> !BuiltInRegistries.f_256876_.m_263177_(e).m_203656_(BMEnchantments.ALTAR_CANT_UPGRADE) && e.m_6586_() > 1 && !e.m_6589_() && (!BMConfig.INSTANCE.strictAltarCursing || (Integer)enchantments.get(e) < e.m_6586_() + 1)).toList();
            Enchantment toUpgrade = validEnchants.get(random.m_188503_(validEnchants.size()));
            enchantments.put(toUpgrade, (Integer)enchantments.get(toUpgrade) + 1);
            Enchantment curse = Cursing.getRandomCurse(level.m_9598_(), random);
            if (curse == null) {
                return ItemStack.f_41583_;
            }
            int attempts = 0;
            while (enchantments.containsKey(curse) || !curse.m_6081_(stack)) {
                curse = Cursing.getRandomCurse(level.m_9598_(), random);
                if (curse == null) {
                    return ItemStack.f_41583_;
                }
                if (++attempts < 100) continue;
                curse = null;
                break;
            }
            if (curse == null) {
                for (Enchantment enchantment : level.m_9598_().m_175515_(Registries.f_256762_).m_123024_().sorted((e, e1) -> RandomUtil.randomRange(-1, 1)).collect(Collectors.toList())) {
                    if (!enchantment.m_6589_() || !enchantment.m_6081_(stack) || enchantments.containsKey(enchantment)) continue;
                    curse = enchantment;
                }
            }
            if (curse == null) {
                return ItemStack.f_41583_;
            }
            int curseLevel = curse.m_6586_() == 1 ? 1 : RandomUtil.randomRange(curse.m_44702_(), curse.m_6586_());
            enchantments.put(curse, curseLevel);
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("BMCursed", true);
            stack.m_41751_(tag);
            stack.m_41742_(39);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

