/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.HelmitCrabEntity;
import party.lemons.biomemakeover.entity.render.HatModels;
import party.lemons.biomemakeover.entity.render.HelmitCrabModel;
import party.lemons.biomemakeover.entity.render.forge.HelmitCrabRenderHelmitCrabShellRenderLayerImpl;

public class HelmitCrabRender
extends MobRenderer<HelmitCrabEntity, HelmitCrabModel> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/helmit_crab/helmit_crab.png");

    public HelmitCrabRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HelmitCrabModel(context.m_174023_(HelmitCrabModel.LAYER_LOCATION)), 0.25f);
        this.m_115326_(new HelmitCrabShellRenderLayer(context, this));
    }

    protected void setupRotations(HelmitCrabEntity livingEntity, PoseStack poseStack, float f, float g, float h) {
        if (livingEntity.isHiding()) {
            poseStack.m_252880_(0.0f, -0.05f, 0.0f);
        }
        super.m_7523_((LivingEntity)livingEntity, poseStack, f, g, h);
    }

    public void render(HelmitCrabEntity mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        ((HelmitCrabModel)this.m_7200_()).shell.f_104207_ = mob.getShellItemStack().m_41720_() == Items.f_42715_;
        this.f_114477_ = 0.25f;
        poseStack.m_85836_();
        if (mob.m_6162_()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.f_114477_ = 0.1f;
        }
        super.m_7392_((Mob)mob, f, g, poseStack, multiBufferSource, i);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(HelmitCrabEntity entity) {
        return TEXTURE;
    }

    public static void renderTrim(ArmorMaterial arg, PoseStack arg2, MultiBufferSource arg3, int i, ArmorTrim arg4, Model arg5, boolean bl) {
        TextureAtlasSprite textureatlassprite = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_).m_118316_(bl ? arg4.m_267774_(arg) : arg4.m_267606_(arg));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(arg3.m_6299_(Sheets.m_266442_()));
        arg5.m_7695_(arg2, vertexconsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private class HelmitCrabShellRenderLayer
    extends RenderLayer<HelmitCrabEntity, HelmitCrabModel> {
        private final HumanoidModel BIPED_MODEL;
        private final HelmitCrabModel CRAB_MODEL;
        private final ItemInHandRenderer itemInHandRenderer;
        private final EntityRendererProvider.Context context;
        private final Map<SkullBlock.Type, SkullModelBase> skullModels;
        private static final ResourceLocation SHULKER_TEXTURE = BiomeMakeover.ID("textures/entity/helmit_crab/shulker.png");

        public HelmitCrabShellRenderLayer(EntityRendererProvider.Context context, HelmitCrabRender helmitCrabRender2) {
            super((RenderLayerParent)helmitCrabRender2);
            this.context = context;
            this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)context.m_174027_());
            this.BIPED_MODEL = new HumanoidModel(context.m_174023_(ModelLayers.f_171164_));
            this.CRAB_MODEL = new HelmitCrabModel(context.m_174023_(HelmitCrabModel.LAYER_LOCATION));
            this.BIPED_MODEL.f_102812_.f_104207_ = false;
            this.BIPED_MODEL.f_102811_.f_104207_ = false;
            this.BIPED_MODEL.f_102814_.f_104207_ = false;
            this.BIPED_MODEL.f_102813_.f_104207_ = false;
            this.BIPED_MODEL.f_102810_.f_104207_ = false;
            this.BIPED_MODEL.f_102808_.f_104207_ = true;
            this.BIPED_MODEL.f_102809_.f_104207_ = true;
            this.itemInHandRenderer = context.m_234598_();
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, HelmitCrabEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
            ((HelmitCrabModel)HelmitCrabRender.this.m_7200_()).shell.f_104207_ = false;
            ItemStack shell = entity.getShellItemStack();
            if (shell.m_41619_()) {
                return;
            }
            if (shell.m_41720_() == Items.f_42715_) {
                ((HelmitCrabModel)HelmitCrabRender.this.m_7200_()).shell.f_104207_ = true;
            } else if (shell.m_41720_() == Items.f_42748_) {
                this.renderSpecialShell(SHULKER_TEXTURE, entity, poseStack, multiBufferSource, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
            } else if (shell.m_41720_() instanceof ArmorItem) {
                this.renderHelmet(entity, shell, poseStack, multiBufferSource, light);
            } else if (shell.m_41720_() instanceof BlockItem && ((BlockItem)shell.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
                this.renderSkull(shell, poseStack, multiBufferSource, light, limbAngle);
            } else {
                this.renderHeadItem(entity, shell, poseStack, multiBufferSource, light);
            }
        }

        private void renderHeadItem(HelmitCrabEntity crab, ItemStack shell, PoseStack poseStack, MultiBufferSource mbSource, int light) {
            float scale = 0.5f;
            poseStack.m_252880_(0.0f, 1.15f, 0.1f);
            poseStack.m_85841_(scale, -scale, -scale);
            this.itemInHandRenderer.m_269530_((LivingEntity)crab, shell, ItemDisplayContext.HEAD, false, poseStack, mbSource, light);
        }

        private void renderSkull(ItemStack shell, PoseStack poseStack, MultiBufferSource mbSource, int light, float limbAngle) {
            CompoundTag compoundTag;
            float scale = 1.0f;
            if (shell.m_41720_() == Items.f_42683_) {
                scale = 0.6f;
                poseStack.m_85837_(0.0, (double)0.6f, -0.07);
            }
            poseStack.m_85841_(scale, -scale, scale);
            poseStack.m_252880_(0.0f, -1.4f, 0.1f);
            GameProfile gameProfile = null;
            if (shell.m_41782_() && (compoundTag = shell.m_41783_()).m_128425_("SkullOwner", 10)) {
                gameProfile = NbtUtils.m_129228_((CompoundTag)compoundTag.m_128469_("SkullOwner"));
            }
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            SkullBlock.Type type = ((AbstractSkullBlock)((BlockItem)shell.m_41720_()).m_40614_()).m_48754_();
            SkullModelBase skullModelBase = this.skullModels.get(type);
            RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)gameProfile);
            SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)limbAngle, (PoseStack)poseStack, (MultiBufferSource)mbSource, (int)light, (SkullModelBase)skullModelBase, (RenderType)renderType);
        }

        private void renderSpecialShell(ResourceLocation texture, HelmitCrabEntity crab, PoseStack poseStack, MultiBufferSource mbSource, int light, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
            HelmitCrabShellRenderLayer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)this.CRAB_MODEL, (ResourceLocation)texture, (PoseStack)poseStack, (MultiBufferSource)mbSource, (int)light, (LivingEntity)crab, (float)limbAngle, (float)limbDistance, (float)tickDelta, (float)animationProgress, (float)headYaw, (float)headPitch, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public Model getHatModel(ItemStack stack) {
            return HatModels.getHatModel(stack.m_41720_(), this.BIPED_MODEL.m_5585_());
        }

        private void renderHelmet(HelmitCrabEntity entity, ItemStack stack, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
            this.BIPED_MODEL.m_8009_(false);
            this.BIPED_MODEL.f_102808_.f_104207_ = true;
            this.BIPED_MODEL.f_102809_.f_104207_ = true;
            HelmitCrabShellRenderLayer.renderHelmetPlatform(entity, stack, matrices, vertexConsumers, light, this.BIPED_MODEL);
        }

        /*
         * WARNING - void declaration
         */
        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static void renderHelmetPlatform(HelmitCrabEntity entity, ItemStack stack, PoseStack matrices, MultiBufferSource vertexConsumers, int light, HumanoidModel BIPED_MODEL) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            HelmitCrabRenderHelmitCrabShellRenderLayerImpl.renderHelmetPlatform(entity, (ItemStack)var1_1, (PoseStack)var2_2, (MultiBufferSource)var3_3, (int)var4_4, (HumanoidModel)var5_5);
        }
    }
}

