/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.AttackingPhase;
import party.lemons.biomemakeover.entity.ai.NonMovingBowAttackGoal;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.util.extension.LootBlocker;

public class StoneGolemPhase
extends AttackingPhase {
    public StoneGolemPhase(ResourceLocation phaseID, AdjudicatorEntity adjudicator) {
        super(phaseID, adjudicator);
    }

    @Override
    protected void initAI() {
        this.goalSelector.m_25352_(2, this.getAttackGoal());
        this.goalSelector.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this.adjudicator, Player.class, 20.0f));
        this.goalSelector.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this.adjudicator));
        this.targetSelector.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this.adjudicator, new Class[0]));
        this.targetSelector.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this.adjudicator, Player.class, false));
        this.targetSelector.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this.adjudicator, AbstractGolem.class, false));
    }

    @Override
    protected Goal getAttackGoal() {
        return new NonMovingBowAttackGoal<AdjudicatorEntity>(this.adjudicator, 12, 30.0f);
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.adjudicator.setState(AdjudicatorState.FIGHTING);
        StoneGolemEntity golem = (StoneGolemEntity)((EntityType)BMEntities.STONE_GOLEM.get()).m_20615_(this.level);
        ((LootBlocker)((Object)golem)).setLootBlocked(true);
        golem.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42717_));
        golem.m_7678_(this.adjudicator.m_20185_(), this.adjudicator.m_20186_(), this.adjudicator.m_20189_(), this.adjudicator.m_146908_(), this.adjudicator.m_146909_());
        this.level.m_7967_((Entity)golem);
        this.adjudicator.m_7998_((Entity)golem, true);
        this.adjudicator.clearArea((Entity)golem);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42411_);
        stack.m_41663_(Enchantments.f_44989_, 1);
        this.adjudicator.m_21008_(InteractionHand.MAIN_HAND, stack);
        this.adjudicator.m_5496_(BMEffects.ADJUDICATOR_SPELL_GRUNT.get(), 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.adjudicator.selectTarget(Player.class);
    }

    @Override
    public void onExitPhase() {
        this.adjudicator.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        Entity entity = this.adjudicator.m_20202_();
        if (entity instanceof StoneGolemEntity) {
            StoneGolemEntity golem = (StoneGolemEntity)entity;
            this.adjudicator.m_8127_();
            golem.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public boolean isPhaseOver() {
        return !this.adjudicator.m_20159_();
    }

    @Override
    public CompoundTag toTag() {
        return new CompoundTag();
    }

    @Override
    public void fromTag(CompoundTag tag) {
    }

    @Override
    public BlockPos getStartPosition() {
        return this.adjudicator.getHomePosition();
    }

    @Override
    public boolean isInvulnerable() {
        return true;
    }
}

