/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorMimicEntity;
import party.lemons.biomemakeover.entity.adjudicator.phase.BowAttackingPhase;
import party.lemons.biomemakeover.entity.event.EntityEvent;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.extension.LootBlocker;

public class MimicPhase
extends BowAttackingPhase {
    private boolean hit = false;

    public MimicPhase(ResourceLocation phaseID, AdjudicatorEntity adjudicator) {
        super(phaseID, adjudicator);
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        ArrayList setPositions = Lists.newArrayList();
        int mimicCount = RandomUtil.randomRange(3, 6);
        for (int i = 0; i < mimicCount; ++i) {
            BlockPos spawnPos;
            while (setPositions.contains(spawnPos = this.adjudicator.findSuitableArenaPos())) {
            }
            setPositions.add(spawnPos);
            if (this.level.m_8055_(spawnPos.m_7495_()).m_60795_()) {
                this.level.m_7731_(spawnPos.m_7495_(), Blocks.f_50652_.m_49966_(), 3);
            }
            AdjudicatorMimicEntity mimic = (AdjudicatorMimicEntity)((EntityType)BMEntities.ADJUDICATOR_MIMIC.get()).m_20615_(this.level);
            ((LootBlocker)((Object)mimic)).setLootBlocked(true);
            mimic.m_6518_((ServerLevelAccessor)this.level, this.level.m_6436_(spawnPos), MobSpawnType.NATURAL, null, null);
            mimic.m_7678_((float)spawnPos.m_123341_() + 0.5f, spawnPos.m_123342_(), (float)spawnPos.m_123343_() + 0.5f, 0.0f, 0.0f);
            this.level.m_7967_((Entity)mimic);
            this.adjudicator.clearArea((Entity)mimic);
            this.adjudicator.broadcastEvent((Entity)mimic, EntityEvent.ENDER_PARTICLES);
        }
        this.adjudicator.broadcastEvent((Entity)this.adjudicator, EntityEvent.ENDER_PARTICLES);
    }

    @Override
    public void onExitPhase() {
        super.onExitPhase();
        this.hit = false;
        this.level.m_6443_(AdjudicatorMimicEntity.class, this.adjudicator.getArenaBounds(), e -> true).forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
    }

    @Override
    public boolean isPhaseOver() {
        return this.hit;
    }

    @Override
    public void onHurt(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            this.hit = true;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Hit", this.hit);
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag) {
        this.hit = tag.m_128471_("Hit");
    }
}

