/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.taniwha.entity.ai.TagTemptGoal;
import party.lemons.taniwha.util.ItemUtil;

public class ScuttlerEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> RATTLING = SynchedEntityData.m_135353_(ScuttlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(ScuttlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PASSIVE = SynchedEntityData.m_135353_(ScuttlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final ResourceLocation EAT_LOOT_TABLE = BiomeMakeover.ID("gameplay/scuttler_eating");
    private static final int FIND_EAT_TARGET_COOLDOWN_MAX = 300;
    public float rattleTime = 0.0f;
    private int eatCooldown = 100;
    public int eatTime = 0;
    private BlockPos eatTarget = null;
    private int findEatTargetCooldown = -69;

    public ScuttlerEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        if (this.findEatTargetCooldown == -69) {
            this.findEatTargetCooldown = this.m_217043_().m_216339_(0, 300);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TagTemptGoal((PathfinderMob)this, BMItems.SCUTTLER_FOOD, 0.7, false));
        this.f_21345_.m_25352_(2, new RattleGoal<Player>(this, 20.0f, Player.class));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, livingEntity -> !this.isPassive()));
        this.f_21345_.m_25352_(6, (Goal)new EatFlowerGoal());
        this.f_21345_.m_25352_(7, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(8, (Goal)new FindFlowerGoal());
        this.f_21345_.m_25352_(9, (Goal)new AvoidDaylightGoal(1.0));
        this.f_21345_.m_25352_(10, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ScuttlerEntity.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RATTLING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(PASSIVE, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.findEatTargetCooldown > 0) {
            --this.findEatTargetCooldown;
        }
        --this.eatCooldown;
        if (((Boolean)this.m_20088_().m_135370_(EATING)).booleanValue()) {
            --this.eatTime;
        }
        if (((Boolean)this.f_19804_.m_135370_(RATTLING)).booleanValue()) {
            double dir = Math.signum(Math.sin(this.rattleTime));
            this.rattleTime += 1.0f;
            if (dir != Math.signum(Math.sin(this.rattleTime))) {
                this.m_5496_(BMEffects.SCUTTLER_RATTLE.get(), 0.25f, 0.75f + this.f_19796_.m_188501_());
            }
        } else {
            this.rattleTime = 0.0f;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_6898_(itemStack)) {
                return InteractionResult.SUCCESS;
            }
        } else if (((Boolean)this.f_19804_.m_135370_(PASSIVE)).booleanValue()) {
            if (item.m_41473_() != null && this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                this.m_5584_(this.m_9236_(), itemStack);
                this.m_5634_(item.m_41473_().m_38744_());
                return InteractionResult.CONSUME;
            }
        } else if (this.m_6898_(itemStack)) {
            this.m_5584_(this.m_9236_(), itemStack);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.f_19804_.m_135381_(PASSIVE, (Object)true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(BMEntities.SCUTTLER_IMMUNE_DAMAGE)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(BMItems.SCUTTLER_FOOD);
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player) && this.isPassive();
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (entityDataAccessor == RATTLING) {
            this.rattleTime = 0.0f;
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        ScuttlerEntity baby = (ScuttlerEntity)((EntityType)BMEntities.SCUTTLER.get()).m_20615_((Level)serverLevel);
        baby.setPassive(true);
        return baby;
    }

    public boolean isPassive() {
        return (Boolean)this.f_19804_.m_135370_(PASSIVE);
    }

    public void setPassive(boolean passive) {
        this.f_19804_.m_135381_(PASSIVE, (Object)passive);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Passive", this.isPassive());
        tag.m_128405_("EatCooldown", this.eatCooldown);
        tag.m_128405_("EatTargetCooldown", this.findEatTargetCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setPassive(tag.m_128471_("Passive"));
        this.eatCooldown = tag.m_128451_("EatCooldown");
        this.findEatTargetCooldown = tag.m_128451_("EatTargetCooldown");
    }

    protected void m_7355_(BlockPos blockPos, BlockState state) {
        if (!state.m_278721_()) {
            this.m_5496_(BMEffects.SCUTTLER_STEP.get(), 0.1f, 1.25f + this.f_19796_.m_188501_());
            this.m_20076_();
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BMEffects.SCUTTLER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BMEffects.SCUTTLER_HURT.get();
    }

    public int m_8100_() {
        return super.m_8100_() * 3;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.2f;
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkSpawnRules(EntityType<ScuttlerEntity> type, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return random.m_188499_() && level.m_6443_(ScuttlerEntity.class, new AABB(pos).m_82400_(50.0), e -> true).isEmpty() && ScuttlerEntity.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    private static class RattleGoal<T extends LivingEntity>
    extends Goal {
        private final ScuttlerEntity scuttler;
        private final float distance;
        private final Class<T> targetClass;
        T targetEntity;
        private final TargetingConditions withinRangePredicate;

        public RattleGoal(ScuttlerEntity scuttlerEntity, float distance, Class<T> target) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.scuttler = scuttlerEntity;
            this.distance = distance;
            this.targetClass = target;
            Predicate<LivingEntity> s = l -> true;
            this.withinRangePredicate = TargetingConditions.m_148353_().m_26883_((double)distance).m_26888_(s.and(EntitySelector.f_20406_));
        }

        public boolean m_8036_() {
            if (this.scuttler.m_20069_() || this.scuttler.isPassive()) {
                return false;
            }
            this.targetEntity = this.scuttler.m_9236_().m_45963_(this.targetClass, this.withinRangePredicate, (LivingEntity)this.scuttler, this.scuttler.m_20185_(), this.scuttler.m_20186_(), this.scuttler.m_20189_(), this.scuttler.m_20191_().m_82377_((double)this.distance, 3.0, (double)this.distance));
            if (this.targetEntity == null || !this.scuttler.m_142582_((Entity)this.targetEntity) || !this.targetEntity.m_142582_((Entity)this.scuttler)) {
                return false;
            }
            return !this.targetEntity.m_21093_(i -> i.m_204117_(BMItems.SCUTTLER_FOOD)) && this.scuttler.m_20270_((Entity)this.targetEntity) >= this.distance / 2.0f;
        }

        public boolean m_8045_() {
            if (this.targetEntity.m_21093_(i -> i.m_204117_(BMItems.SCUTTLER_FOOD))) {
                return false;
            }
            double d = this.scuttler.m_20270_((Entity)this.targetEntity);
            return d > (double)(this.distance / 2.0f) && d < (double)this.distance && this.scuttler.m_142582_((Entity)this.targetEntity) && this.targetEntity.m_142582_((Entity)this.scuttler);
        }

        public void m_8041_() {
            this.scuttler.m_20088_().m_135381_(RATTLING, (Object)false);
            super.m_8041_();
        }

        public void m_8056_() {
            this.scuttler.m_20088_().m_135381_(RATTLING, (Object)true);
            this.scuttler.m_21573_().m_26573_();
            super.m_8056_();
        }

        public void m_8037_() {
            this.scuttler.f_21365_.m_24960_(this.targetEntity, 30.0f, 30.0f);
        }
    }

    public class EatFlowerGoal
    extends Goal {
        public EatFlowerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return ScuttlerEntity.this.eatTarget != null;
        }

        public void m_8037_() {
            if (ScuttlerEntity.this.eatTarget == null) {
                return;
            }
            Vec3 targetPosition = ScuttlerEntity.this.eatTarget.m_252807_();
            double dist = ScuttlerEntity.this.m_20238_(targetPosition);
            if (!ScuttlerEntity.this.m_20183_().equals((Object)ScuttlerEntity.this.eatTarget) && dist > 0.25) {
                ScuttlerEntity.this.m_21573_().m_26519_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, (double)0.6f);
            } else {
                ScuttlerEntity.this.m_21573_().m_26573_();
            }
            ScuttlerEntity.this.m_21563_().m_24946_(targetPosition.f_82479_, targetPosition.f_82480_ - 0.25, targetPosition.f_82481_);
            if (ScuttlerEntity.this.eatTime <= 1) {
                BlockState st = ScuttlerEntity.this.m_9236_().m_8055_(ScuttlerEntity.this.eatTarget);
                if (st.m_60713_((Block)BMBlocks.BARREL_CACTUS_FLOWERED.get())) {
                    BlockState setState = ((Block)BMBlocks.BARREL_CACTUS.get()).m_49966_();
                    ScuttlerEntity.this.m_9236_().m_7696_(ScuttlerEntity.this.eatTarget, (Block)BMBlocks.BARREL_CACTUS.get(), 1, 0);
                    ScuttlerEntity.this.m_9236_().m_7731_(ScuttlerEntity.this.eatTarget, setState, 2);
                    ScuttlerEntity.this.m_9236_().m_220407_(GameEvent.f_157792_, ScuttlerEntity.this.eatTarget, GameEvent.Context.m_223722_((BlockState)setState));
                    ItemUtil.dropLootTable((Level)ScuttlerEntity.this.m_9236_(), (double)ScuttlerEntity.this.eatTarget.m_123341_(), (double)ScuttlerEntity.this.eatTarget.m_123342_(), (double)ScuttlerEntity.this.eatTarget.m_123343_(), (ResourceLocation)EAT_LOOT_TABLE);
                }
                ScuttlerEntity.this.eatTarget = null;
            }
        }

        public boolean m_8045_() {
            if (!this.m_8036_()) {
                return false;
            }
            BlockState st = ScuttlerEntity.this.m_9236_().m_8055_(ScuttlerEntity.this.eatTarget);
            return st.m_60713_((Block)BMBlocks.BARREL_CACTUS_FLOWERED.get());
        }

        public void m_8056_() {
            ScuttlerEntity.this.m_20088_().m_135381_(EATING, (Object)true);
            ScuttlerEntity.this.eatTime = 40;
        }

        public void m_8041_() {
            ScuttlerEntity.this.m_21573_().m_26573_();
            ScuttlerEntity.this.m_20088_().m_135381_(EATING, (Object)false);
        }
    }

    private class FindFlowerGoal
    extends Goal {
        private FindFlowerGoal() {
        }

        public boolean m_8036_() {
            return ScuttlerEntity.this.findEatTargetCooldown <= 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            ScuttlerEntity.this.eatTarget = this.findCactus();
            ScuttlerEntity.this.findEatTargetCooldown = 300;
        }

        private BlockPos findCactus() {
            BlockPos startPos = ScuttlerEntity.this.m_20183_();
            ArrayList spots = Lists.newArrayList();
            int range = 4;
            BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
            for (int x = startPos.m_123341_() - 4; x < startPos.m_123341_() + 4; ++x) {
                for (int z = startPos.m_123343_() - 4; z < startPos.m_123343_() + 4; ++z) {
                    m.m_122178_(x, startPos.m_123342_(), z);
                    BlockState checkState = ScuttlerEntity.this.m_9236_().m_8055_((BlockPos)m);
                    if (!checkState.m_60713_((Block)BMBlocks.BARREL_CACTUS_FLOWERED.get())) continue;
                    spots.add(new BlockPos(m.m_123341_(), m.m_123342_(), m.m_123343_()));
                }
            }
            if (spots.isEmpty()) {
                return null;
            }
            return (BlockPos)spots.get(ScuttlerEntity.this.f_19796_.m_188503_(spots.size()));
        }
    }

    class AvoidDaylightGoal
    extends FleeSunGoal {
        private int timer;

        AvoidDaylightGoal(double speed) {
            super((PathfinderMob)ScuttlerEntity.this, speed);
            this.timer = 100;
        }

        public boolean m_8036_() {
            if (this.f_25214_.m_5448_() == null) {
                if (this.timer > 0) {
                    --this.timer;
                    return false;
                }
                this.timer = 100;
                BlockPos pos = this.f_25214_.m_20183_();
                return ScuttlerEntity.this.m_9236_().m_46461_() && ScuttlerEntity.this.m_9236_().m_45527_(pos) && this.m_25226_();
            }
            return false;
        }
    }
}

