/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.AltarMenu;

public class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    private static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/gui/altar.png");
    private static final int[] GYLPH_PROGRESS = new int[]{0, 6, 11, 16, 20, 24, 29, 35, 42, 49, 54, 54, 54};
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private BookModel bookModel;
    private final Random random = new Random();
    public int ticks;
    public float nextPageAngle;
    public float pageAngle;
    public float approximatePageAngle;
    public float pageRotationSpeed;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    private ItemStack stack = ItemStack.f_41583_;

    public AltarScreen(AltarMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookModel = new BookModel(this.f_96541_.m_167973_().m_171103_(ModelLayers.f_171271_));
    }

    protected void m_7286_(GuiGraphics g, float delta, int mouseX, int mouseY) {
        Lighting.m_84930_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        g.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int progress = ((AltarMenu)this.m_6262_()).getProgress();
        float progressPerc = (float)progress / 300.0f;
        if (progress > 0) {
            int n = (int)(28.0f * (1.0f - (float)progress / 300.0f));
            if (n > 0) {
                int perc = (int)(progressPerc * 29.0f);
                g.m_280218_(TEXTURE, x + 99, y + 55 - perc, 189, 29 - perc, 9, perc);
            }
            if ((n = GYLPH_PROGRESS[progress / 2 % 13]) > 0) {
                g.m_280218_(TEXTURE, x + 68, y + 16 + 53 - n, 177, 53 - n, 12, n);
            }
        }
        int m = (int)this.f_96541_.m_91268_().m_85449_();
        RenderSystem.viewport((int)((this.f_96543_ - 320) / 2 * m), (int)((this.f_96544_ - 240) / 2 * m), (int)(320 * m), (int)(240 * m));
        Matrix4f matrix4f = new Matrix4f().translation(-0.34f, 0.23f, 0.0f).perspective(1.5707964f, 1.3333334f, 9.0f, 80.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276450_);
        g.m_280168_().m_85836_();
        g.m_280168_().m_166856_();
        g.m_280168_().m_85837_(0.0, 2.0, 1984.0);
        float scale = 5.0f;
        g.m_280168_().m_85841_(scale, scale, scale);
        g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
        g.m_280168_().m_252781_(Axis.f_252529_.m_252977_(20.0f));
        float h = Mth.m_14179_((float)delta, (float)this.pageTurningSpeed, (float)this.nextPageTurningSpeed);
        g.m_280168_().m_252880_((1.0f - h) * 0.2f, (1.0f - h) * 0.1f, (1.0f - h) * 0.25f);
        float n = -(1.0f - h) * 90.0f - 90.0f;
        g.m_280168_().m_252781_(Axis.f_252436_.m_252977_(n));
        g.m_280168_().m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float o = Mth.m_14179_((float)delta, (float)this.pageAngle, (float)this.nextPageAngle) + 0.25f;
        float p = Mth.m_14179_((float)delta, (float)this.pageAngle, (float)this.nextPageAngle) + 0.75f;
        o = (o - (float)Mth.m_14143_((float)o)) * 1.6f - 0.3f;
        p = (p - (float)Mth.m_14143_((float)p)) * 1.6f - 0.3f;
        if (o < 0.0f) {
            o = 0.0f;
        }
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (o > 1.0f) {
            o = 1.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        this.bookModel.m_102292_(0.0f, o, p, h);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.bookModel.m_103119_(BOOK_TEXTURE));
        this.bookModel.m_7695_(g.m_280168_(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        bufferSource.m_109911_();
        g.m_280168_().m_85849_();
        RenderSystem.viewport((int)0, (int)0, (int)this.f_96541_.m_91268_().m_85441_(), (int)this.f_96541_.m_91268_().m_85442_());
        RenderSystem.restoreProjectionMatrix();
        Lighting.m_84931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.m_280273_(matrices);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        this.m_280072_(matrices, mouseX, mouseY);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.doTick();
    }

    public void doTick() {
        boolean bl;
        ItemStack itemStack = ((AltarMenu)this.m_6262_()).m_38853_(0).m_7993_();
        if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.stack)) {
            this.stack = itemStack;
            do {
                this.approximatePageAngle += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.nextPageAngle <= this.approximatePageAngle + 1.0f && this.nextPageAngle >= this.approximatePageAngle - 1.0f);
        }
        ++this.ticks;
        this.pageAngle = this.nextPageAngle;
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        boolean bl2 = bl = ((AltarMenu)this.m_6262_()).getProgress() > 0;
        this.nextPageTurningSpeed = bl ? (this.nextPageTurningSpeed += 0.2f) : (this.nextPageTurningSpeed -= 0.2f);
        this.nextPageTurningSpeed = Mth.m_14036_((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        float f = (this.approximatePageAngle - this.nextPageAngle) * 0.4f;
        float range = 0.2f;
        f = Mth.m_14036_((float)f, (float)(-range), (float)range);
        this.pageRotationSpeed += (f - this.pageRotationSpeed) * 0.9f;
        this.nextPageAngle += this.pageRotationSpeed;
    }
}

