/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;

@IRecipeHandler.For(value=StonecutterRecipe.class)
public final class StoneCutterRecipeHandler
implements IRecipeHandler<StonecutterRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super StonecutterRecipe> manager, StonecutterRecipe recipe) {
        return String.format("stoneCutter.addRecipe(%s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IIngredient.fromIngredient((Ingredient)recipe.m_7527_().get(0)).getCommandString());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super StonecutterRecipe> manager, StonecutterRecipe firstRecipe, U secondRecipe) {
        return false;
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super StonecutterRecipe> manager, StonecutterRecipe recipe) {
        IIngredient input = IIngredient.fromIngredient((Ingredient)recipe.m_7527_().get(0));
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.m_6076_()).with(BuiltinRecipeComponents.Input.INGREDIENTS, input).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.m_8043_())).build();
        return Optional.of(decomposedRecipe);
    }

    @Override
    public Optional<StonecutterRecipe> recompose(IRecipeManager<? super StonecutterRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        IIngredient input = recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        return Optional.of(new StonecutterRecipe(name, group, input.asVanillaIngredient(), output.getInternal()));
    }
}

