/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CTShapelessRecipeSerializer
implements RecipeSerializer<CTShapelessRecipe> {
    public static final CTShapelessRecipeSerializer INSTANCE = new CTShapelessRecipeSerializer();

    private CTShapelessRecipeSerializer() {
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_199568_0_.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public CTShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject jsonObject) {
        NonNullList<Ingredient> nonnulllist = CTShapelessRecipeSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
        IIngredient[] ingredients = new IIngredient[nonnulllist.size()];
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ingredients[i] = IIngredient.fromIngredient((Ingredient)nonnulllist.get(i));
        }
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
        return this.makeRecipe(recipeId, IItemStack.of(itemstack), ingredients, null);
    }

    public CTShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i = buffer.m_130242_();
        IIngredient[] ingredients = new IIngredient[i];
        for (int j = 0; j < ingredients.length; ++j) {
            ingredients[j] = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack output = buffer.m_130267_();
        return this.makeRecipe(recipeId, IItemStack.of(output), ingredients, null);
    }

    public void toNetwork(FriendlyByteBuf buffer, CTShapelessRecipe recipe) {
        buffer.m_130130_(recipe.m_7527_().size());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.m_8043_());
    }

    public CTShapelessRecipe makeRecipe(ResourceLocation recipeId, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        return new CTShapelessRecipe(recipeId.m_135815_(), output, ingredients, function);
    }
}

