/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.command;

import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.impl.network.message.MessageCopy;
import com.blamejared.crafttweaker.platform.Services;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Logger;

public final class CommandUtilities {
    public static final Logger COMMAND_LOGGER = CommonLoggers.commands();

    private CommandUtilities() {
    }

    public static void sendCopyingAndCopy(MutableComponent component, String toCopy, Player player) {
        CommandUtilities.sendCopying(component, toCopy, player);
        CommandUtilities.copy(player, toCopy);
    }

    public static void sendCopying(MutableComponent component, String toCopy, Player player) {
        CommandUtilities.send(CommandUtilities.copy(component, toCopy), player);
    }

    public static void send(Component component, CommandSourceStack source) {
        source.m_81354_(component, true);
        if (!component.getString().isBlank()) {
            COMMAND_LOGGER.info(component.getString());
        }
    }

    public static void send(Component component, Player player) {
        player.m_213846_(component);
        if (!component.getString().isBlank()) {
            COMMAND_LOGGER.info(component.getString());
        }
    }

    public static void copy(Player player, String toCopy) {
        if (player instanceof ServerPlayer) {
            Services.NETWORK.sendCopyMessage((ServerPlayer)player, new MessageCopy(toCopy));
        }
    }

    public static void open(Player player, Path path) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path.toString()).m_130940_(ChatFormatting.GOLD)});
        CommandUtilities.send((Component)component.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component.m_6881_())).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toString()))), player);
    }

    public static String stripNewLine(String string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static String stripNewLine(StringBuilder string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static Component copy(MutableComponent base, String toCopy) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.copy", (Object[])new Object[]{Component.m_237113_((String)toCopy).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy));
        return base.m_6270_(style);
    }

    public static Component open(MutableComponent base, String path) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
        return base.m_6270_(style);
    }

    public static Component run(MutableComponent base, String command) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.run", (Object[])new Object[]{Component.m_237113_((String)command).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        return base.m_6270_(style);
    }

    public static Component openingUrl(MutableComponent base, String url) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.goto", (Object[])new Object[]{Component.m_237113_((String)url).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
    }

    public static Component openingFile(MutableComponent base, String path) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
    }

    public static Component openingLogFile(MutableComponent base) {
        return CommandUtilities.openingFile(base, "logs/crafttweaker.log");
    }

    public static MutableComponent getFormattedLogFile() {
        return Component.m_237113_((String)"logs/crafttweaker.log").m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent makeNoticeable(MutableComponent text) {
        return text.m_130940_(ChatFormatting.YELLOW);
    }

    public static MutableComponent makeNoticeable(String text) {
        return CommandUtilities.makeNoticeable(Component.m_237113_((String)text));
    }
}

